/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.buffer.MessageBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.AbstractNioChannel;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    protected AbstractNioMessageChannel(Channel parent, Integer id, SelectableChannel ch, int readInterestOp) {
        super(parent, id, ch, readInterestOp);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioMessageUnsafe();
    }

    @Override
    protected void doFlushMessageBuffer(MessageBuf<Object> buf) throws Exception {
        int writeSpinCount = this.config().getWriteSpinCount() - 1;
        while (!buf.isEmpty()) {
            boolean wrote = false;
            for (int i = writeSpinCount; i >= 0; --i) {
                int localFlushedAmount = this.doWriteMessages(buf, i == 0);
                if (localFlushedAmount <= 0) continue;
                wrote = true;
                break;
            }
            if (wrote) continue;
            break;
        }
    }

    protected abstract int doReadMessages(MessageBuf<Object> var1) throws Exception;

    protected abstract int doWriteMessages(MessageBuf<Object> var1, boolean var2) throws Exception;

    private final class NioMessageUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private NioMessageUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read() {
            block18: {
                assert (AbstractNioMessageChannel.this.eventLoop().inEventLoop());
                SelectionKey key = AbstractNioMessageChannel.this.selectionKey();
                if (!AbstractNioMessageChannel.this.config().isAutoRead()) {
                    key.interestOps(key.interestOps() & ~AbstractNioMessageChannel.this.readInterestOp);
                }
                ChannelPipeline pipeline = AbstractNioMessageChannel.this.pipeline();
                MessageBuf<Object> msgBuf = pipeline.inboundMessageBuffer();
                boolean closed = false;
                boolean read = false;
                boolean firedChannelReadSuspended = false;
                try {
                    while (true) {
                        int localReadAmount;
                        if ((localReadAmount = AbstractNioMessageChannel.this.doReadMessages(msgBuf)) > 0) {
                            read = true;
                            continue;
                        }
                        if (localReadAmount == 0) {
                            break block18;
                        }
                        if (localReadAmount < 0) break;
                    }
                    closed = true;
                }
                catch (Throwable t) {
                    if (read) {
                        read = false;
                        pipeline.fireInboundBufferUpdated();
                    }
                    if (t instanceof IOException) {
                        closed = true;
                    } else if (!closed) {
                        firedChannelReadSuspended = true;
                        pipeline.fireChannelReadSuspended();
                    }
                    AbstractNioMessageChannel.this.pipeline().fireExceptionCaught(t);
                }
                finally {
                    if (read) {
                        pipeline.fireInboundBufferUpdated();
                    }
                    if (closed && AbstractNioMessageChannel.this.isOpen()) {
                        this.close(this.voidFuture());
                    } else if (!firedChannelReadSuspended) {
                        pipeline.fireChannelReadSuspended();
                    }
                }
            }
        }
    }
}

