/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.NBTBase;

public class NBTTagList
extends NBTBase {
    private List list = new ArrayList();
    private byte type;

    public NBTTagList() {
        super("");
    }

    public NBTTagList(String string) {
        super(string);
    }

    void write(DataOutput dataOutput) {
        this.type = !this.list.isEmpty() ? ((NBTBase)this.list.get(0)).getTypeId() : (byte)1;
        dataOutput.writeByte(this.type);
        dataOutput.writeInt(this.list.size());
        for (NBTBase nBTBase : this.list) {
            nBTBase.write(dataOutput);
        }
    }

    void load(DataInput dataInput) {
        this.type = dataInput.readByte();
        int n = dataInput.readInt();
        this.list = new ArrayList();
        for (int i = 0; i < n; ++i) {
            NBTBase nBTBase = NBTBase.createTag(this.type, null);
            nBTBase.load(dataInput);
            this.list.add(nBTBase);
        }
    }

    public byte getTypeId() {
        return 9;
    }

    public String toString() {
        return "" + this.list.size() + " entries of type " + NBTBase.getTagName(this.type);
    }

    public void add(NBTBase nBTBase) {
        this.type = nBTBase.getTypeId();
        this.list.add(nBTBase);
    }

    public NBTBase get(int n) {
        return (NBTBase)this.list.get(n);
    }

    public int size() {
        return this.list.size();
    }

    public NBTBase clone() {
        NBTTagList nBTTagList = new NBTTagList(this.getName());
        nBTTagList.type = this.type;
        for (NBTBase nBTBase : this.list) {
            NBTBase nBTBase2 = nBTBase.clone();
            nBTTagList.list.add(nBTBase2);
        }
        return nBTTagList;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagList nBTTagList = (NBTTagList)object;
            if (this.type == nBTTagList.type) {
                return ((Object)this.list).equals(nBTTagList.list);
            }
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ ((Object)this.list).hashCode();
    }
}

