/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityDamageSourceIndirect;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityEnderman
extends EntityMonster {
    private static boolean[] d = new boolean[256];
    private int e = 0;
    private int g = 0;

    public EntityEnderman(World world) {
        super(world);
        this.texture = "/mob/enderman.png";
        this.bw = 0.2f;
        this.damage = 7;
        this.a(0.6f, 2.9f);
        this.W = 1.0f;
    }

    public int getMaxHealth() {
        return 40;
    }

    protected void a() {
        super.a();
        this.datawatcher.a(16, new Byte(0));
        this.datawatcher.a(17, new Byte(0));
        this.datawatcher.a(18, new Byte(0));
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setShort("carried", (short)this.getCarriedId());
        nBTTagCompound.setShort("carriedData", (short)this.getCarriedData());
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setCarriedId(nBTTagCompound.getShort("carried"));
        this.setCarriedData(nBTTagCompound.getShort("carriedData"));
    }

    protected Entity findTarget() {
        EntityHuman entityHuman = this.world.findNearbyVulnerablePlayer(this, 64.0);
        if (entityHuman != null) {
            if (this.d(entityHuman)) {
                if (this.g++ == 5) {
                    this.g = 0;
                    this.e(true);
                    return entityHuman;
                }
            } else {
                this.g = 0;
            }
        }
        return null;
    }

    private boolean d(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.armor[3];
        if (itemStack != null && itemStack.id == Block.PUMPKIN.id) {
            return false;
        }
        Vec3D vec3D = entityHuman.i(1.0f).b();
        Vec3D vec3D2 = Vec3D.a().create(this.locX - entityHuman.locX, this.boundingBox.b + (double)(this.length / 2.0f) - (entityHuman.locY + (double)entityHuman.getHeadHeight()), this.locZ - entityHuman.locZ);
        double d = vec3D2.c();
        double d2 = vec3D.b(vec3D2 = vec3D2.b());
        if (d2 > 1.0 - 0.025 / d) {
            return entityHuman.l(this);
        }
        return false;
    }

    public void d() {
        float f;
        int n;
        if (this.G()) {
            this.damageEntity(DamageSource.DROWN, 1);
        }
        float f2 = this.bw = this.target != null ? 6.5f : 0.3f;
        if (!this.world.isStatic) {
            int n2;
            int n3;
            int n4;
            if (this.getCarriedId() == 0) {
                if (this.random.nextInt(20) == 0 && d[n4 = this.world.getTypeId(n = MathHelper.floor(this.locX - 2.0 + this.random.nextDouble() * 4.0), n3 = MathHelper.floor(this.locY + this.random.nextDouble() * 3.0), n2 = MathHelper.floor(this.locZ - 2.0 + this.random.nextDouble() * 4.0))]) {
                    this.setCarriedId(this.world.getTypeId(n, n3, n2));
                    this.setCarriedData(this.world.getData(n, n3, n2));
                    this.world.setTypeId(n, n3, n2, 0);
                }
            } else if (this.random.nextInt(2000) == 0) {
                n = MathHelper.floor(this.locX - 1.0 + this.random.nextDouble() * 2.0);
                n3 = MathHelper.floor(this.locY + this.random.nextDouble() * 2.0);
                n2 = MathHelper.floor(this.locZ - 1.0 + this.random.nextDouble() * 2.0);
                n4 = this.world.getTypeId(n, n3, n2);
                int n5 = this.world.getTypeId(n, n3 - 1, n2);
                if (n4 == 0 && n5 > 0 && Block.byId[n5].c()) {
                    this.world.setTypeIdAndData(n, n3, n2, this.getCarriedId(), this.getCarriedData());
                    this.setCarriedId(0);
                }
            }
        }
        for (n = 0; n < 2; ++n) {
            this.world.a("portal", this.locX + (this.random.nextDouble() - 0.5) * (double)this.width, this.locY + this.random.nextDouble() * (double)this.length - 0.25, this.locZ + (this.random.nextDouble() - 0.5) * (double)this.width, (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
        }
        if (this.world.s() && !this.world.isStatic && (f = this.c(1.0f)) > 0.5f && this.world.j(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.target = null;
            this.e(false);
            this.n();
        }
        if (this.G()) {
            this.target = null;
            this.e(false);
            this.n();
        }
        this.bu = false;
        if (this.target != null) {
            this.a(this.target, 100.0f, 100.0f);
        }
        if (!this.world.isStatic && this.isAlive()) {
            if (this.target != null) {
                if (this.target instanceof EntityHuman && this.d((EntityHuman)this.target)) {
                    this.bs = 0.0f;
                    this.br = 0.0f;
                    this.bw = 0.0f;
                    if (this.target.e(this) < 16.0) {
                        this.n();
                    }
                    this.e = 0;
                } else if (this.target.e(this) > 256.0 && this.e++ >= 30 && this.c(this.target)) {
                    this.e = 0;
                }
            } else {
                this.e(false);
                this.e = 0;
            }
        }
        super.d();
    }

    protected boolean n() {
        double d = this.locX + (this.random.nextDouble() - 0.5) * 64.0;
        double d2 = this.locY + (double)(this.random.nextInt(64) - 32);
        double d3 = this.locZ + (this.random.nextDouble() - 0.5) * 64.0;
        return this.j(d, d2, d3);
    }

    protected boolean c(Entity entity) {
        Vec3D vec3D = Vec3D.a().create(this.locX - entity.locX, this.boundingBox.b + (double)(this.length / 2.0f) - entity.locY + (double)entity.getHeadHeight(), this.locZ - entity.locZ);
        vec3D = vec3D.b();
        double d = 16.0;
        double d2 = this.locX + (this.random.nextDouble() - 0.5) * 8.0 - vec3D.a * d;
        double d3 = this.locY + (double)(this.random.nextInt(16) - 8) - vec3D.b * d;
        double d4 = this.locZ + (this.random.nextDouble() - 0.5) * 8.0 - vec3D.c * d;
        return this.j(d2, d3, d4);
    }

    protected boolean j(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        int n4;
        double d4 = this.locX;
        double d5 = this.locY;
        double d6 = this.locZ;
        this.locX = d;
        this.locY = d2;
        this.locZ = d3;
        boolean bl = false;
        int n5 = MathHelper.floor(this.locX);
        if (this.world.isLoaded(n5, n4 = MathHelper.floor(this.locY), n3 = MathHelper.floor(this.locZ))) {
            n2 = 0;
            while (n2 == 0 && n4 > 0) {
                n = this.world.getTypeId(n5, n4 - 1, n3);
                if (n == 0 || !Block.byId[n].material.isSolid()) {
                    this.locY -= 1.0;
                    --n4;
                    continue;
                }
                n2 = 1;
            }
            if (n2 != 0) {
                this.setPosition(this.locX, this.locY, this.locZ);
                if (this.world.getCubes(this, this.boundingBox).isEmpty() && !this.world.containsLiquid(this.boundingBox)) {
                    bl = true;
                }
            }
        }
        if (bl) {
            n2 = 128;
            for (n = 0; n < n2; ++n) {
                double d7 = (double)n / ((double)n2 - 1.0);
                float f = (this.random.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.random.nextFloat() - 0.5f) * 0.2f;
                float f3 = (this.random.nextFloat() - 0.5f) * 0.2f;
                double d8 = d4 + (this.locX - d4) * d7 + (this.random.nextDouble() - 0.5) * (double)this.width * 2.0;
                double d9 = d5 + (this.locY - d5) * d7 + this.random.nextDouble() * (double)this.length;
                double d10 = d6 + (this.locZ - d6) * d7 + (this.random.nextDouble() - 0.5) * (double)this.width * 2.0;
                this.world.a("portal", d8, d9, d10, f, f2, f3);
            }
            this.world.makeSound(d4, d5, d6, "mob.endermen.portal", 1.0f, 1.0f);
            this.world.makeSound(this, "mob.endermen.portal", 1.0f, 1.0f);
            return true;
        }
        this.setPosition(d4, d5, d6);
        return false;
    }

    protected String aQ() {
        return "mob.endermen.idle";
    }

    protected String aR() {
        return "mob.endermen.hit";
    }

    protected String aS() {
        return "mob.endermen.death";
    }

    protected int getLootId() {
        return Item.ENDER_PEARL.id;
    }

    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.getLootId();
        if (n2 > 0) {
            int n3 = this.random.nextInt(2 + n);
            for (int i = 0; i < n3; ++i) {
                this.b(n2, 1);
            }
        }
    }

    public void setCarriedId(int n) {
        this.datawatcher.watch(16, (byte)(n & 0xFF));
    }

    public int getCarriedId() {
        return this.datawatcher.getByte(16);
    }

    public void setCarriedData(int n) {
        this.datawatcher.watch(17, (byte)(n & 0xFF));
    }

    public int getCarriedData() {
        return this.datawatcher.getByte(17);
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (damageSource instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 64; ++i) {
                if (!this.n()) continue;
                return true;
            }
            return false;
        }
        if (damageSource.getEntity() instanceof EntityHuman) {
            this.e(true);
        }
        return super.damageEntity(damageSource, n);
    }

    public void e(boolean bl) {
        this.datawatcher.watch(18, (byte)(bl ? 1 : 0));
    }

    static {
        EntityEnderman.d[Block.GRASS.id] = true;
        EntityEnderman.d[Block.DIRT.id] = true;
        EntityEnderman.d[Block.SAND.id] = true;
        EntityEnderman.d[Block.GRAVEL.id] = true;
        EntityEnderman.d[Block.YELLOW_FLOWER.id] = true;
        EntityEnderman.d[Block.RED_ROSE.id] = true;
        EntityEnderman.d[Block.BROWN_MUSHROOM.id] = true;
        EntityEnderman.d[Block.RED_MUSHROOM.id] = true;
        EntityEnderman.d[Block.TNT.id] = true;
        EntityEnderman.d[Block.CACTUS.id] = true;
        EntityEnderman.d[Block.CLAY.id] = true;
        EntityEnderman.d[Block.PUMPKIN.id] = true;
        EntityEnderman.d[Block.MELON.id] = true;
        EntityEnderman.d[Block.MYCEL.id] = true;
    }
}

