/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.ChunkSection;
import net.minecraft.server.Entity;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;
import net.minecraft.server.WorldChunkManager;

public class Chunk {
    public static boolean a;
    private ChunkSection[] sections = new ChunkSection[16];
    private byte[] r = new byte[256];
    public int[] b = new int[256];
    public boolean[] c = new boolean[256];
    public boolean d;
    public World world;
    public int[] heightMap;
    public final int x;
    public final int z;
    private boolean s = false;
    public Map tileEntities = new HashMap();
    public List[] entitySlices = new List[16];
    public boolean done = false;
    public boolean l = false;
    public boolean m = false;
    public long n = 0L;
    public boolean seenByPlayer = false;
    private int t = 4096;
    boolean p = false;

    public Chunk(World world, int n, int n2) {
        this.world = world;
        this.x = n;
        this.z = n2;
        this.heightMap = new int[256];
        for (int i = 0; i < this.entitySlices.length; ++i) {
            this.entitySlices[i] = new ArrayList();
        }
        Arrays.fill(this.b, -999);
        Arrays.fill(this.r, (byte)-1);
    }

    public Chunk(World world, byte[] byArray, int n, int n2) {
        this(world, n, n2);
        int n3 = byArray.length / 256;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < n3; ++k) {
                    byte by = byArray[i << 11 | j << 7 | k];
                    if (by == 0) continue;
                    int n4 = k >> 4;
                    if (this.sections[n4] == null) {
                        this.sections[n4] = new ChunkSection(n4 << 4);
                    }
                    this.sections[n4].a(i, k & 0xF, j, by);
                }
            }
        }
    }

    public boolean a(int n, int n2) {
        return n == this.x && n2 == this.z;
    }

    public int b(int n, int n2) {
        return this.heightMap[n2 << 4 | n];
    }

    public int h() {
        for (int i = this.sections.length - 1; i >= 0; --i) {
            if (this.sections[i] == null) continue;
            return this.sections[i].d();
        }
        return 0;
    }

    public ChunkSection[] i() {
        return this.sections;
    }

    public void initLighting() {
        int n;
        int n2;
        int n3 = this.h();
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                int n4;
                this.b[n2 + (n << 4)] = -999;
                for (n4 = n3 + 16 - 1; n4 > 0; --n4) {
                    if (this.b(n2, n4 - 1, n) == 0) continue;
                    this.heightMap[n << 4 | n2] = n4;
                    break;
                }
                if (this.world.worldProvider.e) continue;
                n4 = 15;
                int n5 = n3 + 16 - 1;
                do {
                    ChunkSection chunkSection;
                    if ((n4 -= this.b(n2, n5, n)) <= 0 || (chunkSection = this.sections[n5 >> 4]) == null) continue;
                    chunkSection.c(n2, n5 & 0xF, n, n4);
                    this.world.n((this.x << 4) + n2, n5, (this.z << 4) + n);
                } while (--n5 > 0 && n4 > 0);
            }
        }
        this.l = true;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                this.e(n2, n);
            }
        }
    }

    private void e(int n, int n2) {
        this.c[n + n2 * 16] = true;
        this.s = true;
    }

    private void q() {
        this.world.methodProfiler.a("recheckGaps");
        if (this.world.areChunksLoaded(this.x * 16 + 8, 0, this.z * 16 + 8, 16)) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (!this.c[i + j * 16]) continue;
                    this.c[i + j * 16] = false;
                    int n = this.b(i, j);
                    int n2 = this.x * 16 + i;
                    int n3 = this.z * 16 + j;
                    int n4 = this.world.getHighestBlockYAt(n2 - 1, n3);
                    int n5 = this.world.getHighestBlockYAt(n2 + 1, n3);
                    int n6 = this.world.getHighestBlockYAt(n2, n3 - 1);
                    int n7 = this.world.getHighestBlockYAt(n2, n3 + 1);
                    if (n5 < n4) {
                        n4 = n5;
                    }
                    if (n6 < n4) {
                        n4 = n6;
                    }
                    if (n7 < n4) {
                        n4 = n7;
                    }
                    this.g(n2, n3, n4);
                    this.g(n2 - 1, n3, n);
                    this.g(n2 + 1, n3, n);
                    this.g(n2, n3 - 1, n);
                    this.g(n2, n3 + 1, n);
                }
            }
            this.s = false;
        }
        this.world.methodProfiler.b();
    }

    private void g(int n, int n2, int n3) {
        int n4 = this.world.getHighestBlockYAt(n, n2);
        if (n4 > n3) {
            this.d(n, n2, n3, n4 + 1);
        } else if (n4 < n3) {
            this.d(n, n2, n4, n3 + 1);
        }
    }

    private void d(int n, int n2, int n3, int n4) {
        if (n4 > n3 && this.world.areChunksLoaded(n, 0, n2, 16)) {
            for (int i = n3; i < n4; ++i) {
                this.world.c(EnumSkyBlock.SKY, n, i, n2);
            }
            this.l = true;
        }
    }

    private void h(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n7 = this.heightMap[n3 << 4 | n] & 0xFF;
        if (n2 > n7) {
            n8 = n2;
        }
        while (n8 > 0 && this.b(n, n8 - 1, n3) == 0) {
            --n8;
        }
        if (n8 == n7) {
            return;
        }
        this.world.g(n + this.x * 16, n3 + this.z * 16, n8, n7);
        this.heightMap[n3 << 4 | n] = n8;
        int n9 = this.x * 16 + n;
        int n10 = this.z * 16 + n3;
        if (!this.world.worldProvider.e) {
            ChunkSection chunkSection;
            if (n8 < n7) {
                for (n6 = n8; n6 < n7; ++n6) {
                    chunkSection = this.sections[n6 >> 4];
                    if (chunkSection == null) continue;
                    chunkSection.c(n, n6 & 0xF, n3, 15);
                    this.world.n((this.x << 4) + n, n6, (this.z << 4) + n3);
                }
            } else {
                for (n6 = n7; n6 < n8; ++n6) {
                    chunkSection = this.sections[n6 >> 4];
                    if (chunkSection == null) continue;
                    chunkSection.c(n, n6 & 0xF, n3, 0);
                    this.world.n((this.x << 4) + n, n6, (this.z << 4) + n3);
                }
            }
            n6 = 15;
            while (n8 > 0 && n6 > 0) {
                ChunkSection chunkSection2;
                int n11;
                if ((n11 = this.b(n, --n8, n3)) == 0) {
                    n11 = 1;
                }
                if ((n6 -= n11) < 0) {
                    n6 = 0;
                }
                if ((chunkSection2 = this.sections[n8 >> 4]) == null) continue;
                chunkSection2.c(n, n8 & 0xF, n3, n6);
            }
        }
        if ((n5 = (n6 = this.heightMap[n3 << 4 | n])) < (n4 = n7)) {
            int n12 = n4;
            n4 = n5;
            n5 = n12;
        }
        if (!this.world.worldProvider.e) {
            this.d(n9 - 1, n10, n4, n5);
            this.d(n9 + 1, n10, n4, n5);
            this.d(n9, n10 - 1, n4, n5);
            this.d(n9, n10 + 1, n4, n5);
            this.d(n9, n10, n4, n5);
        }
        this.l = true;
    }

    public int b(int n, int n2, int n3) {
        return Block.lightBlock[this.getTypeId(n, n2, n3)];
    }

    public int getTypeId(int n, int n2, int n3) {
        if (n2 >> 4 >= this.sections.length) {
            return 0;
        }
        ChunkSection chunkSection = this.sections[n2 >> 4];
        if (chunkSection != null) {
            return chunkSection.a(n, n2 & 0xF, n3);
        }
        return 0;
    }

    public int getData(int n, int n2, int n3) {
        if (n2 >> 4 >= this.sections.length) {
            return 0;
        }
        ChunkSection chunkSection = this.sections[n2 >> 4];
        if (chunkSection != null) {
            return chunkSection.b(n, n2 & 0xF, n3);
        }
        return 0;
    }

    public boolean a(int n, int n2, int n3, int n4) {
        return this.a(n, n2, n3, n4, 0);
    }

    public boolean a(int n, int n2, int n3, int n4, int n5) {
        TileEntity tileEntity;
        int n6 = n3 << 4 | n;
        if (n2 >= this.b[n6] - 1) {
            this.b[n6] = -999;
        }
        int n7 = this.heightMap[n6];
        int n8 = this.getTypeId(n, n2, n3);
        int n9 = this.getData(n, n2, n3);
        if (n8 == n4 && n9 == n5) {
            return false;
        }
        ChunkSection chunkSection = this.sections[n2 >> 4];
        boolean bl = false;
        if (chunkSection == null) {
            if (n4 == 0) {
                return false;
            }
            ChunkSection chunkSection2 = new ChunkSection(n2 >> 4 << 4);
            this.sections[n2 >> 4] = chunkSection2;
            chunkSection = chunkSection2;
            bl = n2 >= n7;
        }
        int n10 = this.x * 16 + n;
        int n11 = this.z * 16 + n3;
        if (n8 != 0 && !this.world.isStatic) {
            Block.byId[n8].h(this.world, n10, n2, n11, n9);
        }
        chunkSection.a(n, n2 & 0xF, n3, n4);
        if (n8 != 0) {
            if (!this.world.isStatic) {
                Block.byId[n8].remove(this.world, n10, n2, n11, n8, n9);
            } else if (Block.byId[n8] instanceof BlockContainer && n8 != n4) {
                this.world.q(n10, n2, n11);
            }
        }
        if (chunkSection.a(n, n2 & 0xF, n3) != n4) {
            return false;
        }
        chunkSection.b(n, n2 & 0xF, n3, n5);
        if (bl) {
            this.initLighting();
        } else {
            if (Block.lightBlock[n4 & 0xFFF] > 0) {
                if (n2 >= n7) {
                    this.h(n, n2 + 1, n3);
                }
            } else if (n2 == n7 - 1) {
                this.h(n, n2, n3);
            }
            this.e(n, n3);
        }
        if (n4 != 0) {
            if (!this.world.isStatic) {
                Block.byId[n4].onPlace(this.world, n10, n2, n11);
            }
            if (Block.byId[n4] instanceof BlockContainer) {
                TileEntity tileEntity2 = this.e(n, n2, n3);
                if (tileEntity2 == null) {
                    tileEntity2 = ((BlockContainer)Block.byId[n4]).a(this.world);
                    this.world.setTileEntity(n10, n2, n11, tileEntity2);
                }
                if (tileEntity2 != null) {
                    tileEntity2.h();
                }
            }
        } else if (n8 > 0 && Block.byId[n8] instanceof BlockContainer && (tileEntity = this.e(n, n2, n3)) != null) {
            tileEntity.h();
        }
        this.l = true;
        return true;
    }

    public boolean b(int n, int n2, int n3, int n4) {
        TileEntity tileEntity;
        ChunkSection chunkSection = this.sections[n2 >> 4];
        if (chunkSection == null) {
            return false;
        }
        int n5 = chunkSection.b(n, n2 & 0xF, n3);
        if (n5 == n4) {
            return false;
        }
        this.l = true;
        chunkSection.b(n, n2 & 0xF, n3, n4);
        int n6 = chunkSection.a(n, n2 & 0xF, n3);
        if (n6 > 0 && Block.byId[n6] instanceof BlockContainer && (tileEntity = this.e(n, n2, n3)) != null) {
            tileEntity.h();
            tileEntity.p = n4;
        }
        return true;
    }

    public int getBrightness(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        ChunkSection chunkSection = this.sections[n2 >> 4];
        if (chunkSection == null) {
            if (this.d(n, n2, n3)) {
                return enumSkyBlock.c;
            }
            return 0;
        }
        if (enumSkyBlock == EnumSkyBlock.SKY) {
            return chunkSection.c(n, n2 & 0xF, n3);
        }
        if (enumSkyBlock == EnumSkyBlock.BLOCK) {
            return chunkSection.d(n, n2 & 0xF, n3);
        }
        return enumSkyBlock.c;
    }

    public void a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4) {
        ChunkSection chunkSection = this.sections[n2 >> 4];
        if (chunkSection == null) {
            ChunkSection chunkSection2 = new ChunkSection(n2 >> 4 << 4);
            this.sections[n2 >> 4] = chunkSection2;
            chunkSection = chunkSection2;
            this.initLighting();
        }
        this.l = true;
        if (enumSkyBlock == EnumSkyBlock.SKY) {
            if (!this.world.worldProvider.e) {
                chunkSection.c(n, n2 & 0xF, n3, n4);
            }
        } else if (enumSkyBlock == EnumSkyBlock.BLOCK) {
            chunkSection.d(n, n2 & 0xF, n3, n4);
        }
    }

    public int c(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        ChunkSection chunkSection = this.sections[n2 >> 4];
        if (chunkSection == null) {
            if (!this.world.worldProvider.e && n4 < EnumSkyBlock.SKY.c) {
                return EnumSkyBlock.SKY.c - n4;
            }
            return 0;
        }
        int n7 = n6 = this.world.worldProvider.e ? 0 : chunkSection.c(n, n2 & 0xF, n3);
        if (n6 > 0) {
            a = true;
        }
        if ((n5 = chunkSection.d(n, n2 & 0xF, n3)) > (n6 -= n4)) {
            n6 = n5;
        }
        return n6;
    }

    public void a(Entity entity) {
        int n;
        this.m = true;
        int n2 = MathHelper.floor(entity.locX / 16.0);
        int n3 = MathHelper.floor(entity.locZ / 16.0);
        if (n2 != this.x || n3 != this.z) {
            System.out.println("Wrong location! " + entity);
            Thread.dumpStack();
        }
        if ((n = MathHelper.floor(entity.locY / 16.0)) < 0) {
            n = 0;
        }
        if (n >= this.entitySlices.length) {
            n = this.entitySlices.length - 1;
        }
        entity.ag = true;
        entity.ah = this.x;
        entity.ai = n;
        entity.aj = this.z;
        this.entitySlices[n].add(entity);
    }

    public void b(Entity entity) {
        this.a(entity, entity.ai);
    }

    public void a(Entity entity, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.entitySlices.length) {
            n = this.entitySlices.length - 1;
        }
        this.entitySlices[n].remove(entity);
    }

    public boolean d(int n, int n2, int n3) {
        return n2 >= this.heightMap[n3 << 4 | n];
    }

    public TileEntity e(int n, int n2, int n3) {
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        TileEntity tileEntity = (TileEntity)this.tileEntities.get(chunkPosition);
        if (tileEntity == null) {
            int n4 = this.getTypeId(n, n2, n3);
            if (n4 <= 0 || !Block.byId[n4].s()) {
                return null;
            }
            if (tileEntity == null) {
                tileEntity = ((BlockContainer)Block.byId[n4]).a(this.world);
                this.world.setTileEntity(this.x * 16 + n, n2, this.z * 16 + n3, tileEntity);
            }
            tileEntity = (TileEntity)this.tileEntities.get(chunkPosition);
        }
        if (tileEntity != null && tileEntity.p()) {
            this.tileEntities.remove(chunkPosition);
            return null;
        }
        return tileEntity;
    }

    public void a(TileEntity tileEntity) {
        int n = tileEntity.x - this.x * 16;
        int n2 = tileEntity.y;
        int n3 = tileEntity.z - this.z * 16;
        this.a(n, n2, n3, tileEntity);
        if (this.d) {
            this.world.tileEntityList.add(tileEntity);
        }
    }

    public void a(int n, int n2, int n3, TileEntity tileEntity) {
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        tileEntity.a(this.world);
        tileEntity.x = this.x * 16 + n;
        tileEntity.y = n2;
        tileEntity.z = this.z * 16 + n3;
        if (this.getTypeId(n, n2, n3) == 0 || !(Block.byId[this.getTypeId(n, n2, n3)] instanceof BlockContainer)) {
            return;
        }
        tileEntity.q();
        this.tileEntities.put(chunkPosition, tileEntity);
    }

    public void f(int n, int n2, int n3) {
        TileEntity tileEntity;
        ChunkPosition chunkPosition = new ChunkPosition(n, n2, n3);
        if (this.d && (tileEntity = (TileEntity)this.tileEntities.remove(chunkPosition)) != null) {
            tileEntity.j();
        }
    }

    public void addEntities() {
        this.d = true;
        this.world.a(this.tileEntities.values());
        for (List list : this.entitySlices) {
            this.world.a(list);
        }
    }

    public void removeEntities() {
        this.d = false;
        for (TileEntity tileEntity : this.tileEntities.values()) {
            this.world.a(tileEntity);
        }
        for (List list : this.entitySlices) {
            this.world.b(list);
        }
    }

    public void e() {
        this.l = true;
    }

    public void a(Entity entity, AxisAlignedBB axisAlignedBB, List list) {
        int n = MathHelper.floor((axisAlignedBB.b - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.e + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.entitySlices.length) {
            n2 = this.entitySlices.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            List list2 = this.entitySlices[i];
            for (Entity entity2 : list2) {
                if (entity2 == entity || !entity2.boundingBox.a(axisAlignedBB)) continue;
                list.add(entity2);
                Entity[] entityArray = entity2.al();
                if (entityArray == null) continue;
                for (int j = 0; j < entityArray.length; ++j) {
                    entity2 = entityArray[j];
                    if (entity2 == entity || !entity2.boundingBox.a(axisAlignedBB)) continue;
                    list.add(entity2);
                }
            }
        }
    }

    public void a(Class clazz, AxisAlignedBB axisAlignedBB, List list) {
        int n = MathHelper.floor((axisAlignedBB.b - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.e + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        } else if (n >= this.entitySlices.length) {
            n = this.entitySlices.length - 1;
        }
        if (n2 >= this.entitySlices.length) {
            n2 = this.entitySlices.length - 1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        for (int i = n; i <= n2; ++i) {
            List list2 = this.entitySlices[i];
            for (Entity entity : list2) {
                if (!clazz.isAssignableFrom(entity.getClass()) || !entity.boundingBox.a(axisAlignedBB)) continue;
                list.add(entity);
            }
        }
    }

    public boolean a(boolean bl) {
        if (bl ? this.m && this.world.getTime() != this.n : this.m && this.world.getTime() >= this.n + 600L) {
            return true;
        }
        return this.l;
    }

    public Random a(long l) {
        return new Random(this.world.getSeed() + (long)(this.x * this.x * 4987142) + (long)(this.x * 5947611) + (long)(this.z * this.z) * 4392871L + (long)(this.z * 389711) ^ l);
    }

    public boolean isEmpty() {
        return false;
    }

    public void a(IChunkProvider iChunkProvider, IChunkProvider iChunkProvider2, int n, int n2) {
        if (!this.done && iChunkProvider.isChunkLoaded(n + 1, n2 + 1) && iChunkProvider.isChunkLoaded(n, n2 + 1) && iChunkProvider.isChunkLoaded(n + 1, n2)) {
            iChunkProvider.getChunkAt(iChunkProvider2, n, n2);
        }
        if (iChunkProvider.isChunkLoaded(n - 1, n2) && !iChunkProvider.getOrCreateChunk((int)(n - 1), (int)n2).done && iChunkProvider.isChunkLoaded(n - 1, n2 + 1) && iChunkProvider.isChunkLoaded(n, n2 + 1) && iChunkProvider.isChunkLoaded(n - 1, n2 + 1)) {
            iChunkProvider.getChunkAt(iChunkProvider2, n - 1, n2);
        }
        if (iChunkProvider.isChunkLoaded(n, n2 - 1) && !iChunkProvider.getOrCreateChunk((int)n, (int)(n2 - 1)).done && iChunkProvider.isChunkLoaded(n + 1, n2 - 1) && iChunkProvider.isChunkLoaded(n + 1, n2 - 1) && iChunkProvider.isChunkLoaded(n + 1, n2)) {
            iChunkProvider.getChunkAt(iChunkProvider2, n, n2 - 1);
        }
        if (iChunkProvider.isChunkLoaded(n - 1, n2 - 1) && !iChunkProvider.getOrCreateChunk((int)(n - 1), (int)(n2 - 1)).done && iChunkProvider.isChunkLoaded(n, n2 - 1) && iChunkProvider.isChunkLoaded(n - 1, n2)) {
            iChunkProvider.getChunkAt(iChunkProvider2, n - 1, n2 - 1);
        }
    }

    public int d(int n, int n2) {
        int n3 = n | n2 << 4;
        int n4 = this.b[n3];
        if (n4 == -999) {
            int n5 = this.h() + 15;
            n4 = -1;
            while (n5 > 0 && n4 == -1) {
                Material material;
                int n6 = this.getTypeId(n, n5, n2);
                Material material2 = material = n6 == 0 ? Material.AIR : Block.byId[n6].material;
                if (!material.isSolid() && !material.isLiquid()) {
                    --n5;
                    continue;
                }
                n4 = n5 + 1;
            }
            this.b[n3] = n4;
        }
        return n4;
    }

    public void k() {
        if (this.s && !this.world.worldProvider.e) {
            this.q();
        }
    }

    public ChunkCoordIntPair l() {
        return new ChunkCoordIntPair(this.x, this.z);
    }

    public boolean c(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        for (int i = n; i <= n2; i += 16) {
            ChunkSection chunkSection = this.sections[i >> 4];
            if (chunkSection == null || chunkSection.a()) continue;
            return false;
        }
        return true;
    }

    public void a(ChunkSection[] chunkSectionArray) {
        this.sections = chunkSectionArray;
    }

    public BiomeBase a(int n, int n2, WorldChunkManager worldChunkManager) {
        int n3 = this.r[n2 << 4 | n] & 0xFF;
        if (n3 == 255) {
            BiomeBase biomeBase = worldChunkManager.getBiome((this.x << 4) + n, (this.z << 4) + n2);
            n3 = biomeBase.id;
            this.r[n2 << 4 | n] = (byte)(n3 & 0xFF);
        }
        if (BiomeBase.biomes[n3] == null) {
            return BiomeBase.PLAINS;
        }
        return BiomeBase.biomes[n3];
    }

    public byte[] m() {
        return this.r;
    }

    public void a(byte[] byArray) {
        this.r = byArray;
    }

    public void n() {
        this.t = 0;
    }

    public void o() {
        for (int i = 0; i < 8; ++i) {
            if (this.t >= 4096) {
                return;
            }
            int n = this.t % 16;
            int n2 = this.t / 16 % 16;
            int n3 = this.t / 256;
            ++this.t;
            int n4 = (this.x << 4) + n2;
            int n5 = (this.z << 4) + n3;
            for (int j = 0; j < 16; ++j) {
                int n6 = (n << 4) + j;
                if ((this.sections[n] != null || j != 0 && j != 15 && n2 != 0 && n2 != 15 && n3 != 0 && n3 != 15) && (this.sections[n] == null || this.sections[n].a(n2, j, n3) != 0)) continue;
                if (Block.lightEmission[this.world.getTypeId(n4, n6 - 1, n5)] > 0) {
                    this.world.x(n4, n6 - 1, n5);
                }
                if (Block.lightEmission[this.world.getTypeId(n4, n6 + 1, n5)] > 0) {
                    this.world.x(n4, n6 + 1, n5);
                }
                if (Block.lightEmission[this.world.getTypeId(n4 - 1, n6, n5)] > 0) {
                    this.world.x(n4 - 1, n6, n5);
                }
                if (Block.lightEmission[this.world.getTypeId(n4 + 1, n6, n5)] > 0) {
                    this.world.x(n4 + 1, n6, n5);
                }
                if (Block.lightEmission[this.world.getTypeId(n4, n6, n5 - 1)] > 0) {
                    this.world.x(n4, n6, n5 - 1);
                }
                if (Block.lightEmission[this.world.getTypeId(n4, n6, n5 + 1)] > 0) {
                    this.world.x(n4, n6, n5 + 1);
                }
                this.world.x(n4, n6, n5);
            }
        }
    }
}

