/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BlockBed;
import net.minecraft.server.BlockBloodStone;
import net.minecraft.server.BlockBookshelf;
import net.minecraft.server.BlockBrewingStand;
import net.minecraft.server.BlockButton;
import net.minecraft.server.BlockCactus;
import net.minecraft.server.BlockCake;
import net.minecraft.server.BlockCauldron;
import net.minecraft.server.BlockChest;
import net.minecraft.server.BlockClay;
import net.minecraft.server.BlockCloth;
import net.minecraft.server.BlockCocoa;
import net.minecraft.server.BlockCrops;
import net.minecraft.server.BlockDeadBush;
import net.minecraft.server.BlockDiode;
import net.minecraft.server.BlockDirt;
import net.minecraft.server.BlockDispenser;
import net.minecraft.server.BlockDoor;
import net.minecraft.server.BlockDragonEgg;
import net.minecraft.server.BlockEnchantmentTable;
import net.minecraft.server.BlockEnderChest;
import net.minecraft.server.BlockEnderPortal;
import net.minecraft.server.BlockEnderPortalFrame;
import net.minecraft.server.BlockFence;
import net.minecraft.server.BlockFenceGate;
import net.minecraft.server.BlockFire;
import net.minecraft.server.BlockFlower;
import net.minecraft.server.BlockFlowing;
import net.minecraft.server.BlockFurnace;
import net.minecraft.server.BlockGlass;
import net.minecraft.server.BlockGrass;
import net.minecraft.server.BlockGravel;
import net.minecraft.server.BlockHugeMushroom;
import net.minecraft.server.BlockIce;
import net.minecraft.server.BlockJukeBox;
import net.minecraft.server.BlockLadder;
import net.minecraft.server.BlockLeaves;
import net.minecraft.server.BlockLever;
import net.minecraft.server.BlockLightStone;
import net.minecraft.server.BlockLockedChest;
import net.minecraft.server.BlockLog;
import net.minecraft.server.BlockLongGrass;
import net.minecraft.server.BlockMelon;
import net.minecraft.server.BlockMinecartDetector;
import net.minecraft.server.BlockMinecartTrack;
import net.minecraft.server.BlockMobSpawner;
import net.minecraft.server.BlockMonsterEggs;
import net.minecraft.server.BlockMushroom;
import net.minecraft.server.BlockMycel;
import net.minecraft.server.BlockNetherWart;
import net.minecraft.server.BlockNote;
import net.minecraft.server.BlockObsidian;
import net.minecraft.server.BlockOre;
import net.minecraft.server.BlockOreBlock;
import net.minecraft.server.BlockPiston;
import net.minecraft.server.BlockPistonExtension;
import net.minecraft.server.BlockPistonMoving;
import net.minecraft.server.BlockPortal;
import net.minecraft.server.BlockPressurePlate;
import net.minecraft.server.BlockPumpkin;
import net.minecraft.server.BlockRedstoneLamp;
import net.minecraft.server.BlockRedstoneOre;
import net.minecraft.server.BlockRedstoneTorch;
import net.minecraft.server.BlockRedstoneWire;
import net.minecraft.server.BlockReed;
import net.minecraft.server.BlockSand;
import net.minecraft.server.BlockSandStone;
import net.minecraft.server.BlockSapling;
import net.minecraft.server.BlockSign;
import net.minecraft.server.BlockSlowSand;
import net.minecraft.server.BlockSmoothBrick;
import net.minecraft.server.BlockSnow;
import net.minecraft.server.BlockSnowBlock;
import net.minecraft.server.BlockSoil;
import net.minecraft.server.BlockSponge;
import net.minecraft.server.BlockStairs;
import net.minecraft.server.BlockStationary;
import net.minecraft.server.BlockStem;
import net.minecraft.server.BlockStep;
import net.minecraft.server.BlockStepAbstract;
import net.minecraft.server.BlockStone;
import net.minecraft.server.BlockTNT;
import net.minecraft.server.BlockThinFence;
import net.minecraft.server.BlockTorch;
import net.minecraft.server.BlockTrapdoor;
import net.minecraft.server.BlockTripwire;
import net.minecraft.server.BlockTripwireHook;
import net.minecraft.server.BlockVine;
import net.minecraft.server.BlockWaterLily;
import net.minecraft.server.BlockWeb;
import net.minecraft.server.BlockWood;
import net.minecraft.server.BlockWoodStep;
import net.minecraft.server.BlockWorkbench;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumMobType;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Item;
import net.minecraft.server.ItemBlock;
import net.minecraft.server.ItemCloth;
import net.minecraft.server.ItemLeaves;
import net.minecraft.server.ItemLog;
import net.minecraft.server.ItemMonsterEggs;
import net.minecraft.server.ItemPiston;
import net.minecraft.server.ItemSandStone;
import net.minecraft.server.ItemSapling;
import net.minecraft.server.ItemSmoothStone;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemStep;
import net.minecraft.server.ItemWaterLily;
import net.minecraft.server.ItemWithAuxData;
import net.minecraft.server.ItemWood;
import net.minecraft.server.LocaleI18n;
import net.minecraft.server.Material;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.StatisticList;
import net.minecraft.server.StepSound;
import net.minecraft.server.StepSoundSand;
import net.minecraft.server.StepSoundStone;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class Block {
    private CreativeModeTab creativeTab;
    public static final StepSound d = new StepSound("stone", 1.0f, 1.0f);
    public static final StepSound e = new StepSound("wood", 1.0f, 1.0f);
    public static final StepSound f = new StepSound("gravel", 1.0f, 1.0f);
    public static final StepSound g = new StepSound("grass", 1.0f, 1.0f);
    public static final StepSound h = new StepSound("stone", 1.0f, 1.0f);
    public static final StepSound i = new StepSound("stone", 1.0f, 1.5f);
    public static final StepSound j = new StepSoundStone("stone", 1.0f, 1.0f);
    public static final StepSound k = new StepSound("cloth", 1.0f, 1.0f);
    public static final StepSound l = new StepSoundSand("sand", 1.0f, 1.0f);
    public static final Block[] byId = new Block[4096];
    public static final boolean[] n = new boolean[4096];
    public static final int[] lightBlock = new int[4096];
    public static final boolean[] p = new boolean[4096];
    public static final int[] lightEmission = new int[4096];
    public static final boolean[] r = new boolean[4096];
    public static boolean[] s = new boolean[4096];
    public static final Block STONE = new BlockStone(1, 1).c(1.5f).b(10.0f).a(h).b("stone");
    public static final BlockGrass GRASS = (BlockGrass)new BlockGrass(2).c(0.6f).a(g).b("grass");
    public static final Block DIRT = new BlockDirt(3, 2).c(0.5f).a(f).b("dirt");
    public static final Block COBBLESTONE = new Block(4, 16, Material.STONE).c(2.0f).b(10.0f).a(h).b("stonebrick").a(CreativeModeTab.b);
    public static final Block WOOD = new BlockWood(5).c(2.0f).b(5.0f).a(e).b("wood").p();
    public static final Block SAPLING = new BlockSapling(6, 15).c(0.0f).a(g).b("sapling").p();
    public static final Block BEDROCK = new Block(7, 17, Material.STONE).q().b(6000000.0f).a(h).b("bedrock").v().a(CreativeModeTab.b);
    public static final Block WATER = new BlockFlowing(8, Material.WATER).c(100.0f).h(3).b("water").v().p();
    public static final Block STATIONARY_WATER = new BlockStationary(9, Material.WATER).c(100.0f).h(3).b("water").v().p();
    public static final Block LAVA = new BlockFlowing(10, Material.LAVA).c(0.0f).a(1.0f).h(255).b("lava").v().p();
    public static final Block STATIONARY_LAVA = new BlockStationary(11, Material.LAVA).c(100.0f).a(1.0f).h(255).b("lava").v().p();
    public static final Block SAND = new BlockSand(12, 18).c(0.5f).a(l).b("sand");
    public static final Block GRAVEL = new BlockGravel(13, 19).c(0.6f).a(f).b("gravel");
    public static final Block GOLD_ORE = new BlockOre(14, 32).c(3.0f).b(5.0f).a(h).b("oreGold");
    public static final Block IRON_ORE = new BlockOre(15, 33).c(3.0f).b(5.0f).a(h).b("oreIron");
    public static final Block COAL_ORE = new BlockOre(16, 34).c(3.0f).b(5.0f).a(h).b("oreCoal");
    public static final Block LOG = new BlockLog(17).c(2.0f).a(e).b("log").p();
    public static final BlockLeaves LEAVES = (BlockLeaves)new BlockLeaves(18, 52).c(0.2f).h(1).a(g).b("leaves").p();
    public static final Block SPONGE = new BlockSponge(19).c(0.6f).a(g).b("sponge");
    public static final Block GLASS = new BlockGlass(20, 49, Material.SHATTERABLE, false).c(0.3f).a(j).b("glass");
    public static final Block LAPIS_ORE = new BlockOre(21, 160).c(3.0f).b(5.0f).a(h).b("oreLapis");
    public static final Block LAPIS_BLOCK = new Block(22, 144, Material.STONE).c(3.0f).b(5.0f).a(h).b("blockLapis").a(CreativeModeTab.b);
    public static final Block DISPENSER = new BlockDispenser(23).c(3.5f).a(h).b("dispenser").p();
    public static final Block SANDSTONE = new BlockSandStone(24).a(h).c(0.8f).b("sandStone").p();
    public static final Block NOTE_BLOCK = new BlockNote(25).c(0.8f).b("musicBlock").p();
    public static final Block BED = new BlockBed(26).c(0.2f).b("bed").v().p();
    public static final Block GOLDEN_RAIL = new BlockMinecartTrack(27, 179, true).c(0.7f).a(i).b("goldenRail").p();
    public static final Block DETECTOR_RAIL = new BlockMinecartDetector(28, 195).c(0.7f).a(i).b("detectorRail").p();
    public static final Block PISTON_STICKY = new BlockPiston(29, 106, true).b("pistonStickyBase").p();
    public static final Block WEB = new BlockWeb(30, 11).h(1).c(4.0f).b("web");
    public static final BlockLongGrass LONG_GRASS = (BlockLongGrass)new BlockLongGrass(31, 39).c(0.0f).a(g).b("tallgrass");
    public static final BlockDeadBush DEAD_BUSH = (BlockDeadBush)new BlockDeadBush(32, 55).c(0.0f).a(g).b("deadbush");
    public static final Block PISTON = new BlockPiston(33, 107, false).b("pistonBase").p();
    public static final BlockPistonExtension PISTON_EXTENSION = (BlockPistonExtension)new BlockPistonExtension(34, 107).p();
    public static final Block WOOL = new BlockCloth().c(0.8f).a(k).b("cloth").p();
    public static final BlockPistonMoving PISTON_MOVING = new BlockPistonMoving(36);
    public static final BlockFlower YELLOW_FLOWER = (BlockFlower)new BlockFlower(37, 13).c(0.0f).a(g).b("flower");
    public static final BlockFlower RED_ROSE = (BlockFlower)new BlockFlower(38, 12).c(0.0f).a(g).b("rose");
    public static final BlockFlower BROWN_MUSHROOM = (BlockFlower)new BlockMushroom(39, 29).c(0.0f).a(g).a(0.125f).b("mushroom");
    public static final BlockFlower RED_MUSHROOM = (BlockFlower)new BlockMushroom(40, 28).c(0.0f).a(g).b("mushroom");
    public static final Block GOLD_BLOCK = new BlockOreBlock(41, 23).c(3.0f).b(10.0f).a(i).b("blockGold");
    public static final Block IRON_BLOCK = new BlockOreBlock(42, 22).c(5.0f).b(10.0f).a(i).b("blockIron");
    public static final BlockStepAbstract DOUBLE_STEP = (BlockStepAbstract)new BlockStep(43, true).c(2.0f).b(10.0f).a(h).b("stoneSlab");
    public static final BlockStepAbstract STEP = (BlockStepAbstract)new BlockStep(44, false).c(2.0f).b(10.0f).a(h).b("stoneSlab");
    public static final Block BRICK = new Block(45, 7, Material.STONE).c(2.0f).b(10.0f).a(h).b("brick").a(CreativeModeTab.b);
    public static final Block TNT = new BlockTNT(46, 8).c(0.0f).a(g).b("tnt");
    public static final Block BOOKSHELF = new BlockBookshelf(47, 35).c(1.5f).a(e).b("bookshelf");
    public static final Block MOSSY_COBBLESTONE = new Block(48, 36, Material.STONE).c(2.0f).b(10.0f).a(h).b("stoneMoss").a(CreativeModeTab.b);
    public static final Block OBSIDIAN = new BlockObsidian(49, 37).c(50.0f).b(2000.0f).a(h).b("obsidian");
    public static final Block TORCH = new BlockTorch(50, 80).c(0.0f).a(0.9375f).a(e).b("torch").p();
    public static final BlockFire FIRE = (BlockFire)new BlockFire(51, 31).c(0.0f).a(1.0f).a(e).b("fire").v();
    public static final Block MOB_SPAWNER = new BlockMobSpawner(52, 65).c(5.0f).a(i).b("mobSpawner").v();
    public static final Block WOOD_STAIRS = new BlockStairs(53, WOOD, 0).b("stairsWood").p();
    public static final Block CHEST = new BlockChest(54).c(2.5f).a(e).b("chest").p();
    public static final Block REDSTONE_WIRE = new BlockRedstoneWire(55, 164).c(0.0f).a(d).b("redstoneDust").v().p();
    public static final Block DIAMOND_ORE = new BlockOre(56, 50).c(3.0f).b(5.0f).a(h).b("oreDiamond");
    public static final Block DIAMOND_BLOCK = new BlockOreBlock(57, 24).c(5.0f).b(10.0f).a(i).b("blockDiamond");
    public static final Block WORKBENCH = new BlockWorkbench(58).c(2.5f).a(e).b("workbench");
    public static final Block CROPS = new BlockCrops(59, 88).c(0.0f).a(g).b("crops").v().p();
    public static final Block SOIL = new BlockSoil(60).c(0.6f).a(f).b("farmland").p();
    public static final Block FURNACE = new BlockFurnace(61, false).c(3.5f).a(h).b("furnace").p().a(CreativeModeTab.c);
    public static final Block BURNING_FURNACE = new BlockFurnace(62, true).c(3.5f).a(h).a(0.875f).b("furnace").p();
    public static final Block SIGN_POST = new BlockSign(63, TileEntitySign.class, true).c(1.0f).a(e).b("sign").v().p();
    public static final Block WOODEN_DOOR = new BlockDoor(64, Material.WOOD).c(3.0f).a(e).b("doorWood").v().p();
    public static final Block LADDER = new BlockLadder(65, 83).c(0.4f).a(e).b("ladder").p();
    public static final Block RAILS = new BlockMinecartTrack(66, 128, false).c(0.7f).a(i).b("rail").p();
    public static final Block COBBLESTONE_STAIRS = new BlockStairs(67, COBBLESTONE, 0).b("stairsStone").p();
    public static final Block WALL_SIGN = new BlockSign(68, TileEntitySign.class, false).c(1.0f).a(e).b("sign").v().p();
    public static final Block LEVER = new BlockLever(69, 96).c(0.5f).a(e).b("lever").p();
    public static final Block STONE_PLATE = new BlockPressurePlate(70, Block.STONE.textureId, EnumMobType.MOBS, Material.STONE).c(0.5f).a(h).b("pressurePlate").p();
    public static final Block IRON_DOOR_BLOCK = new BlockDoor(71, Material.ORE).c(5.0f).a(i).b("doorIron").v().p();
    public static final Block WOOD_PLATE = new BlockPressurePlate(72, Block.WOOD.textureId, EnumMobType.EVERYTHING, Material.WOOD).c(0.5f).a(e).b("pressurePlate").p();
    public static final Block REDSTONE_ORE = new BlockRedstoneOre(73, 51, false).c(3.0f).b(5.0f).a(h).b("oreRedstone").p().a(CreativeModeTab.b);
    public static final Block GLOWING_REDSTONE_ORE = new BlockRedstoneOre(74, 51, true).a(0.625f).c(3.0f).b(5.0f).a(h).b("oreRedstone").p();
    public static final Block REDSTONE_TORCH_OFF = new BlockRedstoneTorch(75, 115, false).c(0.0f).a(e).b("notGate").p();
    public static final Block REDSTONE_TORCH_ON = new BlockRedstoneTorch(76, 99, true).c(0.0f).a(0.5f).a(e).b("notGate").p().a(CreativeModeTab.d);
    public static final Block STONE_BUTTON = new BlockButton(77, Block.STONE.textureId).c(0.5f).a(h).b("button").p();
    public static final Block SNOW = new BlockSnow(78, 66).c(0.1f).a(k).b("snow").p().h(0);
    public static final Block ICE = new BlockIce(79, 67).c(0.5f).h(3).a(j).b("ice");
    public static final Block SNOW_BLOCK = new BlockSnowBlock(80, 66).c(0.2f).a(k).b("snow");
    public static final Block CACTUS = new BlockCactus(81, 70).c(0.4f).a(k).b("cactus");
    public static final Block CLAY = new BlockClay(82, 72).c(0.6f).a(f).b("clay");
    public static final Block SUGAR_CANE_BLOCK = new BlockReed(83, 73).c(0.0f).a(g).b("reeds").v();
    public static final Block JUKEBOX = new BlockJukeBox(84, 74).c(2.0f).b(10.0f).a(h).b("jukebox").p();
    public static final Block FENCE = new BlockFence(85, 4).c(2.0f).b(5.0f).a(e).b("fence");
    public static final Block PUMPKIN = new BlockPumpkin(86, 102, false).c(1.0f).a(e).b("pumpkin").p();
    public static final Block NETHERRACK = new BlockBloodStone(87, 103).c(0.4f).a(h).b("hellrock");
    public static final Block SOUL_SAND = new BlockSlowSand(88, 104).c(0.5f).a(l).b("hellsand");
    public static final Block GLOWSTONE = new BlockLightStone(89, 105, Material.SHATTERABLE).c(0.3f).a(j).a(1.0f).b("lightgem");
    public static final BlockPortal PORTAL = (BlockPortal)new BlockPortal(90, 14).c(-1.0f).a(j).a(0.75f).b("portal");
    public static final Block JACK_O_LANTERN = new BlockPumpkin(91, 102, true).c(1.0f).a(e).a(1.0f).b("litpumpkin").p();
    public static final Block CAKE_BLOCK = new BlockCake(92, 121).c(0.5f).a(k).b("cake").v().p();
    public static final Block DIODE_OFF = new BlockDiode(93, false).c(0.0f).a(e).b("diode").v().p();
    public static final Block DIODE_ON = new BlockDiode(94, true).c(0.0f).a(0.625f).a(e).b("diode").v().p();
    public static final Block LOCKED_CHEST = new BlockLockedChest(95).c(0.0f).a(1.0f).a(e).b("lockedchest").b(true).p();
    public static final Block TRAP_DOOR = new BlockTrapdoor(96, Material.WOOD).c(3.0f).a(e).b("trapdoor").v().p();
    public static final Block MONSTER_EGGS = new BlockMonsterEggs(97).c(0.75f).b("monsterStoneEgg");
    public static final Block SMOOTH_BRICK = new BlockSmoothBrick(98).c(1.5f).b(10.0f).a(h).b("stonebricksmooth");
    public static final Block BIG_MUSHROOM_1 = new BlockHugeMushroom(99, Material.WOOD, 142, 0).c(0.2f).a(e).b("mushroom").p();
    public static final Block BIG_MUSHROOM_2 = new BlockHugeMushroom(100, Material.WOOD, 142, 1).c(0.2f).a(e).b("mushroom").p();
    public static final Block IRON_FENCE = new BlockThinFence(101, 85, 85, Material.ORE, true).c(5.0f).b(10.0f).a(i).b("fenceIron");
    public static final Block THIN_GLASS = new BlockThinFence(102, 49, 148, Material.SHATTERABLE, false).c(0.3f).a(j).b("thinGlass");
    public static final Block MELON = new BlockMelon(103).c(1.0f).a(e).b("melon");
    public static final Block PUMPKIN_STEM = new BlockStem(104, PUMPKIN).c(0.0f).a(e).b("pumpkinStem").p();
    public static final Block MELON_STEM = new BlockStem(105, MELON).c(0.0f).a(e).b("pumpkinStem").p();
    public static final Block VINE = new BlockVine(106).c(0.2f).a(g).b("vine").p();
    public static final Block FENCE_GATE = new BlockFenceGate(107, 4).c(2.0f).b(5.0f).a(e).b("fenceGate").p();
    public static final Block BRICK_STAIRS = new BlockStairs(108, BRICK, 0).b("stairsBrick").p();
    public static final Block STONE_STAIRS = new BlockStairs(109, SMOOTH_BRICK, 0).b("stairsStoneBrickSmooth").p();
    public static final BlockMycel MYCEL = (BlockMycel)new BlockMycel(110).c(0.6f).a(g).b("mycel");
    public static final Block WATER_LILY = new BlockWaterLily(111, 76).c(0.0f).a(g).b("waterlily");
    public static final Block NETHER_BRICK = new Block(112, 224, Material.STONE).c(2.0f).b(10.0f).a(h).b("netherBrick").a(CreativeModeTab.b);
    public static final Block NETHER_FENCE = new BlockFence(113, 224, Material.STONE).c(2.0f).b(10.0f).a(h).b("netherFence");
    public static final Block NETHER_BRICK_STAIRS = new BlockStairs(114, NETHER_BRICK, 0).b("stairsNetherBrick").p();
    public static final Block NETHER_WART = new BlockNetherWart(115).b("netherStalk").p();
    public static final Block ENCHANTMENT_TABLE = new BlockEnchantmentTable(116).c(5.0f).b(2000.0f).b("enchantmentTable");
    public static final Block BREWING_STAND = new BlockBrewingStand(117).c(0.5f).a(0.125f).b("brewingStand").p();
    public static final Block CAULDRON = new BlockCauldron(118).c(2.0f).b("cauldron").p();
    public static final Block ENDER_PORTAL = new BlockEnderPortal(119, Material.PORTAL).c(-1.0f).b(6000000.0f);
    public static final Block ENDER_PORTAL_FRAME = new BlockEnderPortalFrame(120).a(j).a(0.125f).c(-1.0f).b("endPortalFrame").p().b(6000000.0f).a(CreativeModeTab.c);
    public static final Block WHITESTONE = new Block(121, 175, Material.STONE).c(3.0f).b(15.0f).a(h).b("whiteStone").a(CreativeModeTab.b);
    public static final Block DRAGON_EGG = new BlockDragonEgg(122, 167).c(3.0f).b(15.0f).a(h).a(0.125f).b("dragonEgg");
    public static final Block REDSTONE_LAMP_OFF = new BlockRedstoneLamp(123, false).c(0.3f).a(j).b("redstoneLight").a(CreativeModeTab.d);
    public static final Block REDSTONE_LAMP_ON = new BlockRedstoneLamp(124, true).c(0.3f).a(j).b("redstoneLight");
    public static final BlockStepAbstract WOOD_DOUBLE_STEP = (BlockStepAbstract)new BlockWoodStep(125, true).c(2.0f).b(5.0f).a(e).b("woodSlab");
    public static final BlockStepAbstract WOOD_STEP = (BlockStepAbstract)new BlockWoodStep(126, false).c(2.0f).b(5.0f).a(e).b("woodSlab");
    public static final Block COCOA = new BlockCocoa(127).c(0.2f).b(5.0f).a(e).b("cocoa").p();
    public static final Block SANDSTONE_STAIRS = new BlockStairs(128, SANDSTONE, 0).b("stairsSandStone").p();
    public static final Block EMERALD_ORE = new BlockOre(129, 171).c(3.0f).b(5.0f).a(h).b("oreEmerald");
    public static final Block ENDER_CHEST = new BlockEnderChest(130).c(22.5f).b(1000.0f).a(h).b("enderChest").p().a(0.5f);
    public static final BlockTripwireHook TRIPWIRE_SOURCE = (BlockTripwireHook)new BlockTripwireHook(131).b("tripWireSource").p();
    public static final Block TRIPWIRE = new BlockTripwire(132).b("tripWire").p();
    public static final Block EMERALD_BLOCK = new BlockOreBlock(133, 25).c(5.0f).b(10.0f).a(i).b("blockEmerald");
    public static final Block SPRUCE_WOOD_STAIRS = new BlockStairs(134, WOOD, 1).b("stairsWoodSpruce").p();
    public static final Block BIRCH_WOOD_STAIRS = new BlockStairs(135, WOOD, 2).b("stairsWoodBirch").p();
    public static final Block JUNGLE_WOOD_STAIRS = new BlockStairs(136, WOOD, 3).b("stairsWoodJungle").p();
    public int textureId;
    public final int id;
    protected float strength;
    protected float durability;
    protected boolean cd = true;
    protected boolean ce = true;
    protected boolean cf;
    protected boolean isTileEntity;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public StepSound stepSound = d;
    public float co = 1.0f;
    public final Material material;
    public float frictionFactor = 0.6f;
    private String name;

    protected Block(int n, Material material) {
        if (byId[n] != null) {
            throw new IllegalArgumentException("Slot " + n + " is already occupied by " + byId[n] + " when adding " + this);
        }
        this.material = material;
        Block.byId[n] = this;
        this.id = n;
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.n[n] = this.d();
        Block.lightBlock[n] = this.d() ? 255 : 0;
        Block.p[n] = !material.blocksLight();
    }

    protected Block p() {
        Block.r[this.id] = true;
        return this;
    }

    protected void r_() {
    }

    protected Block(int n, int n2, Material material) {
        this(n, material);
        this.textureId = n2;
    }

    protected Block a(StepSound stepSound) {
        this.stepSound = stepSound;
        return this;
    }

    protected Block h(int n) {
        Block.lightBlock[this.id] = n;
        return this;
    }

    protected Block a(float f) {
        Block.lightEmission[this.id] = (int)(15.0f * f);
        return this;
    }

    protected Block b(float f) {
        this.durability = f * 3.0f;
        return this;
    }

    public static boolean i(int n) {
        Block block = byId[n];
        if (block == null) {
            return false;
        }
        return block.material.k() && block.c();
    }

    public boolean c() {
        return true;
    }

    public boolean c(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return !this.material.isSolid();
    }

    public int b() {
        return 0;
    }

    protected Block c(float f) {
        this.strength = f;
        if (this.durability < f * 5.0f) {
            this.durability = f * 5.0f;
        }
        return this;
    }

    protected Block q() {
        this.c(-1.0f);
        return this;
    }

    public float m(World world, int n, int n2, int n3) {
        return this.strength;
    }

    protected Block b(boolean bl) {
        this.cf = bl;
        return this;
    }

    public boolean r() {
        return this.cf;
    }

    public boolean s() {
        return this.isTileEntity;
    }

    public void a(float f, float f2, float f3, float f4, float f5, float f6) {
        this.minX = f;
        this.minY = f2;
        this.minZ = f3;
        this.maxX = f4;
        this.maxY = f5;
        this.maxZ = f6;
    }

    public boolean d(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return iBlockAccess.getMaterial(n, n2, n3).isBuildable();
    }

    public int a(int n, int n2) {
        return this.a(n);
    }

    public int a(int n) {
        return this.textureId;
    }

    public void a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        AxisAlignedBB axisAlignedBB2 = this.e(world, n, n2, n3);
        if (axisAlignedBB2 != null && axisAlignedBB.a(axisAlignedBB2)) {
            list.add(axisAlignedBB2);
        }
    }

    public AxisAlignedBB e(World world, int n, int n2, int n3) {
        return AxisAlignedBB.a().a((double)n + this.minX, (double)n2 + this.minY, (double)n3 + this.minZ, (double)n + this.maxX, (double)n2 + this.maxY, (double)n3 + this.maxZ);
    }

    public boolean d() {
        return true;
    }

    public boolean a(int n, boolean bl) {
        return this.l();
    }

    public boolean l() {
        return true;
    }

    public void b(World world, int n, int n2, int n3, Random random) {
    }

    public void postBreak(World world, int n, int n2, int n3, int n4) {
    }

    public void doPhysics(World world, int n, int n2, int n3, int n4) {
    }

    public int p_() {
        return 10;
    }

    public void onPlace(World world, int n, int n2, int n3) {
    }

    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
    }

    public int a(Random random) {
        return 1;
    }

    public int getDropType(int n, Random random, int n2) {
        return this.id;
    }

    public float getDamage(EntityHuman entityHuman, World world, int n, int n2, int n3) {
        float f = this.m(world, n, n2, n3);
        if (f < 0.0f) {
            return 0.0f;
        }
        if (!entityHuman.b(this)) {
            return 1.0f / f / 100.0f;
        }
        return entityHuman.a(this) / f / 30.0f;
    }

    public final void c(World world, int n, int n2, int n3, int n4, int n5) {
        this.dropNaturally(world, n, n2, n3, n4, 1.0f, n5);
    }

    public void dropNaturally(World world, int n, int n2, int n3, int n4, float f, int n5) {
        if (world.isStatic) {
            return;
        }
        int n6 = this.getDropCount(n5, world.random);
        for (int i = 0; i < n6; ++i) {
            int n7;
            if (world.random.nextFloat() > f || (n7 = this.getDropType(n4, world.random, n5)) <= 0) continue;
            this.a(world, n, n2, n3, new ItemStack(n7, 1, this.getDropData(n4)));
        }
    }

    protected void a(World world, int n, int n2, int n3, ItemStack itemStack) {
        if (world.isStatic) {
            return;
        }
        float f = 0.7f;
        double d = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d3 = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)n + d, (double)n2 + d2, (double)n3 + d3, itemStack);
        entityItem.pickupDelay = 10;
        world.addEntity(entityItem);
    }

    protected void g(World world, int n, int n2, int n3, int n4) {
        if (!world.isStatic) {
            while (n4 > 0) {
                int n5 = EntityExperienceOrb.getOrbValue(n4);
                n4 -= n5;
                world.addEntity(new EntityExperienceOrb(world, (double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, n5));
            }
        }
    }

    protected int getDropData(int n) {
        return 0;
    }

    public float a(Entity entity) {
        return this.durability / 5.0f;
    }

    public MovingObjectPosition a(World world, int n, int n2, int n3, Vec3D vec3D, Vec3D vec3D2) {
        this.updateShape(world, n, n2, n3);
        vec3D = vec3D.add(-n, -n2, -n3);
        vec3D2 = vec3D2.add(-n, -n2, -n3);
        Vec3D vec3D3 = vec3D.b(vec3D2, this.minX);
        Vec3D vec3D4 = vec3D.b(vec3D2, this.maxX);
        Vec3D vec3D5 = vec3D.c(vec3D2, this.minY);
        Vec3D vec3D6 = vec3D.c(vec3D2, this.maxY);
        Vec3D vec3D7 = vec3D.d(vec3D2, this.minZ);
        Vec3D vec3D8 = vec3D.d(vec3D2, this.maxZ);
        if (!this.a(vec3D3)) {
            vec3D3 = null;
        }
        if (!this.a(vec3D4)) {
            vec3D4 = null;
        }
        if (!this.b(vec3D5)) {
            vec3D5 = null;
        }
        if (!this.b(vec3D6)) {
            vec3D6 = null;
        }
        if (!this.c(vec3D7)) {
            vec3D7 = null;
        }
        if (!this.c(vec3D8)) {
            vec3D8 = null;
        }
        Vec3D vec3D9 = null;
        if (vec3D3 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D3) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D3;
        }
        if (vec3D4 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D4) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D4;
        }
        if (vec3D5 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D5) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D5;
        }
        if (vec3D6 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D6) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D6;
        }
        if (vec3D7 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D7) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D7;
        }
        if (vec3D8 != null && (vec3D9 == null || vec3D.distanceSquared(vec3D8) < vec3D.distanceSquared(vec3D9))) {
            vec3D9 = vec3D8;
        }
        if (vec3D9 == null) {
            return null;
        }
        int n4 = -1;
        if (vec3D9 == vec3D3) {
            n4 = 4;
        }
        if (vec3D9 == vec3D4) {
            n4 = 5;
        }
        if (vec3D9 == vec3D5) {
            n4 = 0;
        }
        if (vec3D9 == vec3D6) {
            n4 = 1;
        }
        if (vec3D9 == vec3D7) {
            n4 = 2;
        }
        if (vec3D9 == vec3D8) {
            n4 = 3;
        }
        return new MovingObjectPosition(n, n2, n3, n4, vec3D9.add(n, n2, n3));
    }

    private boolean a(Vec3D vec3D) {
        if (vec3D == null) {
            return false;
        }
        return vec3D.b >= this.minY && vec3D.b <= this.maxY && vec3D.c >= this.minZ && vec3D.c <= this.maxZ;
    }

    private boolean b(Vec3D vec3D) {
        if (vec3D == null) {
            return false;
        }
        return vec3D.a >= this.minX && vec3D.a <= this.maxX && vec3D.c >= this.minZ && vec3D.c <= this.maxZ;
    }

    private boolean c(Vec3D vec3D) {
        if (vec3D == null) {
            return false;
        }
        return vec3D.a >= this.minX && vec3D.a <= this.maxX && vec3D.b >= this.minY && vec3D.b <= this.maxY;
    }

    public void wasExploded(World world, int n, int n2, int n3) {
    }

    public boolean canPlace(World world, int n, int n2, int n3, int n4) {
        return this.canPlace(world, n, n2, n3);
    }

    public boolean canPlace(World world, int n, int n2, int n3) {
        int n4 = world.getTypeId(n, n2, n3);
        return n4 == 0 || Block.byId[n4].material.isReplaceable();
    }

    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        return false;
    }

    public void b(World world, int n, int n2, int n3, Entity entity) {
    }

    public void postPlace(World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
    }

    public void attack(World world, int n, int n2, int n3, EntityHuman entityHuman) {
    }

    public void a(World world, int n, int n2, int n3, Entity entity, Vec3D vec3D) {
    }

    public void updateShape(IBlockAccess iBlockAccess, int n, int n2, int n3) {
    }

    public boolean a(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return false;
    }

    public boolean isPowerSource() {
        return false;
    }

    public void a(World world, int n, int n2, int n3, Entity entity) {
    }

    public boolean c(World world, int n, int n2, int n3, int n4) {
        return false;
    }

    public void f() {
    }

    public void a(World world, EntityHuman entityHuman, int n, int n2, int n3, int n4) {
        entityHuman.a(StatisticList.C[this.id], 1);
        entityHuman.j(0.025f);
        if (this.q_() && EnchantmentManager.hasSilkTouchEnchantment(entityHuman.inventory)) {
            ItemStack itemStack = this.c_(n4);
            if (itemStack != null) {
                this.a(world, n, n2, n3, itemStack);
            }
        } else {
            int n5 = EnchantmentManager.getBonusBlockLootEnchantmentLevel(entityHuman.inventory);
            this.c(world, n, n2, n3, n4, n5);
        }
    }

    protected boolean q_() {
        return this.c() && !this.isTileEntity;
    }

    protected ItemStack c_(int n) {
        int n2 = 0;
        if (this.id >= 0 && this.id < Item.byId.length && Item.byId[this.id].k()) {
            n2 = n;
        }
        return new ItemStack(this.id, 1, n2);
    }

    public int getDropCount(int n, Random random) {
        return this.a(random);
    }

    public boolean d(World world, int n, int n2, int n3) {
        return true;
    }

    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving) {
    }

    public Block b(String string) {
        this.name = "tile." + string;
        return this;
    }

    public String getName() {
        return LocaleI18n.get(this.a() + ".name");
    }

    public String a() {
        return this.name;
    }

    public void b(World world, int n, int n2, int n3, int n4, int n5) {
    }

    public boolean u() {
        return this.ce;
    }

    protected Block v() {
        this.ce = false;
        return this;
    }

    public int e() {
        return this.material.getPushReaction();
    }

    public void a(World world, int n, int n2, int n3, Entity entity, float f) {
    }

    public Block a(CreativeModeTab creativeModeTab) {
        this.creativeTab = creativeModeTab;
        return this;
    }

    public void a(World world, int n, int n2, int n3, int n4, EntityHuman entityHuman) {
    }

    public void h(World world, int n, int n2, int n3, int n4) {
    }

    public void f(World world, int n, int n2, int n3) {
    }

    public void a(World world, long l, long l2) {
    }

    static {
        Item.byId[Block.WOOL.id] = new ItemCloth(Block.WOOL.id - 256).b("cloth");
        Item.byId[Block.LOG.id] = new ItemLog(Block.LOG.id - 256, LOG).b("log");
        Item.byId[Block.WOOD.id] = new ItemWood(Block.WOOD.id - 256, WOOD).b("wood");
        Item.byId[Block.MONSTER_EGGS.id] = new ItemMonsterEggs(Block.MONSTER_EGGS.id - 256).b("monsterStoneEgg");
        Item.byId[Block.SMOOTH_BRICK.id] = new ItemSmoothStone(Block.SMOOTH_BRICK.id - 256, SMOOTH_BRICK).b("stonebricksmooth");
        Item.byId[Block.SANDSTONE.id] = new ItemSandStone(Block.SANDSTONE.id - 256, SANDSTONE).b("sandStone");
        Item.byId[Block.STEP.id] = new ItemStep(Block.STEP.id - 256, STEP, DOUBLE_STEP, false).b("stoneSlab");
        Item.byId[Block.DOUBLE_STEP.id] = new ItemStep(Block.DOUBLE_STEP.id - 256, STEP, DOUBLE_STEP, true).b("stoneSlab");
        Item.byId[Block.WOOD_STEP.id] = new ItemStep(Block.WOOD_STEP.id - 256, WOOD_STEP, WOOD_DOUBLE_STEP, false).b("woodSlab");
        Item.byId[Block.WOOD_DOUBLE_STEP.id] = new ItemStep(Block.WOOD_DOUBLE_STEP.id - 256, WOOD_STEP, WOOD_DOUBLE_STEP, true).b("woodSlab");
        Item.byId[Block.SAPLING.id] = new ItemSapling(Block.SAPLING.id - 256).b("sapling");
        Item.byId[Block.LEAVES.id] = new ItemLeaves(Block.LEAVES.id - 256).b("leaves");
        Item.byId[Block.VINE.id] = new ItemWithAuxData(Block.VINE.id - 256, false);
        Item.byId[Block.LONG_GRASS.id] = new ItemWithAuxData(Block.LONG_GRASS.id - 256, true).a(new String[]{"shrub", "grass", "fern"});
        Item.byId[Block.WATER_LILY.id] = new ItemWaterLily(Block.WATER_LILY.id - 256);
        Item.byId[Block.PISTON.id] = new ItemPiston(Block.PISTON.id - 256);
        Item.byId[Block.PISTON_STICKY.id] = new ItemPiston(Block.PISTON_STICKY.id - 256);
        for (int i = 0; i < 256; ++i) {
            if (byId[i] == null) continue;
            if (Item.byId[i] == null) {
                Item.byId[i] = new ItemBlock(i - 256);
                byId[i].r_();
            }
            boolean bl = false;
            if (i > 0 && byId[i].b() == 10) {
                bl = true;
            }
            if (i > 0 && byId[i] instanceof BlockStepAbstract) {
                bl = true;
            }
            if (i == Block.SOIL.id) {
                bl = true;
            }
            if (p[i]) {
                bl = true;
            }
            if (lightBlock[i] == 0) {
                bl = true;
            }
            Block.s[i] = bl;
        }
        Block.p[0] = true;
        StatisticList.b();
    }
}

