/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityOcelot;
import net.minecraft.server.EntitySkeleton;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalAvoidPlayer;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalMeleeAttack;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalSwell;
import net.minecraft.server.World;

public class EntityCreeper
extends EntityMonster {
    int fuseTicks;
    int e;

    public EntityCreeper(World world) {
        super(world);
        this.texture = "/mob/creeper.png";
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, new PathfinderGoalSwell(this));
        this.goalSelector.a(3, new PathfinderGoalAvoidPlayer(this, EntityOcelot.class, 6.0f, 0.25f, 0.3f));
        this.goalSelector.a(4, new PathfinderGoalMeleeAttack(this, 0.25f, false));
        this.goalSelector.a(5, new PathfinderGoalRandomStroll(this, 0.2f));
        this.goalSelector.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(6, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalNearestAttackableTarget(this, EntityHuman.class, 16.0f, 0, true));
        this.targetSelector.a(2, new PathfinderGoalHurtByTarget(this, false));
    }

    public boolean aV() {
        return true;
    }

    public int getMaxHealth() {
        return 20;
    }

    protected void a() {
        super.a();
        this.datawatcher.a(16, (byte)-1);
        this.datawatcher.a(17, (byte)0);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.datawatcher.getByte(17) == 1) {
            nBTTagCompound.setBoolean("powered", true);
        }
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.datawatcher.watch(17, (byte)(nBTTagCompound.getBoolean("powered") ? 1 : 0));
    }

    public void h_() {
        if (this.isAlive()) {
            this.e = this.fuseTicks;
            int n = this.p();
            if (n > 0 && this.fuseTicks == 0) {
                this.world.makeSound(this, "random.fuse", 1.0f, 0.5f);
            }
            this.fuseTicks += n;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
            if (this.fuseTicks >= 30) {
                this.fuseTicks = 30;
                if (!this.world.isStatic) {
                    if (this.isPowered()) {
                        this.world.explode(this, this.locX, this.locY, this.locZ, 6.0f);
                    } else {
                        this.world.explode(this, this.locX, this.locY, this.locZ, 3.0f);
                    }
                    this.die();
                }
            }
        }
        super.h_();
    }

    protected String aR() {
        return "mob.creeper";
    }

    protected String aS() {
        return "mob.creeperdeath";
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (damageSource.getEntity() instanceof EntitySkeleton) {
            this.b(Item.RECORD_1.id + this.random.nextInt(10), 1);
        }
    }

    public boolean k(Entity entity) {
        return true;
    }

    public boolean isPowered() {
        return this.datawatcher.getByte(17) == 1;
    }

    protected int getLootId() {
        return Item.SULPHUR.id;
    }

    public int p() {
        return this.datawatcher.getByte(16);
    }

    public void a(int n) {
        this.datawatcher.watch(16, (byte)n);
    }

    public void a(EntityLightning entityLightning) {
        super.a(entityLightning);
        this.datawatcher.watch(17, (byte)1);
    }
}

