/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ProxyServer;

public class Metrics
extends Thread {
    private static final int REVISION = 5;
    private static final String BASE_URL = "http://mcstats.org";
    private static final String REPORT_URL = "/report/%s";
    private static final int PING_INTERVAL = 10;

    public Metrics() {
        super("Metrics Gathering Thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        boolean firstPost = true;
        while (true) {
            try {
                this.postPlugin(!firstPost);
                firstPost = false;
            }
            catch (IOException ex) {
                ProxyServer.getInstance().getLogger().info("[Metrics] " + ex.getMessage());
            }
            try {
                Metrics.sleep(600000L);
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    private void postPlugin(boolean isPing) throws IOException {
        String response;
        BufferedReader reader;
        StringBuilder data = new StringBuilder();
        data.append(Metrics.encode("guid")).append('=').append(Metrics.encode(BungeeCord.getInstance().config.getUuid()));
        Metrics.encodeDataPair(data, "version", ProxyServer.getInstance().getVersion());
        Metrics.encodeDataPair(data, "server", "0");
        Metrics.encodeDataPair(data, "players", Integer.toString(ProxyServer.getInstance().getPlayers().size()));
        Metrics.encodeDataPair(data, "revision", String.valueOf(5));
        if (isPing) {
            Metrics.encodeDataPair(data, "ping", "true");
        }
        URL url = new URL(BASE_URL + String.format(REPORT_URL, Metrics.encode("BungeeCord")));
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());){
            writer.write(data.toString());
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            response = reader.readLine();
        }
        reader.close();
        if (response == null || response.startsWith("ERR")) {
            throw new IOException(response);
        }
    }

    private static void encodeDataPair(StringBuilder buffer, String key, String value) throws UnsupportedEncodingException {
        buffer.append('&').append(Metrics.encode(key)).append('=').append(Metrics.encode(value));
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }
}

