/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.BungeeLogger;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.Metrics;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.YamlReconnectHandler;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.TabListHandler;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.api.scheduler.TaskScheduler;
import net.md_5.bungee.command.CommandAlert;
import net.md_5.bungee.command.CommandBungee;
import net.md_5.bungee.command.CommandEnd;
import net.md_5.bungee.command.CommandIP;
import net.md_5.bungee.command.CommandList;
import net.md_5.bungee.command.CommandPerms;
import net.md_5.bungee.command.CommandReload;
import net.md_5.bungee.command.CommandSend;
import net.md_5.bungee.command.CommandServer;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.YamlConfig;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.scheduler.BungeeScheduler;
import net.md_5.bungee.scheduler.BungeeThreadPool;

public class BungeeCord
extends ProxyServer {
    public static final byte PROTOCOL_VERSION = 61;
    public static final String GAME_VERSION = "1.5.2";
    public volatile boolean isRunning;
    public final Configuration config = new Configuration();
    public final ScheduledThreadPoolExecutor executors = new BungeeThreadPool(new ThreadFactoryBuilder().setNameFormat("Bungee Pool Thread #%1$d").build());
    public final MultithreadEventLoopGroup eventLoops = new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty IO Thread #%1$d").build());
    private final Timer saveThread = new Timer("Reconnect Saver");
    private Collection<Channel> listeners = new HashSet<Channel>();
    public Map<String, UserConnection> connections = new ConcurrentHashMap<String, UserConnection>();
    public TabListHandler tabListHandler;
    public final PluginManager pluginManager = new PluginManager(this);
    private ReconnectHandler reconnectHandler;
    private ConfigurationAdapter configurationAdapter = new YamlConfig();
    private final Collection<String> pluginChannels = new HashSet<String>();
    private final File pluginsFolder = new File("plugins");
    private final TaskScheduler scheduler = new BungeeScheduler();
    private final AsyncHttpClient httpClient = new AsyncHttpClient(new NettyAsyncHttpProvider(new AsyncHttpClientConfig.Builder().setAsyncHttpClientProviderConfig(new NettyAsyncHttpProviderConfig().addProperty("bossExecutorService", (Object)this.executors)).setExecutorService(this.executors).build()));

    public BungeeCord() {
        this.getPluginManager().registerCommand(null, new CommandReload());
        this.getPluginManager().registerCommand(null, new CommandEnd());
        this.getPluginManager().registerCommand(null, new CommandList());
        this.getPluginManager().registerCommand(null, new CommandServer());
        this.getPluginManager().registerCommand(null, new CommandIP());
        this.getPluginManager().registerCommand(null, new CommandAlert());
        this.getPluginManager().registerCommand(null, new CommandBungee());
        this.getPluginManager().registerCommand(null, new CommandPerms());
        this.getPluginManager().registerCommand(null, new CommandSend());
        this.registerChannel("BungeeCord");
    }

    public static BungeeCord getInstance() {
        return (BungeeCord)ProxyServer.getInstance();
    }

    public static void main(String[] args) throws Exception {
        Calendar deadline = Calendar.getInstance();
        deadline.set(2013, 5, 26);
        if (Calendar.getInstance().after(deadline)) {
            System.err.println("*** Warning, this build is outdated ***");
            System.err.println("*** Please download a new build from http://ci.md-5.net/job/BungeeCord ***");
            System.err.println("*** You will get NO support regarding this build ***");
            System.err.println("*** Server will start in 15 seconds ***");
            Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
        }
        BungeeCord bungee = new BungeeCord();
        ProxyServer.setInstance(bungee);
        bungee.getLogger().info("Enabled BungeeCord version " + bungee.getVersion());
        bungee.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (bungee.isRunning) {
            boolean handled;
            String line = br.readLine();
            if (line == null || (handled = BungeeCord.getInstance().getPluginManager().dispatchCommand(ConsoleCommandSender.getInstance(), line))) continue;
            System.err.println("Command not found");
        }
    }

    @Override
    public void start() throws Exception {
        this.pluginsFolder.mkdir();
        this.pluginManager.loadPlugins(this.pluginsFolder);
        this.config.load();
        if (this.reconnectHandler == null) {
            this.reconnectHandler = new YamlReconnectHandler();
        }
        this.isRunning = true;
        this.pluginManager.enablePlugins();
        this.startListeners();
        this.saveThread.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BungeeCord.this.getReconnectHandler().save();
            }
        }, 0L, TimeUnit.MINUTES.toMillis(5L));
        new Metrics().start();
    }

    public void startListeners() {
        for (final ListenerInfo info : this.config.getListeners()) {
            ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).childAttr(PipelineUtils.LISTENER, info).childHandler(PipelineUtils.SERVER_CHILD).group(this.eventLoops).localAddress(info.getHost())).bind().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        BungeeCord.this.listeners.add(future.channel());
                        BungeeCord.this.getLogger().info("Listening on " + info.getHost());
                    } else {
                        BungeeCord.this.getLogger().log(Level.WARNING, "Could not bind to host " + info.getHost(), future.cause());
                    }
                }
            });
        }
    }

    public void stopListeners() {
        for (Channel listener : this.listeners) {
            this.getLogger().log(Level.INFO, "Closing listener {0}", listener);
            try {
                listener.close().syncUninterruptibly();
            }
            catch (ChannelException ex) {
                this.getLogger().severe("Could not close listen thread");
            }
        }
        this.listeners.clear();
    }

    @Override
    public void stop() {
        this.isRunning = false;
        this.httpClient.close();
        this.executors.shutdown();
        this.stopListeners();
        this.getLogger().info("Closing pending connections");
        this.getLogger().info("Disconnecting " + this.connections.size() + " connections");
        for (UserConnection user : this.connections.values()) {
            user.disconnect("Proxy restarting, brb.");
        }
        this.getLogger().info("Closing IO threads");
        this.eventLoops.shutdown();
        this.getLogger().info("Saving reconnect locations");
        this.reconnectHandler.save();
        this.saveThread.cancel();
        this.getLogger().info("Disabling plugins");
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            plugin.onDisable();
            this.getScheduler().cancel(plugin);
        }
        this.getLogger().info("Thank you and goodbye");
        System.exit(0);
    }

    public void broadcast(DefinedPacket packet) {
        for (UserConnection con : this.connections.values()) {
            con.sendPacket(packet);
        }
    }

    @Override
    public String getName() {
        return "BungeeCord";
    }

    @Override
    public String getVersion() {
        return BungeeCord.class.getPackage().getImplementationVersion() == null ? "unknown" : BungeeCord.class.getPackage().getImplementationVersion();
    }

    @Override
    public Logger getLogger() {
        return BungeeLogger.instance;
    }

    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        return this.connections.values();
    }

    @Override
    public ProxiedPlayer getPlayer(String name) {
        return this.connections.get(name);
    }

    @Override
    public Server getServer(String name) {
        Collection<ProxiedPlayer> users = this.getServers().get(name).getPlayers();
        return users != null && !users.isEmpty() ? users.iterator().next().getServer() : null;
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        return this.config.getServers();
    }

    @Override
    public ServerInfo getServerInfo(String name) {
        return this.getServers().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getChannels() {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.pluginChannels);
        }
    }

    public PacketFAPluginMessage registerChannels() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.getChannels()) {
            sb.append(s);
            sb.append('\u0000');
        }
        byte[] payload = sb.substring(0, sb.length() - 1).getBytes();
        return new PacketFAPluginMessage("REGISTER", payload);
    }

    @Override
    public byte getProtocolVersion() {
        return 61;
    }

    @Override
    public String getGameVersion() {
        return GAME_VERSION;
    }

    @Override
    public ServerInfo constructServerInfo(String name, InetSocketAddress address, boolean restricted) {
        return new BungeeServerInfo(name, address, restricted);
    }

    @Override
    public CommandSender getConsole() {
        return ConsoleCommandSender.getInstance();
    }

    @Override
    public TabListHandler getTabListHandler() {
        return this.tabListHandler;
    }

    @Override
    public void setTabListHandler(TabListHandler tabListHandler) {
        this.tabListHandler = tabListHandler;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public ReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    public void setReconnectHandler(ReconnectHandler reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
    }

    @Override
    public ConfigurationAdapter getConfigurationAdapter() {
        return this.configurationAdapter;
    }

    @Override
    public void setConfigurationAdapter(ConfigurationAdapter configurationAdapter) {
        this.configurationAdapter = configurationAdapter;
    }

    @Override
    public File getPluginsFolder() {
        return this.pluginsFolder;
    }

    @Override
    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }
}

