/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToByteCodec;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

public class CipherCodec
extends ByteToByteCodec {
    private Cipher encrypt;
    private Cipher decrypt;
    private ThreadLocal<byte[]> heapInLocal = new EmptyByteThreadLocal();
    private ThreadLocal<byte[]> heapOutLocal = new EmptyByteThreadLocal();

    public CipherCodec(Cipher encrypt, Cipher decrypt) {
        this.encrypt = encrypt;
        this.decrypt = decrypt;
    }

    @Override
    public void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.cipher(in, out, this.encrypt);
    }

    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.cipher(in, out, this.decrypt);
    }

    private void cipher(ByteBuf in, ByteBuf out, Cipher cipher) throws ShortBufferException {
        int readableBytes;
        byte[] heapIn = this.heapInLocal.get();
        if (heapIn.length < (readableBytes = in.readableBytes())) {
            heapIn = new byte[readableBytes];
        }
        in.readBytes(heapIn, 0, readableBytes);
        byte[] heapOut = this.heapOutLocal.get();
        int outputSize = cipher.getOutputSize(readableBytes);
        if (heapOut.length < outputSize) {
            heapOut = new byte[outputSize];
        }
        out.writeBytes(heapOut, 0, cipher.update(heapIn, 0, readableBytes, heapOut));
    }

    private static class EmptyByteThreadLocal
    extends ThreadLocal<byte[]> {
        private EmptyByteThreadLocal() {
        }

        @Override
        protected byte[] initialValue() {
            return new byte[0];
        }
    }
}

