/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.CipherCodec;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.PacketCDClientStatus;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.packet.PacketFEPing;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketHandler;

public class InitialHandler
extends PacketHandler
implements PendingConnection {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final ListenerInfo listener;
    private Packet2Handshake handshake;
    private PacketFDEncryptionRequest request;
    private List<PacketFAPluginMessage> loginMessages = new ArrayList<PacketFAPluginMessage>();
    private State thisState = State.HANDSHAKE;
    private SecretKey sharedKey;
    private boolean disconnected;

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.disconnect((Object)((Object)ChatColor.RED) + Util.exception(t));
    }

    @Override
    public void handle(PacketFAPluginMessage pluginMessage) throws Exception {
        this.loginMessages.add(pluginMessage);
    }

    @Override
    public void handle(PacketFEPing ping) throws Exception {
        ServerPing response = new ServerPing(this.bungee.getProtocolVersion(), this.bungee.getGameVersion(), this.listener.getMotd(), this.bungee.getPlayers().size(), this.listener.getMaxPlayers());
        response = this.bungee.getPluginManager().callEvent(new ProxyPingEvent(this, response)).getResponse();
        String kickMessage = (Object)((Object)ChatColor.DARK_BLUE) + "\u0000" + response.getProtocolVersion() + "\u0000" + response.getGameVersion() + "\u0000" + response.getMotd() + "\u0000" + response.getCurrentPlayers() + "\u0000" + response.getMaxPlayers();
        this.disconnect(kickMessage);
    }

    @Override
    public void handle(Packet2Handshake handshake) throws Exception {
        Preconditions.checkState(this.thisState == State.HANDSHAKE, "Not expecting HANDSHAKE");
        if (handshake.username.length() > 16) {
            this.disconnect("Cannot have username longer than 16 characters");
            return;
        }
        int limit = BungeeCord.getInstance().config.getPlayerLimit();
        Preconditions.checkState(limit <= 0 || this.bungee.getPlayers().size() < limit, "Server is full!");
        this.handshake = handshake;
        this.request = EncryptionUtil.encryptRequest();
        this.ch.write(this.request);
        this.thisState = State.ENCRYPT;
    }

    @Override
    public void handle(PacketFCEncryptionResponse encryptResponse) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT, "Not expecting ENCRYPT");
        this.sharedKey = EncryptionUtil.getSecret(encryptResponse, this.request);
        if (BungeeCord.getInstance().config.isOnlineMode()) {
            String encName = URLEncoder.encode(this.getName(), "UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            for (byte[] bit : new byte[][]{this.request.serverId.getBytes("ISO_8859_1"), this.sharedKey.getEncoded(), EncryptionUtil.keys.getPublic().getEncoded()}) {
                sha.update(bit);
            }
            String encodedHash = URLEncoder.encode(new BigInteger(sha.digest()).toString(16), "UTF-8");
            String authURL = "http://session.minecraft.net/game/checkserver.jsp?user=" + encName + "&serverId=" + encodedHash;
            this.bungee.getHttpClient().prepareGet(authURL).execute(new AsyncCompletionHandler<Response>(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    if ("YES".equals(response.getResponseBody())) {
                        InitialHandler.this.finish();
                    } else {
                        InitialHandler.this.disconnect("Not authenticated with Minecraft.net");
                    }
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    InitialHandler.this.disconnect("Error occured while contacting login servers, are they down?" + Util.exception(t));
                }
            });
        } else {
            this.finish();
        }
    }

    private void finish() throws GeneralSecurityException {
        ProxiedPlayer old = this.bungee.getPlayer(this.handshake.username);
        if (old != null) {
            old.disconnect("You are already connected to the server");
        }
        Callback<LoginEvent> complete = new Callback<LoginEvent>(){

            @Override
            public void done(LoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    InitialHandler.this.disconnect(result.getCancelReason());
                }
                if (InitialHandler.this.disconnected) {
                    return;
                }
                try {
                    Cipher encrypt = EncryptionUtil.getCipher(1, InitialHandler.this.sharedKey);
                    Cipher decrypt = EncryptionUtil.getCipher(2, InitialHandler.this.sharedKey);
                    InitialHandler.this.ch.write(new PacketFCEncryptionResponse());
                    InitialHandler.this.ch.getHandle().pipeline().addBefore("decoder", "cipher", new CipherCodec(encrypt, decrypt));
                    InitialHandler.this.thisState = State.LOGIN;
                }
                catch (GeneralSecurityException ex) {
                    InitialHandler.this.disconnect("Cipher error: " + Util.exception(ex));
                }
            }
        };
        this.bungee.getPluginManager().callEvent(new LoginEvent(this, complete));
    }

    @Override
    public void handle(PacketCDClientStatus clientStatus) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not expecting LOGIN");
        UserConnection userCon = new UserConnection((BungeeCord)this.bungee, this.ch, this, this.handshake, this.loginMessages);
        userCon.init();
        this.bungee.getPluginManager().callEvent(new PostLoginEvent(userCon));
        this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new UpstreamBridge(this.bungee, userCon));
        ServerInfo server = this.bungee.getReconnectHandler().getServer(userCon);
        userCon.connect(server, true);
        this.thisState = State.FINISHED;
        throw new CancelSendSignal();
    }

    @Override
    public synchronized void disconnect(String reason) {
        if (this.ch.getHandle().isActive()) {
            this.ch.write(new PacketFFKick(reason));
            this.ch.getHandle().close();
            this.disconnected = true;
        }
    }

    @Override
    public String getName() {
        return this.handshake == null ? null : this.handshake.username;
    }

    @Override
    public byte getVersion() {
        return this.handshake == null ? (byte)-1 : this.handshake.procolVersion;
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return this.handshake == null ? null : new InetSocketAddress(this.handshake.host, this.handshake.port);
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    @Override
    public String toString() {
        return "[" + (this.getName() != null ? this.getName() : this.getAddress()) + "] <-> InitialHandler";
    }

    @ConstructorProperties(value={"bungee", "listener"})
    public InitialHandler(ProxyServer bungee, ListenerInfo listener) {
        this.bungee = bungee;
        this.listener = listener;
    }

    @Override
    public ListenerInfo getListener() {
        return this.listener;
    }

    private static enum State {
        HANDSHAKE,
        ENCRYPT,
        LOGIN,
        FINISHED;

    }
}

