/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.config;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.tablist.Global;
import net.md_5.bungee.tablist.GlobalPing;
import net.md_5.bungee.tablist.ServerUnique;

public class Configuration {
    private int timeout = 30000;
    private String uuid = UUID.randomUUID().toString();
    private Collection<ListenerInfo> listeners;
    private Map<String, ServerInfo> servers;
    private boolean onlineMode = true;
    private int playerLimit = -1;

    public void load() {
        ConfigurationAdapter adapter = ProxyServer.getInstance().getConfigurationAdapter();
        adapter.load();
        this.timeout = adapter.getInt("timeout", this.timeout);
        this.uuid = adapter.getString("stats", this.uuid);
        this.onlineMode = adapter.getBoolean("online_mode", this.onlineMode);
        this.playerLimit = adapter.getInt("player_limit", this.playerLimit);
        DefaultTabList tab = DefaultTabList.valueOf(adapter.getString("tab_list", "GLOBAL_PING"));
        if (tab == null) {
            tab = DefaultTabList.GLOBAL_PING;
        }
        switch (tab) {
            case GLOBAL: {
                ProxyServer.getInstance().setTabListHandler(new Global());
                break;
            }
            case GLOBAL_PING: {
                ProxyServer.getInstance().setTabListHandler(new GlobalPing());
                break;
            }
            case SERVER: {
                ProxyServer.getInstance().setTabListHandler(new ServerUnique());
            }
        }
        this.listeners = adapter.getListeners();
        Preconditions.checkArgument(this.listeners != null && !this.listeners.isEmpty(), "No listeners defined.");
        Map<String, ServerInfo> newServers = adapter.getServers();
        Preconditions.checkArgument(newServers != null && !newServers.isEmpty(), "No servers defined");
        if (this.servers == null) {
            this.servers = newServers;
        } else {
            for (ServerInfo serverInfo : this.servers.values()) {
                Preconditions.checkArgument(newServers.containsValue(serverInfo), "Server %s removed on reload!", serverInfo.getName());
            }
            for (Map.Entry entry : newServers.entrySet()) {
                if (this.servers.containsValue(entry.getValue())) continue;
                this.servers.put((String)entry.getKey(), (ServerInfo)entry.getValue());
            }
        }
        for (ListenerInfo listenerInfo : this.listeners) {
            Preconditions.checkArgument(this.servers.containsKey(listenerInfo.getDefaultServer()), "Default server %s is not defined", listenerInfo.getDefaultServer());
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Collection<ListenerInfo> getListeners() {
        return this.listeners;
    }

    public Map<String, ServerInfo> getServers() {
        return this.servers;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public int getPlayerLimit() {
        return this.playerLimit;
    }

    private static enum DefaultTabList {
        GLOBAL,
        GLOBAL_PING,
        SERVER;

    }
}

