/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.aio;

import io.netty.channel.EventLoopException;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.aio.AioEventLoop;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AioEventLoopGroup
extends MultithreadEventLoopGroup {
    private final AioExecutorService groupExecutor = new AioExecutorService();
    private final AsynchronousChannelGroup group;

    public AsynchronousChannelGroup channelGroup() {
        return this.group;
    }

    public AioEventLoopGroup() {
        this(0);
    }

    public AioEventLoopGroup(int nThreads) {
        this(nThreads, null);
    }

    public AioEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        super(nThreads, threadFactory, new Object[0]);
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(this.groupExecutor);
        }
        catch (IOException e) {
            throw new EventLoopException("Failed to create an AsynchronousChannelGroup", e);
        }
    }

    @Override
    public void shutdown() {
        boolean interrupted = false;
        try {
            this.group.shutdownNow();
        }
        catch (IOException e) {
            throw new EventLoopException("failed to shut down a channel group", e);
        }
        while (!this.groupExecutor.isTerminated()) {
            try {
                this.groupExecutor.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        super.shutdown();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected EventExecutor newChild(ThreadFactory threadFactory, Object ... args) throws Exception {
        return new AioEventLoop(this, threadFactory);
    }

    private static final class AioExecutorService
    extends AbstractExecutorService {
        private final CountDownLatch latch = new CountDownLatch(1);

        private AioExecutorService() {
        }

        @Override
        public void shutdown() {
            this.latch.countDown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown();
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return this.latch.getCount() == 0L;
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

