/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.config;

import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public abstract class ServerInfo {
    private final String name;
    private final InetSocketAddress address;
    private final Collection<ProxiedPlayer> players = new ArrayList<ProxiedPlayer>();
    private final boolean restricted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.add(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.remove(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProxiedPlayer> getPlayers() {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.players);
        }
    }

    public abstract void sendData(String var1, byte[] var2);

    public abstract void ping(Callback<ServerPing> var1);

    public boolean canAccess(ProxiedPlayer player) {
        return !this.restricted || player.hasPermission("bungeecord.server." + this.name);
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerInfo && Objects.equals(this.getAddress(), ((ServerInfo)obj).getAddress());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.getClass());
        hash = 73 * hash + Objects.hashCode(this.getAddress());
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public String toString() {
        return "ServerInfo(name=" + this.getName() + ", address=" + this.getAddress() + ", players=" + this.getPlayers() + ", restricted=" + this.isRestricted() + ")";
    }

    @ConstructorProperties(value={"name", "address", "restricted"})
    public ServerInfo(String name, InetSocketAddress address, boolean restricted) {
        this.name = name;
        this.address = address;
        this.restricted = restricted;
    }
}

