/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToByteCodec;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

public class CipherCodec
extends ByteToByteCodec {
    private Cipher encrypt;
    private Cipher decrypt;
    private byte[] heapIn = new byte[0];
    private byte[] heapOut = new byte[0];

    public CipherCodec(Cipher encrypt, Cipher decrypt) {
        this.encrypt = encrypt;
        this.decrypt = decrypt;
    }

    @Override
    public void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.cipher(in, out, this.encrypt);
    }

    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.cipher(in, out, this.decrypt);
    }

    private void cipher(ByteBuf in, ByteBuf out, Cipher cipher) throws ShortBufferException {
        int readableBytes = in.readableBytes();
        if (this.heapIn.length < readableBytes) {
            this.heapIn = new byte[readableBytes];
        }
        in.readBytes(this.heapIn, 0, readableBytes);
        int outputSize = cipher.getOutputSize(readableBytes);
        if (this.heapOut.length < outputSize) {
            this.heapOut = new byte[outputSize];
        }
        out.writeBytes(this.heapOut, 0, cipher.update(this.heapIn, 0, readableBytes, this.heapOut));
    }
}

