/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;

public abstract class ByteToByteDecoder
extends ChannelInboundByteHandlerAdapter {
    private volatile boolean singleDecode;

    public void setSingleDecode(boolean singleDecode) {
        this.singleDecode = singleDecode;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    @Override
    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        this.callDecode(ctx, in, ctx.nextInboundByteBuffer());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf in = ctx.inboundByteBuffer();
        ByteBuf out = ctx.nextInboundByteBuffer();
        if (!in.isReadable()) {
            this.callDecode(ctx, in, out);
        }
        int oldOutSize = out.readableBytes();
        try {
            this.decodeLast(ctx, in, out);
        }
        catch (Throwable t) {
            if (t instanceof CodecException) {
                ctx.fireExceptionCaught(t);
            }
            ctx.fireExceptionCaught(new DecoderException(t));
        }
        if (out.readableBytes() > oldOutSize) {
            ctx.fireInboundBufferUpdated();
        }
        ctx.fireChannelInactive();
    }

    private void callDecode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        int oldOutSize = out.readableBytes();
        while (in.isReadable()) {
            int oldInSize = in.readableBytes();
            try {
                this.decode(ctx, in, out);
            }
            catch (Throwable t) {
                if (t instanceof CodecException) {
                    ctx.fireExceptionCaught(t);
                }
                ctx.fireExceptionCaught(new DecoderException(t));
            }
            if (oldInSize != in.readableBytes() && !this.isSingleDecode()) continue;
            break;
        }
        if (out.readableBytes() > oldOutSize) {
            ctx.fireInboundBufferUpdated();
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, ByteBuf var3) throws Exception;

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.decode(ctx, in, out);
    }
}

