/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.BufType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPromise;
import io.netty.channel.NoSuchBufferException;
import io.netty.channel.ServerChannel;
import java.net.SocketAddress;

public abstract class AbstractServerChannel
extends AbstractChannel
implements ServerChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(BufType.MESSAGE, false);

    protected AbstractServerChannel(Integer id) {
        super(null, id);
    }

    @Override
    public ByteBuf outboundByteBuffer() {
        throw new NoSuchBufferException(String.format("%s does not have an outbound buffer.", ServerChannel.class.getSimpleName()));
    }

    @Override
    public <T> MessageBuf<T> outboundMessageBuffer() {
        throw new NoSuchBufferException(String.format("%s does not have an outbound buffer.", ServerChannel.class.getSimpleName()));
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SocketAddress remoteAddress() {
        return null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isFlushPending() {
        return false;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultServerUnsafe();
    }

    private final class DefaultServerUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultServerUnsafe() {
        }

        @Override
        public void flush(final ChannelPromise future) {
            if (AbstractServerChannel.this.eventLoop().inEventLoop()) {
                this.reject(future);
            } else {
                AbstractServerChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultServerUnsafe.this.flush(future);
                    }
                });
            }
        }

        @Override
        public void connect(final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise future) {
            if (AbstractServerChannel.this.eventLoop().inEventLoop()) {
                this.reject(future);
            } else {
                AbstractServerChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultServerUnsafe.this.connect(remoteAddress, localAddress, future);
                    }
                });
            }
        }

        private void reject(ChannelPromise future) {
            UnsupportedOperationException cause = new UnsupportedOperationException();
            future.setFailure(cause);
        }
    }
}

