/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.netty.channel.Channel;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFFKick;

public class ServerConnection
implements Server {
    private final Channel ch;
    private final ServerInfo info;
    private final Packet1Login loginPacket;
    private boolean isObsolete;

    @Override
    public void sendData(String channel, byte[] data) {
        this.ch.write(new PacketFAPluginMessage(channel, data));
    }

    @Override
    public synchronized void disconnect(String reason) {
        ServerConnection.disconnect(this.ch, reason);
    }

    static void disconnect(final Channel ch, String reason) {
        if (ch.isActive()) {
            ch.write(new PacketFFKick(reason));
            ch.eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    ch.close();
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getInfo().getAddress();
    }

    @ConstructorProperties(value={"ch", "info", "loginPacket"})
    public ServerConnection(Channel ch, ServerInfo info, Packet1Login loginPacket) {
        this.ch = ch;
        this.info = info;
        this.loginPacket = loginPacket;
    }

    public Channel getCh() {
        return this.ch;
    }

    @Override
    public ServerInfo getInfo() {
        return this.info;
    }

    public Packet1Login getLoginPacket() {
        return this.loginPacket;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setObsolete(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }
}

