/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.stream;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class ChunkedWriteHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler,
LifeCycleAwareChannelHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<MessageEvent> queue = new ConcurrentLinkedQueue<MessageEvent>();
    private volatile ChannelHandlerContext ctx;
    private final AtomicBoolean flush = new AtomicBoolean(false);
    private MessageEvent currentEvent;
    private volatile boolean flushNeeded;

    public void resumeTransfer() {
        block3: {
            ChannelHandlerContext ctx = this.ctx;
            if (ctx == null) {
                return;
            }
            try {
                this.flush(ctx, false);
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Unexpected exception while sending chunks.", e);
            }
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!(e instanceof MessageEvent)) {
            ctx.sendDownstream(e);
            return;
        }
        boolean offered = this.queue.offer((MessageEvent)e);
        assert (offered);
        Channel channel = ctx.getChannel();
        if (channel.isWritable() || !channel.isConnected()) {
            this.ctx = ctx;
            this.flush(ctx, false);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent cse = (ChannelStateEvent)e;
            switch (cse.getState()) {
                case INTEREST_OPS: {
                    this.flush(ctx, true);
                    break;
                }
                case OPEN: {
                    if (Boolean.TRUE.equals(cse.getValue())) break;
                    this.flush(ctx, true);
                }
            }
        }
        ctx.sendUpstream(e);
    }

    private void discard(ChannelHandlerContext ctx, boolean fireNow) {
        ClosedChannelException cause = null;
        while (true) {
            MessageEvent currentEvent = this.currentEvent;
            if (this.currentEvent == null) {
                currentEvent = this.queue.poll();
            } else {
                this.currentEvent = null;
            }
            if (currentEvent == null) break;
            Object m = currentEvent.getMessage();
            if (m instanceof ChunkedInput) {
                ChunkedWriteHandler.closeInput((ChunkedInput)m);
            }
            if (cause == null) {
                cause = new ClosedChannelException();
            }
            currentEvent.getFuture().setFailure(cause);
        }
        if (cause != null) {
            if (fireNow) {
                Channels.fireExceptionCaught(ctx.getChannel(), cause);
            } else {
                Channels.fireExceptionCaughtLater(ctx.getChannel(), cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(ChannelHandlerContext ctx, boolean fireNow) throws Exception {
        Channel channel = ctx.getChannel();
        boolean suspend = false;
        this.flushNeeded = true;
        boolean acquired = this.flush.compareAndSet(false, true);
        if (acquired) {
            this.flushNeeded = false;
            try {
                if (!channel.isConnected()) {
                    this.discard(ctx, fireNow);
                    Object var13_6 = null;
                    this.flush.set(false);
                    return;
                }
                while (channel.isWritable()) {
                    if (this.currentEvent == null) {
                        this.currentEvent = this.queue.poll();
                    }
                    if (this.currentEvent == null) break;
                    if (this.currentEvent.getFuture().isDone()) {
                        this.currentEvent = null;
                    } else {
                        final MessageEvent currentEvent = this.currentEvent;
                        Object m = currentEvent.getMessage();
                        if (m instanceof ChunkedInput) {
                            ChannelFuture writeFuture;
                            boolean endOfInput;
                            Object chunk;
                            final ChunkedInput chunks = (ChunkedInput)m;
                            try {
                                chunk = chunks.nextChunk();
                                endOfInput = chunks.isEndOfInput();
                                if (chunk == null) {
                                    chunk = ChannelBuffers.EMPTY_BUFFER;
                                    suspend = !endOfInput;
                                } else {
                                    suspend = false;
                                }
                            }
                            catch (Throwable t) {
                                this.currentEvent = null;
                                currentEvent.getFuture().setFailure(t);
                                if (fireNow) {
                                    Channels.fireExceptionCaught(ctx, t);
                                } else {
                                    Channels.fireExceptionCaughtLater(ctx, t);
                                }
                                ChunkedWriteHandler.closeInput(chunks);
                                break;
                            }
                            if (suspend) break;
                            if (endOfInput) {
                                this.currentEvent = null;
                                writeFuture = currentEvent.getFuture();
                                writeFuture.addListener(new ChannelFutureListener(){

                                    public void operationComplete(ChannelFuture future) throws Exception {
                                        ChunkedWriteHandler.closeInput(chunks);
                                    }
                                });
                            } else {
                                writeFuture = Channels.future(channel);
                                writeFuture.addListener(new ChannelFutureListener(){

                                    public void operationComplete(ChannelFuture future) throws Exception {
                                        if (!future.isSuccess()) {
                                            currentEvent.getFuture().setFailure(future.getCause());
                                            ChunkedWriteHandler.closeInput((ChunkedInput)currentEvent.getMessage());
                                        }
                                    }
                                });
                            }
                            Channels.write(ctx, writeFuture, chunk, currentEvent.getRemoteAddress());
                        } else {
                            this.currentEvent = null;
                            ctx.sendDownstream(currentEvent);
                        }
                    }
                    if (channel.isConnected()) continue;
                    this.discard(ctx, fireNow);
                }
            }
            catch (Throwable throwable) {
                Object var13_9 = null;
                this.flush.set(false);
                throw throwable;
            }
            {
                Object var13_7 = null;
                this.flush.set(false);
                return;
            }
            Object var13_8 = null;
            this.flush.set(false);
            {
            }
        }
        if (acquired && (!channel.isConnected() || channel.isWritable() && !this.queue.isEmpty() && !suspend || this.flushNeeded)) {
            this.flush(ctx, fireNow);
        }
    }

    static void closeInput(ChunkedInput chunks) {
        block2: {
            try {
                chunks.close();
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a chunked input.", t);
            }
        }
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        this.flush(ctx, false);
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        IOException cause = null;
        boolean fireExceptionCaught = false;
        while (true) {
            MessageEvent currentEvent = this.currentEvent;
            if (this.currentEvent == null) {
                currentEvent = this.queue.poll();
            } else {
                this.currentEvent = null;
            }
            if (currentEvent == null) break;
            Object m = currentEvent.getMessage();
            if (m instanceof ChunkedInput) {
                ChunkedWriteHandler.closeInput((ChunkedInput)m);
            }
            if (cause == null) {
                cause = new IOException("Unable to flush event, discarding");
            }
            currentEvent.getFuture().setFailure(cause);
            fireExceptionCaught = true;
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaughtLater(ctx.getChannel(), cause);
        }
    }
}

