/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.plugin;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginClassloader;
import net.md_5.bungee.api.plugin.PluginDescription;
import org.yaml.snakeyaml.Yaml;

public class PluginManager {
    private static final Pattern argsSplit = Pattern.compile(" ");
    private final ProxyServer proxy;
    private final Yaml yaml = new Yaml();
    private final EventBus eventBus = new EventBus();
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();
    private final Map<String, Command> commandMap = new HashMap<String, Command>();

    @Deprecated
    public void registerCommand(Command command) {
        this.registerCommand(null, command);
    }

    public void registerCommand(Plugin plugin, Command command) {
        this.commandMap.put(command.getName().toLowerCase(), command);
        for (String alias : command.getAliases()) {
            this.commandMap.put(alias.toLowerCase(), command);
        }
    }

    public void unregisterCommand(Command command) {
        this.commandMap.values().remove(command);
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        String[] split = argsSplit.split(commandLine);
        Command command = this.commandMap.get(split[0].toLowerCase());
        if (command == null) {
            return false;
        }
        String permission = command.getPermission();
        if (permission != null && !permission.isEmpty() && !sender.hasPermission(permission)) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "You do not have permission to execute this command!");
            return true;
        }
        String[] args = Arrays.copyOfRange(split, 1, split.length);
        try {
            command.execute(sender, args);
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "An internal error occurred whilst executing this command, please check the console log for details.");
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Error in dispatching command", ex);
        }
        return true;
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    public Plugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public void enablePlugins() {
        for (Map.Entry<String, Plugin> entry : this.plugins.entrySet()) {
            Plugin plugin = entry.getValue();
            try {
                plugin.onEnable();
                ProxyServer.getInstance().getLogger().log(Level.INFO, "Enabled plugin {0} version {1} by {2}", new Object[]{entry.getKey(), plugin.getDescription().getVersion(), plugin.getDescription().getAuthor()});
            }
            catch (Exception ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Exception encountered when loading plugin: " + entry.getKey(), ex);
            }
        }
    }

    public void loadPlugin(File file) throws Exception {
        Preconditions.checkNotNull(file, "file");
        Preconditions.checkArgument(file.isFile(), "Must load from file");
        try (JarFile jar = new JarFile(file);){
            JarEntry pdf = jar.getJarEntry("plugin.yml");
            Preconditions.checkNotNull(pdf, "Plugin must have a plugin.yml");
            try (InputStream in = jar.getInputStream(pdf);){
                PluginDescription desc = this.yaml.loadAs(in, PluginDescription.class);
                PluginClassloader loader = new PluginClassloader(new URL[]{file.toURI().toURL()});
                Class<?> main = loader.loadClass(desc.getMain());
                Plugin plugin = (Plugin)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.init(this.proxy, desc);
                this.plugins.put(desc.getName(), plugin);
                plugin.onLoad();
                ProxyServer.getInstance().getLogger().log(Level.INFO, "Loaded plugin {0} version {1} by {2}", new Object[]{desc.getName(), desc.getVersion(), desc.getAuthor()});
            }
        }
    }

    public void loadPlugins(File folder) {
        Preconditions.checkNotNull(folder, "folder");
        Preconditions.checkArgument(folder.isDirectory(), "Must load from a directory");
        for (File file : folder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try {
                this.loadPlugin(file);
            }
            catch (Exception ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load plugin from file " + file, ex);
            }
        }
    }

    public <T extends Event> T callEvent(T event) {
        long elapsed;
        Preconditions.checkNotNull(event, "event");
        long start = System.nanoTime();
        this.eventBus.post(event);
        event.postCall();
        if (!(event instanceof LoginEvent) && (elapsed = start - System.nanoTime()) > 250000L) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Event {0} took more {1}ns to process!", new Object[]{event, elapsed});
        }
        return event;
    }

    @Deprecated
    public void registerListener(Listener listener) {
        this.registerListener(null, listener);
    }

    public void registerListener(Plugin plugin, Listener listener) {
        this.eventBus.register(listener);
    }

    @ConstructorProperties(value={"proxy"})
    public PluginManager(ProxyServer proxy) {
        this.proxy = proxy;
    }
}

