/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.event;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Plugin;

public class AsyncEvent
extends Event {
    private final Callback done;
    private final Set<Plugin> intents = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean fired = new AtomicBoolean();
    private final AtomicInteger latch = new AtomicInteger();

    @Override
    public void postCall() {
        this.fired.set(true);
        if (this.latch.get() == 0) {
            this.done.done(this, null);
        }
    }

    public void registerIntent(Plugin plugin) {
        Preconditions.checkState(!this.fired.get(), "Event %s has already been fired", this);
        Preconditions.checkState(!this.intents.contains(plugin), "Plugin %s already registered intent for event %s", plugin, this);
        this.intents.add(plugin);
    }

    public void completeIntent(Plugin plugin) {
        Preconditions.checkState(this.intents.contains(plugin), "Plugin %s has not registered intent for event %s", plugin, this);
        this.intents.remove(plugin);
        if (this.latch.decrementAndGet() == 0) {
            this.done.done(this, null);
        }
    }

    @ConstructorProperties(value={"done"})
    public AsyncEvent(Callback done) {
        this.done = done;
    }

    public Callback getDone() {
        return this.done;
    }

    public Set<Plugin> getIntents() {
        return this.intents;
    }

    public AtomicBoolean getFired() {
        return this.fired;
    }

    public AtomicInteger getLatch() {
        return this.latch;
    }

    public String toString() {
        return "AsyncEvent(super=" + super.toString() + ", done=" + this.getDone() + ", intents=" + this.getIntents() + ", fired=" + this.getFired() + ", latch=" + this.getLatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncEvent)) {
            return false;
        }
        AsyncEvent other = (AsyncEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Callback this$done = this.getDone();
        Callback other$done = other.getDone();
        if (this$done == null ? other$done != null : !this$done.equals(other$done)) {
            return false;
        }
        Set<Plugin> this$intents = this.getIntents();
        Set<Plugin> other$intents = other.getIntents();
        if (this$intents == null ? other$intents != null : !((Object)this$intents).equals(other$intents)) {
            return false;
        }
        AtomicBoolean this$fired = this.getFired();
        AtomicBoolean other$fired = other.getFired();
        if (this$fired == null ? other$fired != null : !this$fired.equals(other$fired)) {
            return false;
        }
        AtomicInteger this$latch = this.getLatch();
        AtomicInteger other$latch = other.getLatch();
        return !(this$latch == null ? other$latch != null : !this$latch.equals(other$latch));
    }

    public boolean canEqual(Object other) {
        return other instanceof AsyncEvent;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        Callback $done = this.getDone();
        result = result * 31 + ($done == null ? 0 : $done.hashCode());
        Set<Plugin> $intents = this.getIntents();
        result = result * 31 + ($intents == null ? 0 : ((Object)$intents).hashCode());
        AtomicBoolean $fired = this.getFired();
        result = result * 31 + ($fired == null ? 0 : $fired.hashCode());
        AtomicInteger $latch = this.getLatch();
        result = result * 31 + ($latch == null ? 0 : $latch.hashCode());
        return result;
    }
}

