/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.EventListener;

final class DefaultPromiseListeners {
    private GenericFutureListener<? extends Future>[] listeners;
    private int size;

    DefaultPromiseListeners(GenericFutureListener<? extends Future> firstListener, GenericFutureListener<? extends Future> secondListener) {
        this.listeners = new GenericFutureListener[]{firstListener, secondListener};
        this.size = 2;
    }

    void add(GenericFutureListener<? extends Future> l) {
        int size = this.size;
        GenericFutureListener<? extends Future>[] listeners = this.listeners;
        if (size == listeners.length) {
            this.listeners = listeners = Arrays.copyOf(listeners, size << 1);
        }
        listeners[size] = l;
        this.size = size + 1;
    }

    void remove(EventListener l) {
        GenericFutureListener<? extends Future>[] listeners = this.listeners;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            if (listeners[i] != l) continue;
            int listenersToMove = size - i - 1;
            if (listenersToMove > 0) {
                System.arraycopy(listeners, i + 1, listeners, i, listenersToMove);
            }
            listeners[--size] = null;
            this.size = size;
            return;
        }
    }

    GenericFutureListener<? extends Future>[] listeners() {
        return this.listeners;
    }

    int size() {
        return this.size;
    }
}

