/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import net.minecraft.server.NBTBase;

public class NBTTagIntArray
extends NBTBase {
    public int[] data;

    public NBTTagIntArray(String string) {
        super(string);
    }

    public NBTTagIntArray(String string, int[] nArray) {
        super(string);
        this.data = nArray;
    }

    void write(DataOutput dataOutput) {
        dataOutput.writeInt(this.data.length);
        for (int n : this.data) {
            dataOutput.writeInt(n);
        }
    }

    void load(DataInput dataInput) {
        int n = dataInput.readInt();
        this.data = new int[n];
        for (int i = 0; i < n; ++i) {
            this.data[i] = dataInput.readInt();
        }
    }

    public byte getTypeId() {
        return 11;
    }

    public String toString() {
        return "[" + this.data.length + " bytes]";
    }

    public NBTBase clone() {
        int[] nArray = new int[this.data.length];
        System.arraycopy(this.data, 0, nArray, 0, this.data.length);
        return new NBTTagIntArray(this.getName(), nArray);
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagIntArray nBTTagIntArray = (NBTTagIntArray)object;
            return this.data == null && nBTTagIntArray.data == null || this.data != null && Arrays.equals(this.data, nBTTagIntArray.data);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.data);
    }
}

