/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopException;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.concurrent.TaskScheduler;
import java.util.concurrent.ThreadFactory;

public abstract class SingleThreadEventLoop
extends SingleThreadEventExecutor
implements EventLoop {
    protected SingleThreadEventLoop(EventLoopGroup parent, ThreadFactory threadFactory, TaskScheduler scheduler) {
        super(parent, threadFactory, scheduler);
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return this.register(channel, channel.newPromise());
    }

    @Override
    public ChannelFuture register(final Channel channel, final ChannelPromise promise) {
        if (this.isShutdown()) {
            channel.unsafe().closeForcibly();
            promise.setFailure(new EventLoopException("cannot register a channel to a shut down loop"));
            return promise;
        }
        if (this.inEventLoop()) {
            channel.unsafe().register(this, promise);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    channel.unsafe().register(SingleThreadEventLoop.this, promise);
                }
            });
        }
        return promise;
    }
}

