/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.netty;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import net.md_5.bungee.protocol.PacketDefinitions;
import net.md_5.bungee.protocol.netty.Instruction;
import net.md_5.bungee.protocol.netty.Jump;

public class PacketReader {
    private static final Instruction[][] instructions = new Instruction[PacketDefinitions.opCodes.length][];

    private static void readPacket(int packetId, ByteBuf in, int protocol) throws IOException {
        Instruction[] packetDef = null;
        if (packetId + protocol < instructions.length) {
            packetDef = instructions[packetId + protocol];
        }
        if (packetDef == null) {
            if (protocol == 0) {
                throw new IOException("Unknown packet id " + packetId);
            }
            PacketReader.readPacket(packetId, in, 0);
            return;
        }
        for (Instruction instruction : packetDef) {
            instruction.read(in);
        }
    }

    public static void readPacket(ByteBuf in, int protocol) throws IOException {
        short packetId = in.readUnsignedByte();
        PacketReader.readPacket(packetId, in, protocol);
    }

    static {
        for (int i = 0; i < instructions.length; ++i) {
            ArrayList<Instruction> output = new ArrayList<Instruction>();
            PacketDefinitions.OpCode[] enums = PacketDefinitions.opCodes[i];
            if (enums == null) continue;
            for (PacketDefinitions.OpCode struct : enums) {
                try {
                    output.add((Instruction)Instruction.class.getDeclaredField(struct.name()).get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                    throw new UnsupportedOperationException("No definition for " + struct.name());
                }
            }
            ArrayList<Instruction> crushed = new ArrayList<Instruction>();
            int nextJumpSize = 0;
            for (Instruction child : output) {
                if (child instanceof Jump) {
                    nextJumpSize += ((Jump)child).len;
                    continue;
                }
                if (nextJumpSize != 0) {
                    crushed.add(new Jump(nextJumpSize));
                }
                crushed.add(child);
                nextJumpSize = 0;
            }
            if (nextJumpSize != 0) {
                crushed.add(new Jump(nextJumpSize));
            }
            PacketReader.instructions[i] = crushed.toArray(new Instruction[crushed.size()]);
        }
    }
}

