/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToByteCodec;
import javax.crypto.Cipher;

public class CipherCodec
extends ByteToByteCodec {
    private Cipher encrypt;
    private Cipher decrypt;
    private ByteBuf heapIn;
    private ByteBuf heapOut;

    public CipherCodec(Cipher encrypt, Cipher decrypt) {
        this.encrypt = encrypt;
        this.decrypt = decrypt;
    }

    @Override
    public void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.cipher(ctx, in, out, this.encrypt);
    }

    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.cipher(ctx, in, out, this.decrypt);
    }

    @Override
    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        super.freeInboundBuffer(ctx);
        this.free();
    }

    @Override
    public void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        super.freeOutboundBuffer(ctx);
        this.free();
    }

    private void free() {
        if (this.heapIn != null) {
            this.heapIn.release();
            this.heapIn = null;
        }
        if (this.heapOut != null) {
            this.heapOut.release();
            this.heapOut = null;
        }
    }

    private void cipher(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out, Cipher cipher) throws Exception {
        try {
            if (this.heapIn == null) {
                this.heapIn = ctx.alloc().heapBuffer();
            }
            int readableBytes = in.readableBytes();
            this.heapIn.capacity(this.heapIn.writerIndex() + readableBytes);
            in.readBytes(this.heapIn);
            if (this.heapOut == null) {
                this.heapOut = ctx.alloc().heapBuffer();
            }
            int outputSize = cipher.getOutputSize(readableBytes);
            if (this.heapOut.writableBytes() < outputSize) {
                this.heapOut.capacity(this.heapOut.writerIndex() + outputSize);
            }
            int processed = cipher.update(this.heapIn.array(), this.heapIn.arrayOffset() + this.heapIn.readerIndex(), readableBytes, this.heapOut.array(), this.heapOut.arrayOffset() + this.heapOut.writerIndex());
            this.heapOut.writerIndex(this.heapOut.writerIndex() + processed);
            out.writeBytes(this.heapOut);
            this.heapIn.clear();
            this.heapOut.clear();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

