/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.ChannelException;
import io.netty.channel.EventLoopException;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.nio.NioTask;
import io.netty.util.concurrent.TaskScheduler;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NioEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger;
    private static final int CLEANUP_INTERVAL = 256;
    private static final boolean EPOLL_BUG_WORKAROUND;
    private static final long SELECT_TIMEOUT;
    private static final long SELECT_TIMEOUT_NANOS;
    Selector selector;
    private final SelectorProvider provider;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private volatile int ioRatio = 50;
    private int cancelledKeys;
    private boolean cleanedCancelledKeys;

    NioEventLoop(NioEventLoopGroup parent, ThreadFactory threadFactory, TaskScheduler scheduler, SelectorProvider selectorProvider) {
        super(parent, threadFactory, scheduler);
        if (selectorProvider == null) {
            throw new NullPointerException("selectorProvider");
        }
        this.provider = selectorProvider;
        this.selector = this.openSelector();
    }

    private Selector openSelector() {
        try {
            return this.provider.openSelector();
        }
        catch (IOException e) {
            throw new ChannelException("failed to open a new selector", e);
        }
    }

    @Override
    protected Queue<Runnable> newTaskQueue() {
        return new ConcurrentLinkedQueue<Runnable>();
    }

    public void register(SelectableChannel ch, int interestOps, NioTask<?> task) {
        if (ch == null) {
            throw new NullPointerException("ch");
        }
        if (interestOps == 0) {
            throw new IllegalArgumentException("interestOps must be non-zero.");
        }
        if ((interestOps & ~ch.validOps()) != 0) {
            throw new IllegalArgumentException("invalid interestOps: " + interestOps + "(validOps: " + ch.validOps() + ')');
        }
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (this.isShutdown()) {
            throw new IllegalStateException("event loop shut down");
        }
        try {
            ch.register(this.selector, interestOps, task);
        }
        catch (Exception e) {
            throw new EventLoopException("failed to register a channel", e);
        }
    }

    void executeWhenWritable(AbstractNioChannel channel, NioTask<SelectableChannel> task) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (this.isShutdown()) {
            throw new IllegalStateException("event loop shut down");
        }
        SelectionKey key = channel.selectionKey();
        channel.writableTasks.offer(task);
        int interestOps = key.interestOps();
        if ((interestOps & 4) == 0) {
            key.interestOps(interestOps | 4);
        }
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int ioRatio) {
        if (ioRatio <= 0 || ioRatio >= 100) {
            throw new IllegalArgumentException("ioRatio: " + ioRatio + " (expected: 0 < ioRatio < 100)");
        }
        this.ioRatio = ioRatio;
    }

    public void rebuildSelector() {
        int nChannels;
        block13: {
            Selector newSelector;
            if (!this.inEventLoop()) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        NioEventLoop.this.rebuildSelector();
                    }
                });
                return;
            }
            Selector oldSelector = this.selector;
            if (oldSelector == null) {
                return;
            }
            try {
                newSelector = Selector.open();
            }
            catch (Exception e) {
                logger.warn("Failed to create a new Selector.", e);
                return;
            }
            nChannels = 0;
            while (true) {
                try {
                    for (SelectionKey key : oldSelector.keys()) {
                        Object a = key.attachment();
                        try {
                            if (key.channel().keyFor(newSelector) != null) continue;
                            int interestOps = key.interestOps();
                            key.cancel();
                            key.channel().register(newSelector, interestOps, a);
                            ++nChannels;
                        }
                        catch (Exception e) {
                            logger.warn("Failed to re-register a Channel to the new Selector.", e);
                            if (a instanceof AbstractNioChannel) {
                                AbstractNioChannel ch = (AbstractNioChannel)a;
                                ch.unsafe().close(ch.unsafe().voidFuture());
                                continue;
                            }
                            NioTask task = (NioTask)a;
                            NioEventLoop.invokeChannelUnregistered(task, key, e);
                        }
                    }
                }
                catch (ConcurrentModificationException e) {
                    continue;
                }
                break;
            }
            this.selector = newSelector;
            try {
                oldSelector.close();
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block13;
                logger.warn("Failed to close the old Selector.", t);
            }
        }
        logger.info("Migrated " + nChannels + " channel(s) to the new Selector.");
    }

    @Override
    protected void run() {
        long minSelectTimeout = SELECT_TIMEOUT_NANOS / 100L * 80L;
        Selector selector = this.selector;
        int selectReturnsImmediately = 0;
        while (true) {
            this.wakenUp.set(false);
            try {
                if (this.hasTasks()) {
                    this.selectNow();
                } else {
                    long beforeSelect = System.nanoTime();
                    int selected = this.select();
                    if (EPOLL_BUG_WORKAROUND) {
                        if (selected == 0) {
                            long timeBlocked = System.nanoTime() - beforeSelect;
                            selectReturnsImmediately = timeBlocked < minSelectTimeout ? ++selectReturnsImmediately : 0;
                            if (selectReturnsImmediately == 10) {
                                this.rebuildSelector();
                                selector = this.selector;
                                selectReturnsImmediately = 0;
                                continue;
                            }
                        } else {
                            selectReturnsImmediately = 0;
                        }
                    }
                    if (this.wakenUp.get()) {
                        selector.wakeup();
                    }
                }
                this.cancelledKeys = 0;
                long ioStartTime = System.nanoTime();
                this.processSelectedKeys();
                selector = this.selector;
                long ioTime = System.nanoTime() - ioStartTime;
                int ioRatio = this.ioRatio;
                this.runAllTasks(ioTime * (long)(100 - ioRatio) / (long)ioRatio);
                selector = this.selector;
                if (!this.isShutdown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            break;
        }
    }

    @Override
    protected void cleanup() {
        try {
            this.selector.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a selector.", e);
        }
    }

    void cancel(SelectionKey key) {
        key.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.cleanedCancelledKeys = true;
            this.cleanupKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSelectedKeys() {
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        if (selectedKeys.isEmpty()) {
            return;
        }
        this.cleanedCancelledKeys = false;
        boolean clearSelectedKeys = true;
        try {
            Iterator<SelectionKey> i = selectedKeys.iterator();
            while (i.hasNext()) {
                SelectionKey k = i.next();
                Object a = k.attachment();
                if (a instanceof AbstractNioChannel) {
                    NioEventLoop.processSelectedKey(k, (AbstractNioChannel)a);
                } else {
                    NioTask task = (NioTask)a;
                    NioEventLoop.processSelectedKey(k, task);
                }
                if (!this.cleanedCancelledKeys) continue;
                if (selectedKeys.isEmpty()) {
                    clearSelectedKeys = false;
                    break;
                }
                i = selectedKeys.iterator();
            }
        }
        finally {
            if (clearSelectedKeys) {
                selectedKeys.clear();
            }
        }
    }

    private static void processSelectedKey(SelectionKey k, AbstractNioChannel ch) {
        AbstractNioChannel.NioUnsafe unsafe = ch.unsafe();
        if (!k.isValid()) {
            unsafe.close(unsafe.voidFuture());
            return;
        }
        int readyOps = -1;
        try {
            readyOps = k.readyOps();
            if ((readyOps & 0x11) != 0 || readyOps == 0) {
                unsafe.read();
                if (!ch.isOpen()) {
                    return;
                }
            }
            if ((readyOps & 4) != 0) {
                NioEventLoop.processWritable(k, ch);
            }
            if ((readyOps & 8) != 0) {
                int ops = k.interestOps();
                k.interestOps(ops &= 0xFFFFFFF7);
                unsafe.finishConnect();
            }
        }
        catch (CancelledKeyException e) {
            if (readyOps != -1 && (readyOps & 4) != 0) {
                NioEventLoop.unregisterWritableTasks(ch);
            }
            unsafe.close(unsafe.voidFuture());
        }
    }

    private static void processWritable(SelectionKey k, AbstractNioChannel ch) {
        if (ch.writableTasks.isEmpty()) {
            ch.unsafe().flushNow();
        } else {
            NioTask<SelectableChannel> task;
            while ((task = ch.writableTasks.poll()) != null) {
                NioEventLoop.processSelectedKey(ch.selectionKey(), task);
            }
            k.interestOps(k.interestOps() | 4);
        }
    }

    private static void unregisterWritableTasks(AbstractNioChannel ch) {
        NioTask<SelectableChannel> task;
        while ((task = ch.writableTasks.poll()) != null) {
            NioEventLoop.invokeChannelUnregistered(task, ch.selectionKey(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSelectedKey(SelectionKey k, NioTask<SelectableChannel> task) {
        int state = 0;
        try {
            task.channelReady(k.channel(), k);
            state = 1;
        }
        catch (Exception e) {
            k.cancel();
            NioEventLoop.invokeChannelUnregistered(task, k, e);
            state = 2;
        }
        finally {
            switch (state) {
                case 0: {
                    k.cancel();
                    NioEventLoop.invokeChannelUnregistered(task, k, null);
                    break;
                }
                case 1: {
                    if (k.isValid()) break;
                    NioEventLoop.invokeChannelUnregistered(task, k, null);
                }
            }
        }
    }

    private void closeAll() {
        this.cleanupKeys();
        Set<SelectionKey> keys = this.selector.keys();
        ArrayList<AbstractNioChannel> channels = new ArrayList<AbstractNioChannel>(keys.size());
        for (SelectionKey k : keys) {
            Object a = k.attachment();
            if (a instanceof AbstractNioChannel) {
                channels.add((AbstractNioChannel)a);
                continue;
            }
            k.cancel();
            NioTask task = (NioTask)a;
            NioEventLoop.invokeChannelUnregistered(task, k, null);
        }
        for (AbstractNioChannel ch : channels) {
            NioEventLoop.unregisterWritableTasks(ch);
            ch.unsafe().close(ch.unsafe().voidFuture());
        }
    }

    private static void invokeChannelUnregistered(NioTask<SelectableChannel> task, SelectionKey k, Throwable cause) {
        try {
            task.channelUnregistered(k.channel(), cause);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while running NioTask.channelUnregistered()", e);
        }
    }

    @Override
    protected void wakeup(boolean inEventLoop) {
        if (!inEventLoop && this.wakenUp.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectNow() throws IOException {
        try {
            this.selector.selectNow();
        }
        finally {
            if (this.wakenUp.get()) {
                this.selector.wakeup();
            }
        }
    }

    private int select() throws IOException {
        try {
            return this.selector.select(SELECT_TIMEOUT);
        }
        catch (CancelledKeyException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector - JDK bug?", e);
            }
            return -1;
        }
    }

    void cleanupKeys() {
        try {
            this.selector.selectNow();
        }
        catch (Throwable t) {
            logger.warn("Failed to update SelectionKeys.", t);
        }
    }

    static {
        block4: {
            logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
            EPOLL_BUG_WORKAROUND = SystemPropertyUtil.getBoolean("io.netty.epollBugWorkaround", false);
            SELECT_TIMEOUT = SystemPropertyUtil.getLong("io.netty.selectTimeout", 500L);
            SELECT_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(SELECT_TIMEOUT);
            String key = "sun.nio.ch.bugLevel";
            try {
                String buglevel = System.getProperty(key);
                if (buglevel == null) {
                    System.setProperty(key, "");
                }
            }
            catch (SecurityException e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Unable to get/set System Property '" + key + '\'', e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using select timeout of " + SELECT_TIMEOUT);
            logger.debug("Epoll-bug workaround enabled = " + EPOLL_BUG_WORKAROUND);
        }
    }
}

