/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class TaskScheduler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TaskScheduler.class);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
    private static final long START_TIME = System.nanoTime();
    private static final AtomicLong nextTaskId = new AtomicLong();
    private final BlockingQueue<ScheduledFutureTask<?>> taskQueue = new DelayQueue();
    private final Thread thread;
    private final Object stateLock = new Object();
    private final Semaphore threadLock = new Semaphore(0);
    private volatile int state;

    private static long nanoTime() {
        return System.nanoTime() - START_TIME;
    }

    private static long deadlineNanos(long delay) {
        return TaskScheduler.nanoTime() + delay;
    }

    public TaskScheduler(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        this.thread = threadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    do {
                        try {
                            ScheduledFutureTask task = (ScheduledFutureTask)TaskScheduler.this.taskQueue.take();
                            this.runTask(task);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!TaskScheduler.this.isShutdown() || TaskScheduler.this.taskQueue.peek() != null);
                }
                finally {
                    try {
                        try {
                            this.cleanupTasks();
                        }
                        finally {
                            Object object = TaskScheduler.this.stateLock;
                            synchronized (object) {
                                TaskScheduler.this.state = 3;
                            }
                        }
                        this.cleanupTasks();
                    }
                    finally {
                        TaskScheduler.this.threadLock.release();
                        assert (TaskScheduler.this.taskQueue.isEmpty());
                    }
                }
            }

            private void runTask(ScheduledFutureTask<?> task) {
                EventExecutor executor = ((ScheduledFutureTask)task).executor;
                if (executor == null) {
                    task.run();
                } else if (executor.isShutdown()) {
                    task.cancel(false);
                } else {
                    try {
                        ((ScheduledFutureTask)task).executor.execute(task);
                    }
                    catch (RejectedExecutionException e) {
                        task.cancel(false);
                    }
                }
            }

            private void cleanupTasks() {
                boolean ran;
                do {
                    ScheduledFutureTask task;
                    ran = false;
                    TaskScheduler.this.cancelScheduledTasks();
                    while ((task = (ScheduledFutureTask)TaskScheduler.this.taskQueue.poll()) != null) {
                        try {
                            this.runTask(task);
                            ran = true;
                        }
                        catch (Throwable t) {
                            logger.warn("A task raised an exception.", t);
                        }
                    }
                } while (ran || !TaskScheduler.this.taskQueue.isEmpty());
            }
        });
    }

    private boolean inSameThread() {
        return Thread.currentThread() == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        boolean inSameThread = this.inSameThread();
        boolean wakeup = false;
        if (inSameThread) {
            Object object = this.stateLock;
            synchronized (object) {
                assert (this.state == 1);
                this.state = 2;
                wakeup = true;
            }
        }
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    this.state = 3;
                    this.threadLock.release();
                    break;
                }
                case 1: {
                    this.state = 2;
                    wakeup = true;
                }
            }
        }
        if (wakeup && !inSameThread && this.isShutdown()) {
            this.thread.interrupt();
        }
    }

    public boolean isShutdown() {
        return this.state >= 2;
    }

    public boolean isTerminated() {
        return this.state == 3;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (this.inSameThread()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        if (this.threadLock.tryAcquire(timeout, unit)) {
            this.threadLock.release();
        }
        return this.isTerminated();
    }

    public ScheduledFuture<?> schedule(EventExecutor executor, Runnable command, long delay, TimeUnit unit) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<Object>(executor, command, null, TaskScheduler.deadlineNanos(unit.toNanos(delay))));
    }

    public <V> ScheduledFuture<V> schedule(EventExecutor executor, Callable<V> callable, long delay, TimeUnit unit) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (callable == null) {
            throw new NullPointerException("callable");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<V>(executor, callable, TaskScheduler.deadlineNanos(unit.toNanos(delay))));
    }

    public ScheduledFuture<?> scheduleAtFixedRate(EventExecutor executor, Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (period <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", period));
        }
        return this.schedule(new ScheduledFutureTask<Object>(executor, command, null, TaskScheduler.deadlineNanos(unit.toNanos(initialDelay)), unit.toNanos(period)));
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(EventExecutor executor, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<Object>(executor, command, null, TaskScheduler.deadlineNanos(unit.toNanos(initialDelay)), -unit.toNanos(delay)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> ScheduledFuture<V> schedule(ScheduledFutureTask<V> task) {
        if (this.isShutdown()) {
            TaskScheduler.reject();
        }
        this.taskQueue.add(task);
        if (this.isShutdown()) {
            task.cancel(false);
        }
        boolean started = false;
        if (!this.inSameThread()) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 0) {
                    this.state = 1;
                    this.thread.start();
                    started = true;
                }
            }
        }
        if (started) {
            this.schedule(new ScheduledFutureTask<Object>(null, new PurgeTask(), null, TaskScheduler.deadlineNanos(SCHEDULE_PURGE_INTERVAL), -SCHEDULE_PURGE_INTERVAL));
        }
        return task;
    }

    private static void reject() {
        throw new RejectedExecutionException("event executor shut down");
    }

    private void cancelScheduledTasks() {
        if (this.taskQueue.isEmpty()) {
            return;
        }
        for (ScheduledFutureTask task : this.taskQueue.toArray(new ScheduledFutureTask[this.taskQueue.size()])) {
            task.cancel(false);
        }
        this.taskQueue.clear();
    }

    private final class PurgeTask
    implements Runnable {
        private PurgeTask() {
        }

        @Override
        public void run() {
            Iterator i = TaskScheduler.this.taskQueue.iterator();
            while (i.hasNext()) {
                ScheduledFutureTask task = (ScheduledFutureTask)i.next();
                if (!task.isCancelled()) continue;
                i.remove();
            }
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private final EventExecutor executor;
        private final long id;
        private long deadlineNanos;
        private final long periodNanos;

        ScheduledFutureTask(EventExecutor executor, Runnable runnable, V result, long nanoTime) {
            super(runnable, result);
            this.id = nextTaskId.getAndIncrement();
            this.executor = executor;
            this.deadlineNanos = nanoTime;
            this.periodNanos = 0L;
        }

        ScheduledFutureTask(EventExecutor executor, Runnable runnable, V result, long nanoTime, long period) {
            super(runnable, result);
            this.id = nextTaskId.getAndIncrement();
            if (period == 0L) {
                throw new IllegalArgumentException("period: 0 (expected: != 0)");
            }
            this.executor = executor;
            this.deadlineNanos = nanoTime;
            this.periodNanos = period;
        }

        ScheduledFutureTask(EventExecutor executor, Callable<V> callable, long nanoTime) {
            super(callable);
            this.id = nextTaskId.getAndIncrement();
            this.executor = executor;
            this.deadlineNanos = nanoTime;
            this.periodNanos = 0L;
        }

        public long deadlineNanos() {
            return this.deadlineNanos;
        }

        public long delayNanos() {
            return Math.max(0L, this.deadlineNanos() - TaskScheduler.nanoTime());
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.delayNanos(), TimeUnit.NANOSECONDS);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int compareTo(Delayed o) {
            if (this == o) {
                return 0;
            }
            ScheduledFutureTask that = (ScheduledFutureTask)o;
            long d = this.deadlineNanos() - that.deadlineNanos();
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            if (this.id < that.id) {
                return -1;
            }
            if (this.id == that.id) {
                throw new Error();
            }
            return 1;
        }

        @Override
        public void run() {
            if (this.periodNanos == 0L) {
                super.run();
            } else {
                boolean reset = this.runAndReset();
                if (reset && !TaskScheduler.this.isShutdown()) {
                    long p = this.periodNanos;
                    this.deadlineNanos = p > 0L ? (this.deadlineNanos += p) : TaskScheduler.nanoTime() - p;
                    TaskScheduler.this.schedule(this);
                }
            }
        }
    }
}

