/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.oio.AbstractOioChannel;
import io.netty.channel.oio.OioEventLoopGroup;

class OioEventLoop
extends SingleThreadEventLoop {
    private final OioEventLoopGroup parent;
    private AbstractOioChannel ch;

    OioEventLoop(OioEventLoopGroup parent) {
        super(parent, parent.threadFactory, parent.scheduler);
        this.parent = parent;
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return super.register(channel, promise).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    OioEventLoop.this.ch = (AbstractOioChannel)future.channel();
                } else {
                    OioEventLoop.this.deregister();
                }
            }
        });
    }

    @Override
    protected void run() {
        while (true) {
            AbstractOioChannel ch;
            if ((ch = this.ch) == null || !ch.isActive()) {
                try {
                    Runnable task = this.takeTask();
                    task.run();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Runnable task;
                long startTime = System.nanoTime();
                while ((task = this.pollTask()) != null) {
                    task.run();
                    if (System.nanoTime() - startTime <= 1000000000L) continue;
                    break;
                }
                if (!ch.isRegistered()) {
                    this.runAllTasks();
                    this.deregister();
                }
            }
            if (!this.isShutdown()) continue;
            if (ch != null) {
                ch.unsafe().close(ch.unsafe().voidFuture());
            }
            if (this.confirmShutdown()) break;
        }
    }

    private void deregister() {
        this.ch = null;
        this.parent.activeChildren.remove(this);
        this.parent.idleChildren.add(this);
    }
}

