/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.entitymap;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

class EntityMap_1_16
extends EntityMap {
    static final EntityMap_1_16 INSTANCE = new EntityMap_1_16();

    EntityMap_1_16() {
        this.addRewrite(0, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(1, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(2, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(3, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(4, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(5, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(8, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(27, ProtocolConstants.Direction.TO_CLIENT, false);
        this.addRewrite(40, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(41, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(42, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(43, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(56, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(59, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(62, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(68, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(69, ProtocolConstants.Direction.TO_CLIENT, false);
        this.addRewrite(70, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(71, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(75, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(85, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(86, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(88, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(89, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(14, ProtocolConstants.Direction.TO_SERVER, true);
        this.addRewrite(28, ProtocolConstants.Direction.TO_SERVER, true);
    }

    @Override
    public void rewriteClientbound(ByteBuf packet, int oldId, int newId, int protocolVersion) {
        super.rewriteClientbound(packet, oldId, newId);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        int jumpIndex = packet.readerIndex();
        switch (packetId) {
            case 69: {
                EntityMap_1_16.rewriteInt(packet, oldId, newId, readerIndex + packetIdLength + 4);
                break;
            }
            case 85: {
                DefinedPacket.readVarInt(packet);
                EntityMap_1_16.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
                break;
            }
            case 75: {
                DefinedPacket.readVarInt(packet);
                jumpIndex = packet.readerIndex();
            }
            case 55: {
                int count = DefinedPacket.readVarInt(packet);
                int[] ids = new int[count];
                for (int i = 0; i < count; ++i) {
                    ids[i] = DefinedPacket.readVarInt(packet);
                }
                packet.readerIndex(jumpIndex);
                packet.writerIndex(jumpIndex);
                DefinedPacket.writeVarInt(count, packet);
                for (int id : ids) {
                    if (id == oldId) {
                        id = newId;
                    } else if (id == newId) {
                        id = oldId;
                    }
                    DefinedPacket.writeVarInt(id, packet);
                }
                break;
            }
            case 0: {
                DefinedPacket.readVarInt(packet);
                DefinedPacket.readUUID(packet);
                int type = DefinedPacket.readVarInt(packet);
                if (type != 2 && type != 102 && type != 72) break;
                if (type == 2 || type == 72) {
                    ++oldId;
                    ++newId;
                }
                packet.skipBytes(26);
                int position = packet.readerIndex();
                int readId = packet.readInt();
                if (readId == oldId) {
                    packet.setInt(position, newId);
                    break;
                }
                if (readId != newId) break;
                packet.setInt(position, oldId);
                break;
            }
            case 4: {
                DefinedPacket.readVarInt(packet);
                int idLength = packet.readerIndex() - readerIndex - packetIdLength;
                UUID uuid = DefinedPacket.readUUID(packet);
                UserConnection player = BungeeCord.getInstance().getPlayerByOfflineUUID(uuid);
                if (player == null) break;
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength + idLength);
                DefinedPacket.writeUUID(player.getRewriteId(), packet);
                packet.writerIndex(previous);
                break;
            }
            case 50: {
                short event = packet.readUnsignedByte();
                if (event == 1) {
                    DefinedPacket.readVarInt(packet);
                    EntityMap_1_16.rewriteInt(packet, oldId, newId, packet.readerIndex());
                    break;
                }
                if (event != 2) break;
                int position = packet.readerIndex();
                EntityMap_1_16.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
                packet.readerIndex(position);
                DefinedPacket.readVarInt(packet);
                EntityMap_1_16.rewriteInt(packet, oldId, newId, packet.readerIndex());
                break;
            }
            case 68: {
                DefinedPacket.readVarInt(packet);
                EntityMap_1_16.rewriteMetaVarInt(packet, oldId + 1, newId + 1, 7, protocolVersion);
                EntityMap_1_16.rewriteMetaVarInt(packet, oldId, newId, 8, protocolVersion);
                EntityMap_1_16.rewriteMetaVarInt(packet, oldId, newId, 16, protocolVersion);
                break;
            }
            case 80: {
                DefinedPacket.readVarInt(packet);
                DefinedPacket.readVarInt(packet);
                EntityMap_1_16.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
            }
        }
        packet.readerIndex(readerIndex);
    }

    @Override
    public void rewriteServerbound(ByteBuf packet, int oldId, int newId) {
        super.rewriteServerbound(packet, oldId, newId);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == 44) {
            UUID uuid = DefinedPacket.readUUID(packet);
            ProxiedPlayer player = BungeeCord.getInstance().getPlayer(uuid);
            if (player != null) {
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength);
                DefinedPacket.writeUUID(((UserConnection)player).getRewriteId(), packet);
                packet.writerIndex(previous);
            }
        }
        packet.readerIndex(readerIndex);
    }
}

