/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tab;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemRemove;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import net.md_5.bungee.tab.TabList;

public class ServerUnique
extends TabList {
    private final Collection<UUID> uuids = new HashSet<UUID>();

    public ServerUnique(ProxiedPlayer player) {
        super(player);
    }

    @Override
    public void onUpdate(PlayerListItem playerListItem) {
        PlayerListItem.Action action = playerListItem.getAction();
        if (action == PlayerListItem.Action.ADD_PLAYER) {
            for (PlayerListItem.Item item : playerListItem.getItems()) {
                this.uuids.add(item.getUuid());
            }
        } else if (action == PlayerListItem.Action.REMOVE_PLAYER) {
            for (PlayerListItem.Item item : playerListItem.getItems()) {
                this.uuids.remove(item.getUuid());
            }
        }
        this.player.unsafe().sendPacket(playerListItem);
    }

    @Override
    public void onUpdate(PlayerListItemRemove playerListItem) {
        for (UUID uuid : playerListItem.getUuids()) {
            this.uuids.remove(uuid);
        }
        this.player.unsafe().sendPacket(playerListItem);
    }

    @Override
    public void onUpdate(PlayerListItemUpdate playerListItem) {
        if (playerListItem.getActions().contains((Object)PlayerListItemUpdate.Action.ADD_PLAYER)) {
            for (PlayerListItem.Item item : playerListItem.getItems()) {
                this.uuids.add(item.getUuid());
            }
        }
        this.player.unsafe().sendPacket(playerListItem);
    }

    @Override
    public void onPingChange(int ping) {
    }

    @Override
    public void onServerChange() {
        if (this.player.getPendingConnection().getVersion() >= 761) {
            PlayerListItemRemove packet = new PlayerListItemRemove();
            packet.setUuids(this.uuids.toArray(new UUID[0]));
            this.player.unsafe().sendPacket(packet);
        } else {
            PlayerListItem packet = new PlayerListItem();
            packet.setAction(PlayerListItem.Action.REMOVE_PLAYER);
            PlayerListItem.Item[] items = new PlayerListItem.Item[this.uuids.size()];
            int i = 0;
            for (UUID uuid : this.uuids) {
                int n = i++;
                PlayerListItem.Item item = new PlayerListItem.Item();
                items[n] = item;
                PlayerListItem.Item item2 = item;
                item2.setUuid(uuid);
            }
            packet.setItems(items);
            this.player.unsafe().sendPacket(packet);
        }
        this.uuids.clear();
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onDisconnect() {
    }
}

