/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.type;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import lombok.Generated;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class DoubleTag
implements TypedTag {
    private double value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(16L);
        this.value = input.readDouble();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeDouble(this.value);
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public void setValue(double value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleTag)) {
            return false;
        }
        DoubleTag other = (DoubleTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DoubleTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    @Generated
    public String toString() {
        return "DoubleTag(value=" + this.getValue() + ")";
    }

    @Generated
    public DoubleTag() {
    }

    @Generated
    public DoubleTag(double value) {
        this.value = value;
    }
}

