/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.external.com.google.gdata.util.common.base;

import org.yaml.snakeyaml.external.com.google.gdata.util.common.base.Escaper;

public abstract class UnicodeEscaper
implements Escaper {
    private static final ThreadLocal<char[]> DEST_TL;

    protected abstract char[] escape(int var1);

    /*
     * WARNING - void declaration
     */
    protected int nextEscapeIndex(CharSequence csq, int start, int end) {
        void var2_2;
        int cp;
        for (int index = start; index < end && (cp = UnicodeEscaper.codePointAt(csq, index, end)) >= 0 && this.escape(cp) == null; index += Character.isSupplementaryCodePoint(cp) ? 2 : 1) {
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String escape(String string) {
        void var3_3;
        void var1_1;
        void var2_2;
        int end = string.length();
        int index = this.nextEscapeIndex(string, 0, end);
        if (index == var2_2) {
            return string;
        }
        return this.escapeSlow((String)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected final String escapeSlow(String s, int index) {
        int end = s.length();
        char[] dest = DEST_TL.get();
        int destIndex = 0;
        int unescapedChunkStart = 0;
        while (index < end) {
            int cp = UnicodeEscaper.codePointAt(s, index, end);
            if (cp < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] escaped = this.escape(cp);
            if (escaped != null) {
                int charsSkipped = index - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end - index) + 32;
                    dest = UnicodeEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s.getChars(unescapedChunkStart, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped.length > 0) {
                    System.arraycopy(escaped, 0, dest, destIndex, escaped.length);
                    destIndex += escaped.length;
                }
            }
            unescapedChunkStart = index + (Character.isSupplementaryCodePoint(cp) ? 2 : 1);
            index = this.nextEscapeIndex(s, unescapedChunkStart, end);
        }
        int charsSkipped = end - unescapedChunkStart;
        if (charsSkipped > 0) {
            void var3_3;
            void var1_1;
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = UnicodeEscaper.growBuffer(dest, destIndex, endIndex);
            }
            var1_1.getChars(unescapedChunkStart, (int)var3_3, dest, destIndex);
            destIndex = endIndex;
        }
        return new String(dest, 0, destIndex);
    }

    /*
     * WARNING - void declaration
     */
    private static int codePointAt(CharSequence seq, int index, int end) {
        if (index < end) {
            void var1_2;
            void var3_4;
            char c1;
            if ((c1 = seq.charAt(index++)) < '\ud800' || c1 > '\udfff') {
                return c1;
            }
            if (c1 <= '\udbff') {
                void var0_1;
                void var2_3;
                if (index == var2_3) {
                    return -c1;
                }
                char c2 = seq.charAt(index);
                if (Character.isLowSurrogate(c2)) {
                    return Character.toCodePoint(c1, c2);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c2 + "' with value " + (int)var0_1 + " at index " + index);
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c1 + "' with value " + (int)var3_4 + " at index " + (int)(var1_2 - true));
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    /*
     * WARNING - void declaration
     */
    private static final char[] growBuffer(char[] dest, int index, int size) {
        void var2_3;
        char[] copy = new char[size];
        if (index > 0) {
            void var1_1;
            char[] cArray;
            System.arraycopy(cArray, 0, copy, 0, (int)var1_1);
        }
        return var2_3;
    }

    static {
        UnicodeEscaper.class.desiredAssertionStatus();
        DEST_TL = new ThreadLocal<char[]>(){};
    }
}

