/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeConstructor
extends BaseConstructor {
    private static ConstructUndefined undefinedConstructor = new ConstructUndefined();
    private static final Map<String, Boolean> BOOL_VALUES = new HashMap<String, Boolean>();
    private static final Pattern TIMESTAMP_REGEXP;
    private static final Pattern YMD_REGEXP;

    public SafeConstructor() {
        this.yamlConstructors.put(Tag.NULL, new ConstructYamlNull(this));
        this.yamlConstructors.put(Tag.BOOL, new ConstructYamlBool(this));
        this.yamlConstructors.put(Tag.INT, new ConstructYamlInt(this));
        this.yamlConstructors.put(Tag.FLOAT, new ConstructYamlFloat(this));
        this.yamlConstructors.put(Tag.BINARY, new ConstructYamlBinary(this));
        this.yamlConstructors.put(Tag.TIMESTAMP, new ConstructYamlTimestamp());
        this.yamlConstructors.put(Tag.OMAP, new ConstructYamlOmap(this));
        this.yamlConstructors.put(Tag.PAIRS, new ConstructYamlPairs(this));
        this.yamlConstructors.put(Tag.SET, new ConstructYamlSet(this));
        this.yamlConstructors.put(Tag.STR, new ConstructYamlStr(this));
        this.yamlConstructors.put(Tag.SEQ, new ConstructYamlSeq(this));
        this.yamlConstructors.put(Tag.MAP, new ConstructYamlMap(this));
        this.yamlConstructors.put(null, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.scalar, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.sequence, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.mapping, undefinedConstructor);
    }

    /*
     * WARNING - void declaration
     */
    protected final void flattenMapping(MappingNode node) {
        if (node.isMerged()) {
            void var1_1;
            node.setValue(this.mergeNode((MappingNode)var1_1, true, new HashMap<Object, Integer>(), new ArrayList<NodeTuple>()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<NodeTuple> mergeNode(MappingNode node, boolean isPreffered, Map<Object, Integer> key2index, List<NodeTuple> values) {
        List<NodeTuple> nodeValue = node.getValue();
        Collections.reverse(nodeValue);
        Iterator<NodeTuple> iter = nodeValue.iterator();
        block4: while (iter.hasNext()) {
            void var6_6;
            MappingNode mnode;
            List<Node> nodeTuple = iter.next();
            Node keyNode = ((NodeTuple)((Object)nodeTuple)).getKeyNode();
            Node valueNode = ((NodeTuple)((Object)nodeTuple)).getValueNode();
            if (keyNode.getTag().equals(Tag.MERGE)) {
                iter.remove();
                switch (valueNode.getNodeId()) {
                    case mapping: {
                        MappingNode mn = (MappingNode)valueNode;
                        this.mergeNode(mn, false, key2index, values);
                        continue block4;
                    }
                    case sequence: {
                        nodeTuple = (SequenceNode)valueNode;
                        nodeTuple = ((SequenceNode)((Object)nodeTuple)).getValue();
                        for (Node subnode : nodeTuple) {
                            if (!(subnode instanceof MappingNode)) {
                                throw new ConstructorException("while constructing a mapping", node.getStartMark(), "expected a mapping for merging, but found " + (Object)((Object)subnode.getNodeId()), subnode.getStartMark());
                            }
                            mnode = (MappingNode)subnode;
                            this.mergeNode(mnode, false, key2index, values);
                        }
                        continue block4;
                    }
                    default: {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "expected a mapping or list of mappings for merging, but found " + (Object)((Object)valueNode.getNodeId()), valueNode.getStartMark());
                    }
                }
            }
            Object key = this.constructObject(mnode);
            if (!key2index.containsKey(key)) {
                values.add((NodeTuple)var6_6);
                key2index.put(key, values.size() - 1);
                continue;
            }
            if (!isPreffered) continue;
            values.set(key2index.get(key), (NodeTuple)var6_6);
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
        void var2_2;
        void var1_1;
        this.flattenMapping(node);
        super.constructMapping2ndStep((MappingNode)var1_1, (Map<Object, Object>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void constructSet2ndStep(MappingNode node, Set<Object> set) {
        void var2_2;
        void var1_1;
        this.flattenMapping(node);
        super.constructSet2ndStep((MappingNode)var1_1, (Set<Object>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Number createNumber(int sign, String number, int radix) {
        void var0_1;
        Number result;
        if (sign < 0) {
            number = "-" + number;
        }
        try {
            result = Integer.valueOf(number, radix);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                result = Long.valueOf(number, radix);
            }
            catch (NumberFormatException numberFormatException2) {
                void var2_3;
                void var1_2;
                result = new BigInteger((String)var1_2, (int)var2_3);
            }
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Number access$100(SafeConstructor x0, int x1, String x2, int x3) {
        void var3_3;
        void var2_2;
        return SafeConstructor.createNumber(x1, (String)var2_2, (int)var3_3);
    }

    static {
        BOOL_VALUES.put("yes", Boolean.TRUE);
        BOOL_VALUES.put("no", Boolean.FALSE);
        BOOL_VALUES.put("true", Boolean.TRUE);
        BOOL_VALUES.put("false", Boolean.FALSE);
        BOOL_VALUES.put("on", Boolean.TRUE);
        BOOL_VALUES.put("off", Boolean.FALSE);
        TIMESTAMP_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");
        YMD_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");
    }

    public static final class ConstructUndefined
    extends AbstractConstruct {
        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var1_1;
            throw new ConstructorException(null, null, "could not determine a constructor for the tag " + node.getTag(), var1_1.getStartMark());
        }
    }

    public final class ConstructYamlMap
    implements Construct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlMap(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var1_1;
            if (node.isTwoStepsConstruction()) {
                return new LinkedHashMap();
            }
            return this.this$0.constructMapping((MappingNode)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void construct2ndStep(Node node, Object object) {
            void var1_1;
            if (node.isTwoStepsConstruction()) {
                void var2_2;
                this.this$0.constructMapping2ndStep((MappingNode)node, (Map)var2_2);
                return;
            }
            throw new YAMLException("Unexpected recursive mapping structure. Node: " + var1_1);
        }
    }

    public final class ConstructYamlSeq
    implements Construct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlSeq(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var2_2;
            void var1_1;
            SequenceNode seqNode = (SequenceNode)node;
            if (var1_1.isTwoStepsConstruction()) {
                return SafeConstructor.createDefaultList(seqNode.getValue().size());
            }
            return this.this$0.constructSequence((SequenceNode)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void construct2ndStep(Node node, Object data) {
            void var1_1;
            if (node.isTwoStepsConstruction()) {
                void var2_2;
                this.this$0.constructSequenceStep2((SequenceNode)node, (List)var2_2);
                return;
            }
            throw new YAMLException("Unexpected recursive sequence structure. Node: " + var1_1);
        }
    }

    public final class ConstructYamlStr
    extends AbstractConstruct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlStr(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        public final Object construct(Node node) {
            ScalarNode scalarNode;
            scalarNode = scalarNode;
            return scalarNode.getValue();
        }
    }

    public final class ConstructYamlSet
    implements Construct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlSet(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var1_1;
            if (node.isTwoStepsConstruction()) {
                return new LinkedHashSet();
            }
            return this.this$0.constructSet((MappingNode)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void construct2ndStep(Node node, Object object) {
            void var1_1;
            if (node.isTwoStepsConstruction()) {
                void var2_2;
                this.this$0.constructSet2ndStep((MappingNode)node, (Set)var2_2);
                return;
            }
            throw new YAMLException("Unexpected recursive set structure. Node: " + var1_1);
        }
    }

    public final class ConstructYamlPairs
    extends AbstractConstruct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlPairs(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var3_3;
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            ArrayList<Object[]> pairs = new ArrayList<Object[]>(snode.getValue().size());
            for (Node subnode : snode.getValue()) {
                if (!(subnode instanceof MappingNode)) {
                    throw new ConstructorException("while constructingpairs", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)subnode.getNodeId()), subnode.getStartMark());
                }
                MappingNode mnode = (MappingNode)subnode;
                if (mnode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing pairs", node.getStartMark(), "expected a single mapping item, but found " + mnode.getValue().size() + " items", mnode.getStartMark());
                }
                Node keyNode = mnode.getValue().get(0).getKeyNode();
                Node valueNode = mnode.getValue().get(0).getValueNode();
                Object key = this.this$0.constructObject(keyNode);
                Object value = this.this$0.constructObject(valueNode);
                pairs.add(new Object[]{key, value});
            }
            return var3_3;
        }
    }

    public final class ConstructYamlOmap
    extends AbstractConstruct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlOmap(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var2_2;
            LinkedHashMap<Object, Object> omap = new LinkedHashMap<Object, Object>();
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            SequenceNode sequenceNode = (SequenceNode)node;
            for (Node subnode : sequenceNode.getValue()) {
                if (!(subnode instanceof MappingNode)) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)subnode.getNodeId()), subnode.getStartMark());
                }
                MappingNode mnode = (MappingNode)subnode;
                if (mnode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a single mapping item, but found " + mnode.getValue().size() + " items", mnode.getStartMark());
                }
                Node keyNode = mnode.getValue().get(0).getKeyNode();
                Node valueNode = mnode.getValue().get(0).getValueNode();
                Object key = this.this$0.constructObject(keyNode);
                Object value = this.this$0.constructObject(valueNode);
                omap.put(key, value);
            }
            return var2_2;
        }
    }

    public static final class ConstructYamlTimestamp
    extends AbstractConstruct {
        private Calendar calendar;

        public final Calendar getCalendar() {
            return this.calendar;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var3_4;
            void var1_1;
            void var2_2;
            TimeZone timeZone;
            String year_s;
            node = (ScalarNode)node;
            String nodeValue = ((ScalarNode)node).getValue();
            Matcher match = YMD_REGEXP.matcher(nodeValue);
            if (match.matches()) {
                year_s = match.group(1);
                String month_s = match.group(2);
                String day_s = match.group(3);
                this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                this.calendar.clear();
                this.calendar.set(1, Integer.parseInt(year_s));
                this.calendar.set(2, Integer.parseInt(month_s) - 1);
                this.calendar.set(5, Integer.parseInt(day_s));
                return this.calendar.getTime();
            }
            match = TIMESTAMP_REGEXP.matcher(year_s);
            if (!match.matches()) {
                throw new YAMLException("Unexpected timestamp: " + year_s);
            }
            year_s = match.group(1);
            String month_s = match.group(2);
            String day_s = match.group(3);
            String hour_s = match.group(4);
            String min_s = match.group(5);
            String seconds = match.group(6);
            String millis = match.group(7);
            if (millis != null) {
                seconds = seconds + "." + millis;
            }
            double fractions = Double.parseDouble(seconds);
            int sec_s = (int)Math.round(Math.floor(fractions));
            int usec = (int)Math.round((fractions - (double)sec_s) * 1000.0);
            String timezoneh_s = match.group(8);
            String timezonem_s = match.group(9);
            if (timezoneh_s != null) {
                String time = timezonem_s != null ? ":" + timezonem_s : "00";
                timeZone = TimeZone.getTimeZone("GMT" + timezoneh_s + time);
            } else {
                timeZone = TimeZone.getTimeZone("UTC");
            }
            this.calendar = Calendar.getInstance((TimeZone)var2_2);
            this.calendar.set(1, Integer.parseInt((String)var1_1));
            this.calendar.set(2, Integer.parseInt((String)var3_4) - 1);
            this.calendar.set(5, Integer.parseInt(day_s));
            this.calendar.set(11, Integer.parseInt(hour_s));
            this.calendar.set(12, Integer.parseInt(min_s));
            this.calendar.set(13, sec_s);
            this.calendar.set(14, usec);
            return this.calendar.getTime();
        }
    }

    public final class ConstructYamlBinary
    extends AbstractConstruct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlBinary(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        public final Object construct(Node node) {
            Object object;
            object = (ScalarNode)object;
            byte[] byArray = Base64Coder.decode(((ScalarNode)object).getValue().toString().toCharArray());
            object = byArray;
            return byArray;
        }
    }

    public final class ConstructYamlFloat
    extends AbstractConstruct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlFloat(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var2_2;
            void var1_1;
            String[] digits;
            node = (ScalarNode)node;
            String value = ((ScalarNode)node).getValue().toString().replaceAll("_", "");
            int sign = 1;
            char first = value.charAt(0);
            if (first == '-') {
                sign = -1;
                value = value.substring(1);
            } else if (first == '+') {
                value = value.substring(1);
            }
            String valLower = value.toLowerCase();
            if (".inf".equals(valLower)) {
                return new Double(sign == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            if (".nan".equals(valLower)) {
                return new Double(Double.NaN);
            }
            if (value.indexOf(58) != -1) {
                digits = value.split(":");
                int bes = 1;
                double val = 0.0;
                int j = digits.length;
                for (int i = 0; i < j; ++i) {
                    val += Double.parseDouble(digits[j - i - 1]) * (double)bes;
                    bes *= 60;
                }
                return new Double((double)sign * val);
            }
            Double d = Double.valueOf((String)digits);
            return new Double(var1_1.doubleValue() * (double)var2_2);
        }
    }

    public final class ConstructYamlInt
    extends AbstractConstruct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlInt(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var3_3;
            void var2_2;
            void var1_1;
            int base;
            node = (ScalarNode)node;
            String value = ((ScalarNode)node).getValue().toString().replaceAll("_", "");
            int sign = 1;
            char first = value.charAt(0);
            if (first == '-') {
                sign = -1;
                value = value.substring(1);
            } else if (first == '+') {
                value = value.substring(1);
            }
            if ("0".equals(value)) {
                return 0;
            }
            if (value.startsWith("0b")) {
                value = value.substring(2);
                base = 2;
            } else if (value.startsWith("0x")) {
                value = value.substring(2);
                base = 16;
            } else if (value.startsWith("0")) {
                value = value.substring(1);
                base = 8;
            } else {
                if (value.indexOf(58) != -1) {
                    String[] digits = value.split(":");
                    int bes = 1;
                    int val = 0;
                    int j = digits.length;
                    for (int i = 0; i < j; ++i) {
                        val = (int)((long)val + Long.parseLong(digits[j - i - 1]) * (long)bes);
                        bes *= 60;
                    }
                    return SafeConstructor.access$100(this.this$0, sign, String.valueOf(val), 10);
                }
                return SafeConstructor.access$100(this.this$0, sign, (String)var1_1, 10);
            }
            return SafeConstructor.access$100(this.this$0, (int)var2_2, (String)var1_1, (int)var3_3);
        }
    }

    public final class ConstructYamlBool
    extends AbstractConstruct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlBool(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var1_1;
            node = (ScalarNode)node;
            String val = ((ScalarNode)node).getValue();
            return BOOL_VALUES.get(var1_1.toLowerCase());
        }
    }

    public final class ConstructYamlNull
    extends AbstractConstruct {
        private /* synthetic */ SafeConstructor this$0;

        public ConstructYamlNull(SafeConstructor safeConstructor) {
            this.this$0 = safeConstructor;
        }

        public final Object construct(Node node) {
            ScalarNode scalarNode;
            scalarNode = scalarNode;
            scalarNode.getValue();
            return null;
        }
    }
}

