/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Yaml {
    private Resolver resolver;
    private String name;
    private BaseConstructor constructor;
    private Representer representer;
    private DumperOptions dumperOptions;

    public Yaml() {
        this(new Constructor(), new Representer(), new DumperOptions(), new Resolver());
    }

    /*
     * WARNING - void declaration
     */
    public Yaml(DumperOptions dumperOptions) {
        this(new Constructor(), new Representer(), (DumperOptions)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Yaml(BaseConstructor constructor, Representer representer, DumperOptions dumperOptions) {
        this((BaseConstructor)var1_1, (Representer)var2_2, (DumperOptions)var3_3, new Resolver());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Yaml(BaseConstructor constructor, Representer representer, DumperOptions dumperOptions, Resolver resolver) {
        void var3_3;
        void var2_2;
        DumperOptions dumperOptions2;
        if (!constructor.isExplicitPropertyUtils()) {
            constructor.setPropertyUtils(representer.getPropertyUtils());
        } else if (!representer.isExplicitPropertyUtils()) {
            representer.setPropertyUtils(constructor.getPropertyUtils());
        }
        this.constructor = dumperOptions2;
        representer.setDefaultFlowStyle(dumperOptions.getDefaultFlowStyle());
        representer.setDefaultScalarStyle(dumperOptions.getDefaultScalarStyle());
        dumperOptions2 = dumperOptions;
        representer.getPropertyUtils().setAllowReadOnlyProperties(false);
        dumperOptions2 = dumperOptions;
        representer.setTimeZone(null);
        this.representer = var2_2;
        this.dumperOptions = var3_3;
        this.resolver = resolver;
        this.name = "Yaml:" + System.identityHashCode(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void dumpAll(Iterator<? extends Object> data, Writer output) {
        void var2_2;
        Object object;
        void v0 = object;
        object = this.dumperOptions;
        Node node = null;
        Serializer serializer = var2_2;
        var2_2 = v0;
        object = this;
        serializer = new Serializer(new Emitter((Writer)((Object)serializer), ((Yaml)object).dumperOptions), ((Yaml)object).resolver, ((Yaml)object).dumperOptions, (Tag)((Object)node));
        try {
            serializer.open();
            while (var2_2.hasNext()) {
                node = ((Yaml)object).representer.represent(var2_2.next());
                serializer.serialize(node);
            }
            serializer.close();
            return;
        }
        catch (IOException iOException) {
            throw new YAMLException(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Object load(InputStream io) {
        void var1_1;
        return this.loadFromReader(new StreamReader(new UnicodeReader((InputStream)var1_1)), Object.class);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T loadAs(InputStream input, Class<T> type) {
        void var2_2;
        void var1_1;
        return (T)this.loadFromReader(new StreamReader(new UnicodeReader((InputStream)var1_1)), (Class<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Object loadFromReader(StreamReader sreader, Class<?> type) {
        void var2_2;
        void var1_1;
        Composer composer = new Composer(new ParserImpl(sreader), this.resolver);
        this.constructor.setComposer((Composer)var1_1);
        return this.constructor.getSingleData((Class<?>)var2_2);
    }

    public final String toString() {
        return this.name;
    }
}

