/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.scanner;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Constant;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerException;
import org.yaml.snakeyaml.scanner.SimpleKey;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.yaml.snakeyaml.tokens.DirectiveToken;
import org.yaml.snakeyaml.tokens.DocumentEndToken;
import org.yaml.snakeyaml.tokens.DocumentStartToken;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.TagTuple;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;
import org.yaml.snakeyaml.util.ArrayStack;
import org.yaml.snakeyaml.util.UriEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScannerImpl
implements Scanner {
    private static final Pattern NOT_HEXA = Pattern.compile("[^0-9A-Fa-f]");
    private static Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    private static Map<Character, Integer> ESCAPE_CODES = new HashMap<Character, Integer>();
    private final StreamReader reader;
    private boolean done = false;
    private int flowLevel = 0;
    private List<Token> tokens;
    private int tokensTaken = 0;
    private int indent = -1;
    private ArrayStack<Integer> indents;
    private boolean allowSimpleKey = true;
    private Map<Integer, SimpleKey> possibleSimpleKeys;

    public ScannerImpl(StreamReader reader) {
        ScannerImpl scannerImpl;
        this.reader = scannerImpl;
        this.tokens = new ArrayList<Token>(100);
        this.indents = new ArrayStack(10);
        this.possibleSimpleKeys = new LinkedHashMap<Integer, SimpleKey>();
        scannerImpl = this;
        Object object = scannerImpl.reader.getMark();
        object = new StreamStartToken((Mark)object, (Mark)object);
        scannerImpl.tokens.add((Token)object);
    }

    @Override
    public final boolean checkToken(Token.ID ... choices) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            if (choices.length == 0) {
                return true;
            }
            Token.ID first = this.tokens.get(0).getTokenId();
            for (int i = 0; i < choices.length; ++i) {
                if (first != choices[i]) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final Token peekToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.get(0);
    }

    @Override
    public final Token getToken() {
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            return this.tokens.remove(0);
        }
        return null;
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        ScannerImpl scannerImpl = this;
        return (!scannerImpl.possibleSimpleKeys.isEmpty() ? scannerImpl.possibleSimpleKeys.values().iterator().next().getTokenNumber() : -1) == this.tokensTaken;
    }

    private void fetchMoreTokens() {
        char c;
        ScannerImpl scannerImpl = this;
        if (scannerImpl.reader.getIndex() == 0 && scannerImpl.reader.peek() == '\ufeff') {
            scannerImpl.reader.forward();
        }
        char c2 = '\u0000';
        while (c2 == '\u0000') {
            c = '\u0000';
            while (scannerImpl.reader.peek(c) == ' ') {
                ++c;
            }
            if (c > '\u0000') {
                scannerImpl.reader.forward(c);
            }
            if (scannerImpl.reader.peek() == '#') {
                c = '\u0000';
                while (Constant.NULL_OR_LINEBR.hasNo(scannerImpl.reader.peek(c))) {
                    ++c;
                }
                if (c > '\u0000') {
                    scannerImpl.reader.forward(c);
                }
            }
            if (scannerImpl.scanLineBreak().length() != 0) {
                if (scannerImpl.flowLevel != 0) continue;
                scannerImpl.allowSimpleKey = true;
                continue;
            }
            c2 = '\u0001';
        }
        this.stalePossibleSimpleKeys();
        this.unwindIndent(this.reader.getColumn());
        char ch2 = this.reader.peek();
        switch (ch2) {
            case '\u0000': {
                scannerImpl = this;
                scannerImpl.unwindIndent(-1);
                scannerImpl.removePossibleSimpleKey();
                scannerImpl.allowSimpleKey = false;
                scannerImpl.possibleSimpleKeys.clear();
                Mark mark = scannerImpl.reader.getMark();
                StreamEndToken ch2 = new StreamEndToken(mark, mark);
                scannerImpl.tokens.add(ch2);
                scannerImpl.done = true;
                return;
            }
            case '%': {
                scannerImpl = this;
                if (!(scannerImpl.reader.getColumn() == 0)) break;
                scannerImpl = this;
                scannerImpl.unwindIndent(-1);
                scannerImpl.removePossibleSimpleKey();
                scannerImpl.allowSimpleKey = false;
                ScannerImpl ch2 = scannerImpl;
                Object object = ch2.reader.getMark();
                ch2.reader.forward();
                Object object2 = object;
                Object object3 = ch2;
                int n = 0;
                int n2 = ((ScannerImpl)object3).reader.peek(0);
                while (Constant.ALPHA.has((char)n2)) {
                    n2 = ((ScannerImpl)object3).reader.peek(++n);
                }
                if (n == 0) {
                    throw new ScannerException("while scanning a directive", (Mark)object2, "expected alphabetic or numeric character, but found " + (char)n2 + "(" + n2 + ")", ((ScannerImpl)object3).reader.getMark());
                }
                List<String> list = ((ScannerImpl)object3).reader.prefixForward(n);
                n2 = ((ScannerImpl)object3).reader.peek();
                if (Constant.NULL_BL_LINEBR.hasNo((char)n2)) {
                    throw new ScannerException("while scanning a directive", (Mark)object2, "expected alphabetic or numeric character, but found " + (char)n2 + "(" + n2 + ")", ((ScannerImpl)object3).reader.getMark());
                }
                object2 = list;
                list = null;
                if ("YAML".equals(object2)) {
                    list = ch2.scanYamlDirectiveValue((Mark)object);
                    object3 = ch2.reader.getMark();
                } else if ("TAG".equals(object2)) {
                    list = ch2.scanTagDirectiveValue((Mark)object);
                    object3 = ch2.reader.getMark();
                } else {
                    object3 = ch2.reader.getMark();
                    n2 = 0;
                    while (Constant.NULL_OR_LINEBR.hasNo(ch2.reader.peek(n2))) {
                        ++n2;
                    }
                    if (n2 > 0) {
                        ch2.reader.forward(n2);
                    }
                }
                ch2.scanDirectiveIgnoredLine((Mark)object);
                object = new DirectiveToken<String>((String)object2, list, (Mark)object, (Mark)object3);
                scannerImpl.tokens.add((Token)object);
                return;
            }
            case '-': {
                scannerImpl = this;
                if (scannerImpl.reader.getColumn() == 0 && "---".equals(scannerImpl.reader.prefix(3)) && Constant.NULL_BL_T_LINEBR.has(scannerImpl.reader.peek(3))) {
                    scannerImpl = this;
                    scannerImpl.fetchDocumentIndicator(true);
                    return;
                }
                scannerImpl = this;
                if (!Constant.NULL_BL_T_LINEBR.has(scannerImpl.reader.peek(1))) break;
                scannerImpl = this;
                if (scannerImpl.flowLevel == 0) {
                    if (!scannerImpl.allowSimpleKey) {
                        throw new ScannerException(null, null, "sequence entries are not allowed here", scannerImpl.reader.getMark());
                    }
                    if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                        Mark mark = scannerImpl.reader.getMark();
                        scannerImpl.tokens.add(new BlockSequenceStartToken(mark, mark));
                    }
                }
                scannerImpl.allowSimpleKey = true;
                scannerImpl.removePossibleSimpleKey();
                Object object = scannerImpl.reader.getMark();
                scannerImpl.reader.forward();
                Mark ch2 = scannerImpl.reader.getMark();
                object = new BlockEntryToken((Mark)object, ch2);
                scannerImpl.tokens.add((Token)object);
                return;
            }
            case '.': {
                scannerImpl = this;
                if (!(scannerImpl.reader.getColumn() == 0 && "...".equals(scannerImpl.reader.prefix(3)) && Constant.NULL_BL_T_LINEBR.has(scannerImpl.reader.peek(3)))) break;
                scannerImpl = this;
                scannerImpl.fetchDocumentIndicator(false);
                return;
            }
            case '[': {
                scannerImpl = this;
                scannerImpl.fetchFlowCollectionStart(false);
                return;
            }
            case '{': {
                scannerImpl = this;
                scannerImpl.fetchFlowCollectionStart(true);
                return;
            }
            case ']': {
                scannerImpl = this;
                scannerImpl.fetchFlowCollectionEnd(false);
                return;
            }
            case '}': {
                scannerImpl = this;
                scannerImpl.fetchFlowCollectionEnd(true);
                return;
            }
            case ',': {
                scannerImpl = this;
                this.allowSimpleKey = true;
                scannerImpl.removePossibleSimpleKey();
                Object object = scannerImpl.reader.getMark();
                scannerImpl.reader.forward();
                Mark ch2 = scannerImpl.reader.getMark();
                object = new FlowEntryToken((Mark)object, ch2);
                scannerImpl.tokens.add((Token)object);
                return;
            }
            case '?': {
                scannerImpl = this;
                if (!(scannerImpl.flowLevel != 0 ? true : Constant.NULL_BL_T_LINEBR.has(scannerImpl.reader.peek(1)))) break;
                scannerImpl = this;
                if (scannerImpl.flowLevel == 0) {
                    if (!scannerImpl.allowSimpleKey) {
                        throw new ScannerException(null, null, "mapping keys are not allowed here", scannerImpl.reader.getMark());
                    }
                    if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                        Mark mark = scannerImpl.reader.getMark();
                        scannerImpl.tokens.add(new BlockMappingStartToken(mark, mark));
                    }
                }
                scannerImpl.allowSimpleKey = scannerImpl.flowLevel == 0;
                scannerImpl.removePossibleSimpleKey();
                Object object = scannerImpl.reader.getMark();
                scannerImpl.reader.forward();
                Mark ch2 = scannerImpl.reader.getMark();
                object = new KeyToken((Mark)object, ch2);
                scannerImpl.tokens.add((Token)object);
                return;
            }
            case ':': {
                scannerImpl = this;
                if (!(scannerImpl.flowLevel != 0 ? true : Constant.NULL_BL_T_LINEBR.has(scannerImpl.reader.peek(1)))) break;
                scannerImpl = this;
                Object object = scannerImpl.possibleSimpleKeys.remove(scannerImpl.flowLevel);
                if (object != null) {
                    scannerImpl.tokens.add(((SimpleKey)object).getTokenNumber() - scannerImpl.tokensTaken, new KeyToken(((SimpleKey)object).getMark(), ((SimpleKey)object).getMark()));
                    if (scannerImpl.flowLevel == 0 && scannerImpl.addIndent(((SimpleKey)object).getColumn())) {
                        scannerImpl.tokens.add(((SimpleKey)object).getTokenNumber() - scannerImpl.tokensTaken, new BlockMappingStartToken(((SimpleKey)object).getMark(), ((SimpleKey)object).getMark()));
                    }
                    scannerImpl.allowSimpleKey = false;
                } else {
                    if (scannerImpl.flowLevel == 0 && !scannerImpl.allowSimpleKey) {
                        throw new ScannerException(null, null, "mapping values are not allowed here", scannerImpl.reader.getMark());
                    }
                    if (scannerImpl.flowLevel == 0 && scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                        Mark ch2 = scannerImpl.reader.getMark();
                        scannerImpl.tokens.add(new BlockMappingStartToken(ch2, ch2));
                    }
                    scannerImpl.allowSimpleKey = scannerImpl.flowLevel == 0;
                    scannerImpl.removePossibleSimpleKey();
                }
                Mark ch2 = scannerImpl.reader.getMark();
                scannerImpl.reader.forward();
                object = scannerImpl.reader.getMark();
                ValueToken valueToken = new ValueToken(ch2, (Mark)object);
                scannerImpl.tokens.add(valueToken);
                return;
            }
            case '*': {
                scannerImpl = this;
                scannerImpl.savePossibleSimpleKey();
                scannerImpl.allowSimpleKey = false;
                Token token = scannerImpl.scanAnchor(false);
                scannerImpl.tokens.add(token);
                return;
            }
            case '&': {
                scannerImpl = this;
                scannerImpl.savePossibleSimpleKey();
                scannerImpl.allowSimpleKey = false;
                Token token = scannerImpl.scanAnchor(true);
                scannerImpl.tokens.add(token);
                return;
            }
            case '!': {
                scannerImpl = this;
                scannerImpl.savePossibleSimpleKey();
                scannerImpl.allowSimpleKey = false;
                Token token = scannerImpl.scanTag();
                scannerImpl.tokens.add(token);
                return;
            }
            case '|': {
                if (this.flowLevel != 0) break;
                scannerImpl = this;
                scannerImpl.fetchBlockScalar('|');
                return;
            }
            case '>': {
                if (this.flowLevel != 0) break;
                scannerImpl = this;
                scannerImpl.fetchBlockScalar('>');
                return;
            }
            case '\'': {
                scannerImpl = this;
                scannerImpl.fetchFlowScalar('\'');
                return;
            }
            case '\"': {
                scannerImpl = this;
                scannerImpl.fetchFlowScalar('\"');
                return;
            }
        }
        scannerImpl = this;
        c2 = scannerImpl.reader.peek();
        if (Constant.NULL_BL_T_LINEBR.hasNo(c2, "-?:,[]{}#&*!|>'\"%@`") || Constant.NULL_BL_T_LINEBR.hasNo(scannerImpl.reader.peek(1)) && (c2 == '-' || scannerImpl.flowLevel == 0 && "?:".indexOf(c2) != -1)) {
            scannerImpl = this;
            scannerImpl.savePossibleSimpleKey();
            scannerImpl.allowSimpleKey = false;
            Token token = scannerImpl.scanPlain();
            scannerImpl.tokens.add(token);
            return;
        }
        String chRepresentation = String.valueOf(ch2);
        for (Character s : ESCAPE_REPLACEMENTS.keySet()) {
            String string = ESCAPE_REPLACEMENTS.get(s);
            if (!string.equals(chRepresentation)) continue;
            chRepresentation = "\\" + s;
            break;
        }
        throw new ScannerException("while scanning for the next token", null, "found character " + c + "'" + (String)((Object)scannerImpl) + "' that cannot start any token", this.reader.getMark());
    }

    /*
     * WARNING - void declaration
     */
    private void stalePossibleSimpleKeys() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            Iterator<SimpleKey> iterator = this.possibleSimpleKeys.values().iterator();
            while (iterator.hasNext()) {
                SimpleKey key = iterator.next();
                if (key.getLine() == this.reader.getLine() && this.reader.getIndex() - key.getIndex() <= 1024) continue;
                if (key.isRequired()) {
                    void var2_2;
                    throw new ScannerException("while scanning a simple key", var2_2.getMark(), "could not found expected ':'", this.reader.getMark());
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void savePossibleSimpleKey() {
        boolean required;
        boolean bl = required = this.flowLevel == 0 && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && required) {
            throw new YAMLException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            void var1_2;
            void var2_3;
            this.removePossibleSimpleKey();
            int tokenNumber = this.tokensTaken + this.tokens.size();
            SimpleKey key = new SimpleKey((int)var2_3, required, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), this.reader.getMark());
            this.possibleSimpleKeys.put(this.flowLevel, (SimpleKey)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removePossibleSimpleKey() {
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null && key.isRequired()) {
            void var1_1;
            throw new ScannerException("while scanning a simple key", var1_1.getMark(), "could not found expected ':'", this.reader.getMark());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void unwindIndent(int col) {
        if (this.flowLevel != 0) {
            return;
        }
        while (this.indent > col) {
            void var2_2;
            Mark mark = this.reader.getMark();
            this.indent = this.indents.pop();
            this.tokens.add(new BlockEndToken(mark, (Mark)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean addIndent(int column) {
        if (this.indent < column) {
            void var1_1;
            this.indents.push(this.indent);
            this.indent = var1_1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void fetchDocumentIndicator(boolean isDocumentStart) {
        void var1_2;
        void var3_4;
        void var2_3;
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Mark startMark = this.reader.getMark();
        this.reader.forward(3);
        Mark endMark = this.reader.getMark();
        Token token = isDocumentStart ? new DocumentStartToken(startMark, endMark) : new DocumentEndToken((Mark)var2_3, (Mark)var3_4);
        this.tokens.add((Token)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void fetchFlowCollectionStart(boolean isMappingStart) {
        void var1_2;
        void var3_4;
        void var2_3;
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        Mark startMark = this.reader.getMark();
        this.reader.forward(1);
        Mark endMark = this.reader.getMark();
        Token token = isMappingStart ? new FlowMappingStartToken(startMark, endMark) : new FlowSequenceStartToken((Mark)var2_3, (Mark)var3_4);
        this.tokens.add((Token)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void fetchFlowCollectionEnd(boolean isMappingEnd) {
        void var1_2;
        void var3_4;
        void var2_3;
        this.removePossibleSimpleKey();
        --this.flowLevel;
        this.allowSimpleKey = false;
        Mark startMark = this.reader.getMark();
        this.reader.forward();
        Mark endMark = this.reader.getMark();
        Token token = isMappingEnd ? new FlowMappingEndToken(startMark, endMark) : new FlowSequenceEndToken((Mark)var2_3, (Mark)var3_4);
        this.tokens.add((Token)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void fetchBlockScalar(char style2) {
        void var1_2;
        Object object;
        String string;
        Object object2;
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        char c = style2;
        ScannerImpl style2 = this;
        boolean bl = c == '>';
        StringBuilder stringBuilder = new StringBuilder();
        Mark mark = style2.reader.getMark();
        style2.reader.forward();
        Mark mark2 = mark;
        Object object3 = style2;
        Boolean bl2 = null;
        int n = -1;
        char c2 = ((ScannerImpl)object3).reader.peek();
        if (c2 == '-' || c2 == '+') {
            bl2 = c2 == '+' ? Boolean.TRUE : Boolean.FALSE;
            ((ScannerImpl)object3).reader.forward();
            c2 = ((ScannerImpl)object3).reader.peek();
            if (Character.isDigit(c2)) {
                n = Integer.parseInt(String.valueOf(c2));
                if (n == 0) {
                    throw new ScannerException("while scanning a block scalar", mark2, "expected indentation indicator in the range 1-9, but found 0", ((ScannerImpl)object3).reader.getMark());
                }
                ((ScannerImpl)object3).reader.forward();
            }
        } else if (Character.isDigit(c2)) {
            n = Integer.parseInt(String.valueOf(c2));
            if (n == 0) {
                throw new ScannerException("while scanning a block scalar", mark2, "expected indentation indicator in the range 1-9, but found 0", ((ScannerImpl)object3).reader.getMark());
            }
            ((ScannerImpl)object3).reader.forward();
            c2 = ((ScannerImpl)object3).reader.peek();
            if (c2 == '-' || c2 == '+') {
                bl2 = c2 == '+' ? Boolean.TRUE : Boolean.FALSE;
                ((ScannerImpl)object3).reader.forward();
            }
        }
        if (Constant.NULL_BL_LINEBR.hasNo(c2 = ((ScannerImpl)object3).reader.peek())) {
            throw new ScannerException("while scanning a block scalar", mark2, "expected chomping or indentation indicators, but found " + c2, ((ScannerImpl)object3).reader.getMark());
        }
        object3 = new Chomping(bl2, n);
        int n2 = ((Chomping)object3).getIncrement();
        style2.scanBlockScalarIgnoredLine(mark);
        int n3 = style2.indent + 1;
        if (n3 <= 0) {
            n3 = 1;
        }
        n = 0;
        if (n2 == -1) {
            object2 = style2.scanBlockScalarIndentation();
            string = (String)object2[0];
            n = (Integer)object2[1];
            object = (Object[])object2[2];
            n3 = Math.max(n3, n);
        } else {
            n3 = n3 + n2 - 1;
            object2 = style2.scanBlockScalarBreaks(n3);
            string = (String)object2[0];
            object = (Mark)object2[1];
        }
        object2 = "";
        while (style2.reader.getColumn() == n3 && style2.reader.peek() != '\u0000') {
            stringBuilder.append(string);
            n = " \t".indexOf(style2.reader.peek()) == -1 ? 1 : 0;
            int n4 = 0;
            while (Constant.NULL_OR_LINEBR.hasNo(style2.reader.peek(n4))) {
                ++n4;
            }
            stringBuilder.append(style2.reader.prefixForward(n4));
            object2 = style2.scanLineBreak();
            object = style2.scanBlockScalarBreaks(n3);
            string = (String)object[0];
            object = (Mark)object[1];
            if (style2.reader.getColumn() != n3 || style2.reader.peek() == '\u0000') break;
            if (bl && "\n".equals(object2) && n != 0 && " \t".indexOf(style2.reader.peek()) == -1) {
                if (string.length() != 0) continue;
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append((String)object2);
        }
        if (((Chomping)object3).chompTailIsNotFalse()) {
            stringBuilder.append((String)object2);
        }
        if (((Chomping)object3).chompTailIsTrue()) {
            stringBuilder.append(string);
        }
        ScalarToken tok = new ScalarToken(stringBuilder.toString(), false, mark, (Mark)object, c);
        this.tokens.add((Token)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private void fetchFlowScalar(char style2) {
        void var1_2;
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        char c = style2;
        Object style2 = this;
        boolean bl = c == '\"';
        StringBuilder stringBuilder = new StringBuilder();
        Mark mark = ((ScannerImpl)style2).reader.getMark();
        char c2 = ((ScannerImpl)style2).reader.peek();
        ((ScannerImpl)style2).reader.forward();
        stringBuilder.append(((ScannerImpl)style2).scanFlowScalarNonSpaces(bl, mark));
        while (((ScannerImpl)style2).reader.peek() != c2) {
            stringBuilder.append(((ScannerImpl)style2).scanFlowScalarSpaces(mark));
            stringBuilder.append(super.scanFlowScalarNonSpaces(bl, mark));
        }
        ((ScannerImpl)style2).reader.forward();
        style2 = ((ScannerImpl)style2).reader.getMark();
        ScalarToken tok = new ScalarToken(stringBuilder.toString(), false, mark, (Mark)style2, c);
        this.tokens.add((Token)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private List<Integer> scanYamlDirectiveValue(Mark startMark) {
        void var1_1;
        void var3_3;
        void var2_2;
        while (this.reader.peek() == ' ') {
            this.reader.forward();
        }
        Integer major = this.scanYamlDirectiveNumber(startMark);
        if (this.reader.peek() != '.') {
            throw new ScannerException("while scanning a directive", startMark, "expected a digit or '.', but found " + this.reader.peek() + "(" + this.reader.peek() + ")", this.reader.getMark());
        }
        this.reader.forward();
        Integer minor = this.scanYamlDirectiveNumber(startMark);
        if (Constant.NULL_BL_LINEBR.hasNo(this.reader.peek())) {
            throw new ScannerException("while scanning a directive", startMark, "expected a digit or ' ', but found " + this.reader.peek() + "(" + this.reader.peek() + ")", this.reader.getMark());
        }
        ArrayList<void> result = new ArrayList<void>(2);
        result.add(var2_2);
        result.add(var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer scanYamlDirectiveNumber(Mark startMark) {
        void var1_2;
        char ch = this.reader.peek();
        if (!Character.isDigit(ch)) {
            void var2_4;
            throw new ScannerException("while scanning a directive", startMark, "expected a digit, but found " + ch + "(" + (int)var2_4 + ")", this.reader.getMark());
        }
        int length = 0;
        while (Character.isDigit(this.reader.peek(length))) {
            ++length;
        }
        Integer n = Integer.parseInt(this.reader.prefixForward((int)var1_2));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> scanTagDirectiveValue(Mark startMark) {
        void var1_1;
        void var2_6;
        while (this.reader.peek() == ' ') {
            this.reader.forward();
        }
        Mark mark = startMark;
        ScannerImpl scannerImpl = this;
        String string = scannerImpl.scanTagHandle("directive", mark);
        char c = scannerImpl.reader.peek();
        if (c != ' ') {
            throw new ScannerException("while scanning a directive", mark, "expected ' ', but found " + scannerImpl.reader.peek() + "(" + c + ")", scannerImpl.reader.getMark());
        }
        String handle = string;
        while (this.reader.peek() == ' ') {
            this.reader.forward();
        }
        mark = startMark;
        scannerImpl = this;
        string = scannerImpl.scanTagUri("directive", mark);
        if (Constant.NULL_BL_LINEBR.hasNo(scannerImpl.reader.peek())) {
            throw new ScannerException("while scanning a directive", mark, "expected ' ', but found " + scannerImpl.reader.peek() + "(" + scannerImpl.reader.peek() + ")", scannerImpl.reader.getMark());
        }
        String prefix = string;
        ArrayList<void> result = new ArrayList<void>(2);
        result.add(var2_6);
        result.add(var1_1);
        return scannerImpl;
    }

    /*
     * WARNING - void declaration
     */
    private String scanDirectiveIgnoredLine(Mark startMark) {
        void var3_3;
        int ff = 0;
        while (this.reader.peek(ff) == ' ') {
            ++ff;
        }
        if (ff > 0) {
            this.reader.forward(ff);
        }
        if (this.reader.peek() == '#') {
            ff = 0;
            while (Constant.NULL_OR_LINEBR.hasNo(this.reader.peek(ff))) {
                ++ff;
            }
            this.reader.forward(ff);
        }
        char ch = this.reader.peek();
        String lineBreak = this.scanLineBreak();
        if (lineBreak.length() == 0 && ch != '\u0000') {
            void var2_2;
            void var1_1;
            throw new ScannerException("while scanning a directive", (Mark)var1_1, "expected a comment or a line break, but found " + ch + "(" + (int)var2_2 + ")", this.reader.getMark());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Token scanAnchor(boolean isAnchor) {
        void var1_2;
        void var3_5;
        void var2_3;
        Mark startMark = this.reader.getMark();
        char c = this.reader.peek();
        String name = c == '*' ? "alias" : "anchor";
        this.reader.forward();
        int length = 0;
        char ch = this.reader.peek(0);
        while (Constant.ALPHA.has(ch)) {
            ch = this.reader.peek(++length);
        }
        if (length == 0) {
            throw new ScannerException("while scanning an " + name, startMark, "expected alphabetic or numeric character, but found but found " + ch, this.reader.getMark());
        }
        String value = this.reader.prefixForward(length);
        ch = this.reader.peek();
        if (Constant.NULL_BL_T_LINEBR.hasNo(ch, "?:,]}%@`")) {
            throw new ScannerException("while scanning an " + name, startMark, "expected alphabetic or numeric character, but found " + ch + "(" + this.reader.peek() + ")", this.reader.getMark());
        }
        Mark endMark = this.reader.getMark();
        Token tok = isAnchor ? new AnchorToken(value, startMark, endMark) : new AliasToken(value, (Mark)var2_3, (Mark)var3_5);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private Token scanTag() {
        void var1_1;
        void var3_3;
        String useHandle22;
        String length2;
        String suffix;
        Mark startMark = this.reader.getMark();
        char ch = this.reader.peek(1);
        Object handle = null;
        if (ch == '<') {
            this.reader.forward(2);
            suffix = this.scanTagUri("tag", startMark);
            if (this.reader.peek() != '>') {
                throw new ScannerException("while scanning a tag", startMark, "expected '>', but found '" + this.reader.peek() + "' (" + this.reader.peek() + ")", this.reader.getMark());
            }
            this.reader.forward();
        } else if (Constant.NULL_BL_T_LINEBR.has(ch)) {
            suffix = "!";
            this.reader.forward();
        } else {
            int length2 = 1;
            boolean useHandle22 = false;
            while (Constant.NULL_BL_LINEBR.hasNo(ch)) {
                if (ch == '!') {
                    useHandle22 = true;
                    break;
                }
                ch = this.reader.peek(++length2);
            }
            if (useHandle22) {
                length2 = this.scanTagHandle("tag", startMark);
            } else {
                length2 = "!";
                this.reader.forward();
            }
            useHandle22 = this.scanTagUri("tag", startMark);
        }
        ch = this.reader.peek();
        if (Constant.NULL_BL_LINEBR.hasNo(ch)) {
            void var2_2;
            throw new ScannerException("while scanning a tag", startMark, "expected ' ', but found '" + ch + "' (" + (int)var2_2 + ")", this.reader.getMark());
        }
        TagTuple value = new TagTuple(length2, useHandle22);
        Mark endMark = this.reader.getMark();
        return new TagToken((TagTuple)var3_3, (Mark)var1_1, endMark);
    }

    /*
     * WARNING - void declaration
     */
    private String scanBlockScalarIgnoredLine(Mark startMark) {
        void var3_3;
        int ff = 0;
        while (this.reader.peek(ff) == ' ') {
            ++ff;
        }
        if (ff > 0) {
            this.reader.forward(ff);
        }
        if (this.reader.peek() == '#') {
            ff = 0;
            while (Constant.NULL_OR_LINEBR.hasNo(this.reader.peek(ff))) {
                ++ff;
            }
            if (ff > 0) {
                this.reader.forward(ff);
            }
        }
        char ch = this.reader.peek();
        String lineBreak = this.scanLineBreak();
        if (lineBreak.length() == 0 && ch != '\u0000') {
            void var2_2;
            void var1_1;
            throw new ScannerException("while scanning a block scalar", (Mark)var1_1, "expected a comment or a line break, but found " + (char)var2_2, this.reader.getMark());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] scanBlockScalarIndentation() {
        void var3_3;
        void var2_2;
        void var1_1;
        StringBuilder chunks = new StringBuilder();
        int maxIndent = 0;
        Mark endMark = this.reader.getMark();
        while (Constant.LINEBR.has(this.reader.peek(), " \r")) {
            if (this.reader.peek() != ' ') {
                chunks.append(this.scanLineBreak());
                endMark = this.reader.getMark();
                continue;
            }
            this.reader.forward();
            if (this.reader.getColumn() <= maxIndent) continue;
            maxIndent = this.reader.getColumn();
        }
        return new Object[]{var1_1.toString(), (int)var2_2, var3_3};
    }

    /*
     * WARNING - void declaration
     */
    private Object[] scanBlockScalarBreaks(int indent) {
        void var3_3;
        void var2_2;
        String lineBreak;
        int col;
        StringBuilder chunks = new StringBuilder();
        Mark endMark = this.reader.getMark();
        int ff22 = 0;
        for (col = this.reader.getColumn(); col < indent && this.reader.peek(ff22) == ' '; ++col) {
            ++ff22;
        }
        if (ff22 > 0) {
            this.reader.forward(ff22);
        }
        Object ff22 = null;
        while ((lineBreak = this.scanLineBreak()).length() != 0) {
            chunks.append(lineBreak);
            endMark = this.reader.getMark();
            int n = 0;
            for (col = this.reader.getColumn(); col < indent && this.reader.peek(n) == ' '; ++col) {
                ++n;
            }
            if (n <= 0) continue;
            this.reader.forward(n);
        }
        return new Object[]{var2_2.toString(), var3_3};
    }

    /*
     * WARNING - void declaration
     */
    private String scanFlowScalarNonSpaces(boolean doubleQuoted, Mark startMark) {
        void var3_3;
        block8: {
            void var2_2;
            char c;
            StringBuilder chunks = new StringBuilder();
            while (true) {
                c = '\u0000';
                while (Constant.NULL_BL_T_LINEBR.hasNo(this.reader.peek(c), "'\"\\")) {
                    ++c;
                }
                if (c != '\u0000') {
                    chunks.append(this.reader.prefixForward(c));
                }
                c = this.reader.peek();
                if (!doubleQuoted && c == '\'' && this.reader.peek(1) == '\'') {
                    chunks.append("'");
                    this.reader.forward(2);
                    continue;
                }
                if (doubleQuoted && c == '\'' || !doubleQuoted && "\"\\".indexOf(c) != -1) {
                    chunks.append(c);
                    this.reader.forward();
                    continue;
                }
                if (!doubleQuoted || c != 92) break block8;
                this.reader.forward();
                c = this.reader.peek();
                if (ESCAPE_REPLACEMENTS.containsKey(Character.valueOf(c))) {
                    chunks.append(ESCAPE_REPLACEMENTS.get(Character.valueOf(c)));
                    this.reader.forward();
                    continue;
                }
                if (ESCAPE_CODES.containsKey(Character.valueOf(c))) {
                    c = ESCAPE_CODES.get(Character.valueOf(c)).intValue();
                    this.reader.forward();
                    String hex = this.reader.prefix(c);
                    if (NOT_HEXA.matcher(hex).find()) {
                        throw new ScannerException("while scanning a double-quoted scalar", startMark, "expected escape sequence of " + c + " hexadecimal numbers, but found: " + hex, this.reader.getMark());
                    }
                    int decimal = Integer.parseInt(hex, 16);
                    String unicode = new String(Character.toChars(decimal));
                    chunks.append(unicode);
                    this.reader.forward(c);
                    continue;
                }
                if (this.scanLineBreak().length() == 0) break;
                chunks.append(this.scanFlowScalarBreaks(startMark));
            }
            throw new ScannerException("while scanning a double-quoted scalar", (Mark)var2_2, "found unknown escape character " + c + "(" + c + ")", this.reader.getMark());
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String scanFlowScalarSpaces(Mark startMark) {
        void var2_2;
        StringBuilder chunks = new StringBuilder();
        int length = 0;
        while (" \t".indexOf(this.reader.peek(length)) != -1) {
            ++length;
        }
        String whitespaces = this.reader.prefixForward(length);
        char c = this.reader.peek();
        if (c == '\u0000') {
            throw new ScannerException("while scanning a quoted scalar", startMark, "found unexpected end of stream", this.reader.getMark());
        }
        String lineBreak = this.scanLineBreak();
        if (lineBreak.length() != 0) {
            void var1_1;
            String breaks = this.scanFlowScalarBreaks(startMark);
            if (!"\n".equals(lineBreak)) {
                chunks.append(lineBreak);
            } else if (breaks.length() == 0) {
                chunks.append(" ");
            }
            chunks.append((String)var1_1);
        } else {
            void var3_4;
            chunks.append((String)var3_4);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String scanFlowScalarBreaks(Mark startMark) {
        void var2_2;
        StringBuilder chunks = new StringBuilder();
        while (true) {
            void var3_3;
            String prefix;
            if (("---".equals(prefix = this.reader.prefix(3)) || "...".equals(prefix)) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                throw new ScannerException("while scanning a quoted scalar", startMark, "found unexpected document separator", this.reader.getMark());
            }
            while (" \t".indexOf(this.reader.peek()) != -1) {
                this.reader.forward();
            }
            String lineBreak = this.scanLineBreak();
            if (lineBreak.length() == 0) break;
            chunks.append((String)var3_3);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private Token scanPlain() {
        void var3_3;
        void var2_2;
        void var1_1;
        Mark startMark;
        StringBuilder chunks = new StringBuilder();
        Mark endMark = startMark = this.reader.getMark();
        int indent = this.indent + 1;
        String spaces = "";
        do {
            char ch;
            int length = 0;
            if (this.reader.peek() == '#') break;
            while (!(Constant.NULL_BL_T_LINEBR.has(ch = this.reader.peek(length)) || this.flowLevel == 0 && ch == ':' && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(length + 1)) || this.flowLevel != 0 && ",:?[]{}".indexOf(ch) != -1)) {
                ++length;
            }
            if (this.flowLevel != 0 && ch == ':' && Constant.NULL_BL_T_LINEBR.hasNo(this.reader.peek(length + 1), ",[]{}")) {
                this.reader.forward(length);
                throw new ScannerException("while scanning a plain scalar", startMark, "found unexpected ':'", this.reader.getMark(), "Please check http://pyyaml.org/wiki/YAMLColonInFlowContext for details.");
            }
            if (length == 0) break;
            this.allowSimpleKey = false;
            chunks.append(spaces);
            chunks.append(this.reader.prefixForward(length));
            endMark = this.reader.getMark();
            spaces = this.scanPlainSpaces();
        } while (spaces.length() != 0 && this.reader.peek() != '#' && (this.flowLevel != 0 || this.reader.getColumn() >= indent));
        return new ScalarToken(var1_1.toString(), (Mark)var2_2, (Mark)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    private String scanPlainSpaces() {
        String string;
        int length = 0;
        while (this.reader.peek(length) == ' ' || this.reader.peek(length) == '\t') {
            ++length;
        }
        String whitespaces = this.reader.prefixForward(length);
        String lineBreak = this.scanLineBreak();
        if (lineBreak.length() != 0) {
            void var3_4;
            StringBuilder breaks;
            block7: {
                this.allowSimpleKey = true;
                String prefix = this.reader.prefix(3);
                if ("---".equals(prefix) || "...".equals(prefix) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                    return "";
                }
                breaks = new StringBuilder();
                while (true) {
                    if (this.reader.peek() == ' ') {
                        this.reader.forward();
                        continue;
                    }
                    String lb = this.scanLineBreak();
                    if (lb.length() == 0) break block7;
                    breaks.append(string);
                    string = this.reader.prefix(3);
                    if ("---".equals(string) || "...".equals(string) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) break;
                }
                return "";
            }
            if (!"\n".equals(lineBreak)) {
                void var2_3;
                return (String)var2_3 + breaks;
            }
            if (breaks.length() == 0) {
                return " ";
            }
            return var3_4.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String scanTagHandle(String name, Mark startMark) {
        String string;
        char ch = this.reader.peek();
        if (ch != '!') {
            throw new ScannerException("while scanning a " + name, startMark, "expected '!', but found " + ch + "(" + ch + ")", this.reader.getMark());
        }
        int length = 1;
        ch = this.reader.peek(1);
        if (ch != ' ') {
            while (Constant.ALPHA.has(ch)) {
                ch = this.reader.peek(++length);
            }
            if (ch != '!') {
                void var3_3;
                void var2_2;
                this.reader.forward(length);
                throw new ScannerException("while scanning a " + string, (Mark)var2_2, "expected '!', but found " + ch + "(" + (int)var3_3 + ")", this.reader.getMark());
            }
            ++length;
        }
        string = this.reader.prefixForward(length);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String scanTagUri(String name, Mark startMark) {
        void var3_3;
        StringBuilder chunks = new StringBuilder();
        int length = 0;
        char ch = this.reader.peek(0);
        while (Constant.URI_CHARS.has(ch)) {
            if (ch == '%') {
                chunks.append(this.reader.prefixForward(length));
                length = 0;
                chunks.append(this.scanUriEscapes(name, startMark));
            } else {
                ++length;
            }
            ch = this.reader.peek(length);
        }
        if (length != 0) {
            chunks.append(this.reader.prefixForward(length));
        }
        if (chunks.length() == 0) {
            void var2_2;
            void var1_1;
            throw new ScannerException("while scanning a " + (String)var1_1, (Mark)var2_2, "expected URI, but found " + ch + "(" + ch + ")", this.reader.getMark());
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String scanUriEscapes(String name, Mark startMark) {
        int length = 1;
        while (this.reader.peek(length * 3) == '%') {
            ++length;
        }
        Mark beginningMark = this.reader.getMark();
        ByteBuffer buff = ByteBuffer.allocate(length);
        while (this.reader.peek() == '%') {
            this.reader.forward();
            try {
                byte code = (byte)Integer.parseInt(this.reader.prefix(2), 16);
                buff.put(code);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ScannerException("while scanning a " + name, startMark, "expected URI escape sequence of 2 hexadecimal numbers, but found " + this.reader.peek() + "(" + this.reader.peek() + ") and " + this.reader.peek(1) + "(" + this.reader.peek(1) + ")", this.reader.getMark());
            }
            this.reader.forward(2);
        }
        buff.flip();
        try {
            void var3_4;
            return UriEncoder.decode((ByteBuffer)var3_4);
        }
        catch (CharacterCodingException e) {
            void var2_2;
            void var1_1;
            throw new ScannerException("while scanning a " + (String)var1_1, (Mark)var2_2, "expected URI in UTF-8: " + e.getMessage(), beginningMark);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String scanLineBreak() {
        char ch = this.reader.peek();
        if (ch == '\r' || ch == '\n' || ch == '\u0085') {
            if (ch == '\r' && '\n' == this.reader.peek(1)) {
                this.reader.forward(2);
            } else {
                this.reader.forward();
            }
            return "\n";
        }
        if (ch == '\u2028' || ch == '\u2029') {
            void var1_1;
            this.reader.forward();
            return String.valueOf((char)var1_1);
        }
        return "";
    }

    static {
        ESCAPE_REPLACEMENTS.put(Character.valueOf('0'), "\u0000");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('a'), "\u0007");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('b'), "\b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('t'), "\t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('n'), "\n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('v'), "\u000b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('f'), "\f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('r'), "\r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('e'), "\u001b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf(' '), " ");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('N'), "\u0085");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('_'), "\u00a0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('L'), "\u2028");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('P'), "\u2029");
        ESCAPE_CODES.put(Character.valueOf('x'), 2);
        ESCAPE_CODES.put(Character.valueOf('u'), 4);
        ESCAPE_CODES.put(Character.valueOf('U'), 8);
    }

    static final class Chomping {
        private final Boolean value;
        private final int increment;

        /*
         * WARNING - void declaration
         */
        public Chomping(Boolean value, int increment) {
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.increment = var2_2;
        }

        public final boolean chompTailIsNotFalse() {
            return this.value == null || this.value != false;
        }

        public final boolean chompTailIsTrue() {
            return this.value != null && this.value != false;
        }

        public final int getIncrement() {
            return this.increment;
        }
    }
}

