/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.nodes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.util.UriEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tag
implements Comparable<Tag> {
    public static final Tag YAML;
    public static final Tag VALUE;
    public static final Tag MERGE;
    public static final Tag SET;
    public static final Tag PAIRS;
    public static final Tag OMAP;
    public static final Tag BINARY;
    public static final Tag INT;
    public static final Tag FLOAT;
    public static final Tag TIMESTAMP;
    public static final Tag BOOL;
    public static final Tag NULL;
    public static final Tag STR;
    public static final Tag SEQ;
    public static final Tag MAP;
    private static Map<Tag, Set<Class<?>>> COMPATIBILITY_MAP;
    private final String value;

    /*
     * WARNING - void declaration
     */
    public Tag(String tag) {
        void var1_1;
        if (tag == null) {
            throw new NullPointerException("Tag must be provided.");
        }
        if (tag.length() == 0) {
            throw new IllegalArgumentException("Tag must not be empty.");
        }
        if (tag.trim().length() != tag.length()) {
            throw new IllegalArgumentException("Tag must not contain leading or trailing spaces.");
        }
        this.value = UriEncoder.encode((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Tag(Class<? extends Object> clazz) {
        void var1_1;
        if (clazz == null) {
            throw new NullPointerException("Class for tag must be provided.");
        }
        this.value = "tag:yaml.org,2002:" + UriEncoder.encode(var1_1.getName());
    }

    public final String getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startsWith(String prefix) {
        void var1_1;
        return this.value.startsWith((String)var1_1);
    }

    public final String getClassName() {
        if (!this.value.startsWith("tag:yaml.org,2002:")) {
            throw new YAMLException("Invalid tag: " + this.value);
        }
        return UriEncoder.decode(this.value.substring(18));
    }

    public final String toString() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj instanceof Tag) {
            obj = (Tag)obj;
            return this.value.equals(((Tag)obj).value);
        }
        if (obj instanceof String && this.value.equals(var1_1.toString())) {
            System.err.println("Comparing Tag and String is deprecated.");
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCompatible(Class<?> clazz) {
        Set<Class<?>> set = COMPATIBILITY_MAP.get(this);
        if (set != null) {
            void var1_1;
            void var2_2;
            return var2_2.contains(var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matches(Class<? extends Object> clazz) {
        void var1_1;
        return this.value.equals("tag:yaml.org,2002:" + var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        YAML = new Tag("tag:yaml.org,2002:yaml");
        VALUE = new Tag("tag:yaml.org,2002:value");
        MERGE = new Tag("tag:yaml.org,2002:merge");
        SET = new Tag("tag:yaml.org,2002:set");
        PAIRS = new Tag("tag:yaml.org,2002:pairs");
        OMAP = new Tag("tag:yaml.org,2002:omap");
        BINARY = new Tag("tag:yaml.org,2002:binary");
        INT = new Tag("tag:yaml.org,2002:int");
        FLOAT = new Tag("tag:yaml.org,2002:float");
        TIMESTAMP = new Tag("tag:yaml.org,2002:timestamp");
        BOOL = new Tag("tag:yaml.org,2002:bool");
        NULL = new Tag("tag:yaml.org,2002:null");
        STR = new Tag("tag:yaml.org,2002:str");
        SEQ = new Tag("tag:yaml.org,2002:seq");
        MAP = new Tag("tag:yaml.org,2002:map");
        COMPATIBILITY_MAP = new HashMap();
        HashSet<Class<BigDecimal>> floatSet = new HashSet<Class<BigDecimal>>();
        floatSet.add(Double.class);
        floatSet.add(Float.class);
        floatSet.add(BigDecimal.class);
        COMPATIBILITY_MAP.put(FLOAT, floatSet);
        HashSet<Class<BigInteger>> intSet = new HashSet<Class<BigInteger>>();
        intSet.add(Integer.class);
        intSet.add(Long.class);
        intSet.add(BigInteger.class);
        COMPATIBILITY_MAP.put(INT, intSet);
        HashSet<Class<Timestamp>> timestampSet = new HashSet<Class<Timestamp>>();
        timestampSet.add(Date.class);
        timestampSet.add(java.sql.Date.class);
        timestampSet.add(Timestamp.class);
        COMPATIBILITY_MAP.put(TIMESTAMP, (Set<Class<?>>)var0);
    }
}

