/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.StreamCipher;

public final class CipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher bufferedBlockCipher;
    private byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStream(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        super(outputStream);
        this.bufferedBlockCipher = bufferedBlockCipher;
        this.buf = new byte[bufferedBlockCipher.getBlockSize()];
    }

    public final void write(int n) throws IOException {
        this.oneByte[0] = (byte)n;
        if (this.bufferedBlockCipher != null) {
            n = this.bufferedBlockCipher.processBytes(this.oneByte, 0, 1, this.buf, 0);
            if (n != 0) {
                this.out.write(this.buf, 0, n);
            }
            return;
        }
        this.out.write(((StreamCipher)null).returnByte$132bd3());
    }

    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufferedBlockCipher != null) {
            byte[] byArray2 = new byte[this.bufferedBlockCipher.getOutputSize(n2)];
            int n3 = this.bufferedBlockCipher.processBytes(byArray, n, n2, byArray2, 0);
            if (n3 != 0) {
                this.out.write(byArray2, 0, n3);
            }
            return;
        }
        byte[] byArray3 = new byte[n2];
        this.out.write(byArray3, 0, n2);
    }

    public final void flush() throws IOException {
        super.flush();
    }

    public final void close() throws IOException {
        try {
            byte[] byArray;
            int n;
            if (this.bufferedBlockCipher != null && (n = this.bufferedBlockCipher.doFinal(byArray = new byte[this.bufferedBlockCipher.getOutputSize(0)], 0)) != 0) {
                this.out.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            throw new IOException("Error closing stream: " + exception.toString());
        }
        this.flush();
        super.close();
    }
}

