/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.Block;
import net.minecraft.server.BlockDoor;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Village;
import net.minecraft.server.VillageDoor;
import net.minecraft.server.World;

public class VillageCollection {
    private World world;
    private final List b = new ArrayList();
    private final List c = new ArrayList();
    private final List villages = new ArrayList();
    private int time = 0;

    public VillageCollection(World world) {
        this.world = world;
    }

    public void a(int n, int n2, int n3) {
        if (this.b.size() > 64) {
            return;
        }
        if (!this.d(n, n2, n3)) {
            this.b.add(new ChunkCoordinates(n, n2, n3));
        }
    }

    public void tick() {
        ++this.time;
        for (Village village : this.villages) {
            village.tick(this.time);
        }
        this.c();
        this.d();
        this.e();
    }

    private void c() {
        Iterator iterator = this.villages.iterator();
        while (iterator.hasNext()) {
            Village village = (Village)iterator.next();
            if (!village.isAbandoned()) continue;
            iterator.remove();
        }
    }

    public List getVillages() {
        return this.villages;
    }

    public Village getClosestVillage(int n, int n2, int n3, int n4) {
        Village village = null;
        float f = Float.MAX_VALUE;
        for (Village village2 : this.villages) {
            int n5;
            float f2 = village2.getCenter().e(n, n2, n3);
            if (f2 >= f || f2 > (float)((n5 = n4 + village2.getSize()) * n5)) continue;
            village = village2;
            f = f2;
        }
        return village;
    }

    private void d() {
        if (this.b.isEmpty()) {
            return;
        }
        this.a((ChunkCoordinates)this.b.remove(0));
    }

    private void e() {
        for (VillageDoor villageDoor : this.c) {
            boolean bl = false;
            for (Village village : this.villages) {
                int n;
                int n2 = (int)village.getCenter().e(villageDoor.locX, villageDoor.locY, villageDoor.locZ);
                if (n2 > (n = 32 + village.getSize()) * n) continue;
                village.addDoor(villageDoor);
                bl = true;
                break;
            }
            if (bl) continue;
            Village village = new Village(this.world);
            village.addDoor(villageDoor);
            this.villages.add(village);
        }
        this.c.clear();
    }

    private void a(ChunkCoordinates chunkCoordinates) {
        int n = 16;
        int n2 = 4;
        int n3 = 16;
        for (int i = chunkCoordinates.x - n; i < chunkCoordinates.x + n; ++i) {
            for (int j = chunkCoordinates.y - n2; j < chunkCoordinates.y + n2; ++j) {
                for (int k = chunkCoordinates.z - n3; k < chunkCoordinates.z + n3; ++k) {
                    if (!this.e(i, j, k)) continue;
                    VillageDoor villageDoor = this.b(i, j, k);
                    if (villageDoor == null) {
                        this.c(i, j, k);
                        continue;
                    }
                    villageDoor.addedTime = this.time;
                }
            }
        }
    }

    private VillageDoor b(int n, int n2, int n3) {
        for (Object object : this.c) {
            if (((VillageDoor)object).locX != n || ((VillageDoor)object).locZ != n3 || Math.abs(((VillageDoor)object).locY - n2) > 1) continue;
            return object;
        }
        for (Object object : this.villages) {
            VillageDoor villageDoor = ((Village)object).e(n, n2, n3);
            if (villageDoor == null) continue;
            return villageDoor;
        }
        return null;
    }

    private void c(int n, int n2, int n3) {
        int n4 = ((BlockDoor)Block.WOODEN_DOOR).d((IBlockAccess)this.world, n, n2, n3);
        if (n4 == 0 || n4 == 2) {
            int n5;
            int n6 = 0;
            for (n5 = -5; n5 < 0; ++n5) {
                if (!this.world.j(n + n5, n2, n3)) continue;
                --n6;
            }
            for (n5 = 1; n5 <= 5; ++n5) {
                if (!this.world.j(n + n5, n2, n3)) continue;
                ++n6;
            }
            if (n6 != 0) {
                this.c.add(new VillageDoor(n, n2, n3, n6 > 0 ? -2 : 2, 0, this.time));
            }
        } else {
            int n7;
            int n8 = 0;
            for (n7 = -5; n7 < 0; ++n7) {
                if (!this.world.j(n, n2, n3 + n7)) continue;
                --n8;
            }
            for (n7 = 1; n7 <= 5; ++n7) {
                if (!this.world.j(n, n2, n3 + n7)) continue;
                ++n8;
            }
            if (n8 != 0) {
                this.c.add(new VillageDoor(n, n2, n3, 0, n8 > 0 ? -2 : 2, this.time));
            }
        }
    }

    private boolean d(int n, int n2, int n3) {
        for (ChunkCoordinates chunkCoordinates : this.b) {
            if (chunkCoordinates.x != n || chunkCoordinates.y != n2 || chunkCoordinates.z != n3) continue;
            return true;
        }
        return false;
    }

    private boolean e(int n, int n2, int n3) {
        int n4 = this.world.getTypeId(n, n2, n3);
        return n4 == Block.WOODEN_DOOR.id;
    }
}

