/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.unix.Buffer;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.Iov;
import io.netty.channel.uring.LinuxSocket;
import io.netty.channel.uring.MsgHdr;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.SockaddrIn;
import io.netty.util.internal.CleanableDirectBuffer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

final class MsgHdrMemory {
    private static final byte[] EMPTY_SOCKADDR_STORAGE = new byte[Native.SIZEOF_SOCKADDR_STORAGE];
    private static final int GLOBAL_IOV_LEN = 1;
    private static final ByteBuffer GLOBAL_IOV_BASE = Buffer.allocateDirectWithNativeOrder(1);
    private static final long GLOBAL_IOV_BASE_ADDRESS = Buffer.memoryAddress(GLOBAL_IOV_BASE);
    private final CleanableDirectBuffer msgHdrMemoryCleanable;
    private final CleanableDirectBuffer socketAddrMemoryCleanable;
    private final CleanableDirectBuffer iovMemoryCleanable;
    private final CleanableDirectBuffer cmsgDataMemoryCleanable;
    private final ByteBuffer msgHdrMemory;
    private final ByteBuffer socketAddrMemory;
    private final ByteBuffer iovMemory;
    private final ByteBuffer cmsgDataMemory;
    private final long msgHdrMemoryAddress;
    private final short idx;
    private final int cmsgDataOffset;

    MsgHdrMemory(short idx) {
        this.idx = idx;
        this.msgHdrMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(Native.SIZEOF_MSGHDR);
        this.socketAddrMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(Native.SIZEOF_SOCKADDR_STORAGE);
        this.iovMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(Native.SIZEOF_IOVEC);
        this.cmsgDataMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(Native.CMSG_SPACE);
        this.msgHdrMemory = this.msgHdrMemoryCleanable.buffer();
        this.socketAddrMemory = this.socketAddrMemoryCleanable.buffer();
        this.iovMemory = this.iovMemoryCleanable.buffer();
        this.cmsgDataMemory = this.cmsgDataMemoryCleanable.buffer();
        this.msgHdrMemoryAddress = Buffer.memoryAddress(this.msgHdrMemory);
        long cmsgDataMemoryAddr = Buffer.memoryAddress(this.cmsgDataMemory);
        long cmsgDataAddr = Native.cmsghdrData(cmsgDataMemoryAddr);
        this.cmsgDataOffset = (int)(cmsgDataAddr - cmsgDataMemoryAddr);
    }

    MsgHdrMemory() {
        this.idx = 0;
        this.msgHdrMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(Native.SIZEOF_MSGHDR);
        this.socketAddrMemoryCleanable = null;
        this.iovMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(Native.SIZEOF_IOVEC);
        this.cmsgDataMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(Native.CMSG_SPACE_FOR_FD);
        this.msgHdrMemory = this.msgHdrMemoryCleanable.buffer();
        this.socketAddrMemory = null;
        this.iovMemory = this.iovMemoryCleanable.buffer();
        this.cmsgDataMemory = this.cmsgDataMemoryCleanable.buffer();
        this.msgHdrMemoryAddress = Buffer.memoryAddress(this.msgHdrMemory);
        Iov.set(this.iovMemory, GLOBAL_IOV_BASE_ADDRESS, 1);
        long cmsgDataMemoryAddr = Buffer.memoryAddress(this.cmsgDataMemory);
        long cmsgDataAddr = Native.cmsghdrData(cmsgDataMemoryAddr);
        this.cmsgDataOffset = (int)(cmsgDataAddr - cmsgDataMemoryAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(LinuxSocket socket, InetSocketAddress address, long bufferAddress, int length, short segmentSize) {
        int addressLength;
        if (address == null) {
            addressLength = socket.isIpv6() ? Native.SIZEOF_SOCKADDR_IN6 : Native.SIZEOF_SOCKADDR_IN;
            this.socketAddrMemory.mark();
            try {
                this.socketAddrMemory.put(EMPTY_SOCKADDR_STORAGE);
            }
            finally {
                this.socketAddrMemory.reset();
            }
        } else {
            addressLength = SockaddrIn.set(socket.isIpv6(), this.socketAddrMemory, address);
        }
        Iov.set(this.iovMemory, bufferAddress, length);
        MsgHdr.set(this.msgHdrMemory, this.socketAddrMemory, addressLength, this.iovMemory, 1, this.cmsgDataMemory, this.cmsgDataOffset, segmentSize);
    }

    void setScmRightsFd(int fd) {
        MsgHdr.prepSendFd(this.msgHdrMemory, fd, this.cmsgDataMemory, this.cmsgDataOffset, this.iovMemory, 1);
    }

    int getScmRightsFd() {
        return MsgHdr.getCmsgData(this.msgHdrMemory, this.cmsgDataMemory, this.cmsgDataOffset);
    }

    void prepRecvReadFd() {
        MsgHdr.prepReadFd(this.msgHdrMemory, this.cmsgDataMemory, this.cmsgDataOffset, this.iovMemory, 1);
    }

    boolean hasPort(IoUringDatagramChannel channel) {
        if (channel.socket.isIpv6()) {
            return SockaddrIn.hasPortIpv6(this.socketAddrMemory);
        }
        return SockaddrIn.hasPortIpv4(this.socketAddrMemory);
    }

    DatagramPacket get(IoUringDatagramChannel channel, IoUringIoHandler handler, ByteBuf buffer, int bytesRead) {
        InetSocketAddress sender;
        if (channel.socket.isIpv6()) {
            byte[] ipv6Bytes = handler.inet6AddressArray();
            byte[] ipv4bytes = handler.inet4AddressArray();
            sender = SockaddrIn.getIPv6(this.socketAddrMemory, ipv6Bytes, ipv4bytes);
        } else {
            byte[] bytes = handler.inet4AddressArray();
            sender = SockaddrIn.getIPv4(this.socketAddrMemory, bytes);
        }
        long bufferAddress = Iov.getBufferAddress(this.iovMemory);
        int bufferLength = Iov.getBufferLength(this.iovMemory);
        long memoryAddress = IoUring.memoryAddress(buffer);
        int readerIndex = (int)(bufferAddress - memoryAddress);
        ByteBuf slice = buffer.slice(readerIndex, bufferLength).writerIndex(bytesRead);
        return new DatagramPacket(slice.retain(), channel.localAddress(), sender);
    }

    short idx() {
        return this.idx;
    }

    long address() {
        return this.msgHdrMemoryAddress;
    }

    void release() {
        this.msgHdrMemoryCleanable.clean();
        if (this.socketAddrMemoryCleanable != null) {
            this.socketAddrMemoryCleanable.clean();
        }
        this.iovMemoryCleanable.clean();
        this.cmsgDataMemoryCleanable.clean();
    }
}

