/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.type;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import lombok.Generated;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class FloatTag
implements TypedTag {
    private float value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(12L);
        this.value = input.readFloat();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeFloat(this.value);
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Generated
    public float getValue() {
        return this.value;
    }

    @Generated
    public void setValue(float value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatTag)) {
            return false;
        }
        FloatTag other = (FloatTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getValue(), other.getValue()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FloatTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getValue());
        return result;
    }

    @Generated
    public String toString() {
        return "FloatTag(value=" + this.getValue() + ")";
    }

    @Generated
    public FloatTag() {
    }

    @Generated
    public FloatTag(float value) {
        this.value = value;
    }
}

