/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.OverflowPacketException;

public class LoginPayloadResponse
extends DefinedPacket {
    private int id;
    private byte[] data;

    @Override
    public void read(ByteBuf buf) {
        this.id = LoginPayloadResponse.readVarInt(buf);
        if (buf.readBoolean()) {
            int len = buf.readableBytes();
            if (len > 0x100000) {
                throw new OverflowPacketException("Payload may not be larger than 1048576 bytes");
            }
            this.data = new byte[len];
            buf.readBytes(this.data);
        }
    }

    @Override
    public void write(ByteBuf buf) {
        LoginPayloadResponse.writeVarInt(this.id, buf);
        if (this.data != null) {
            buf.writeBoolean(true);
            buf.writeBytes(this.data);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    @Generated
    public String toString() {
        return "LoginPayloadResponse(id=" + this.getId() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    @Generated
    public LoginPayloadResponse() {
    }

    @Generated
    public LoginPayloadResponse(int id, byte[] data) {
        this.id = id;
        this.data = data;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginPayloadResponse)) {
            return false;
        }
        LoginPayloadResponse other = (LoginPayloadResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoginPayloadResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }
}

