/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog.input;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.dialog.input.DialogInput;

public class TextInput
extends DialogInput {
    private Integer width;
    @NonNull
    private BaseComponent label;
    @SerializedName(value="label_visible")
    private Boolean labelVisible;
    private String initial;
    @SerializedName(value="max_length")
    private Integer maxLength;
    private Multiline multiline;

    public TextInput(@NonNull String key, @NonNull BaseComponent label) {
        this(key, null, label, null, null, null, null);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
    }

    public TextInput(@NonNull String key, Integer width, @NonNull BaseComponent label, Boolean labelVisible, String initial, Integer maxLength) {
        this(key, width, label, labelVisible, initial, maxLength, null);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
    }

    public TextInput(@NonNull String key, Integer width, @NonNull BaseComponent label, Boolean labelVisible, String initial, Integer maxLength, Multiline multiline) {
        super("minecraft:text", key);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.width(width);
        this.label = label;
        this.labelVisible = labelVisible;
        this.initial = initial;
        this.maxLength = maxLength;
        this.multiline = multiline;
    }

    public TextInput width(Integer width) {
        Preconditions.checkArgument(width == null || width >= 1 && width <= 1024, "width must be between 1 and 1024");
        this.width = width;
        return this;
    }

    @Generated
    public Integer width() {
        return this.width;
    }

    @NonNull
    @Generated
    public BaseComponent label() {
        return this.label;
    }

    @Generated
    public Boolean labelVisible() {
        return this.labelVisible;
    }

    @Generated
    public String initial() {
        return this.initial;
    }

    @Generated
    public Integer maxLength() {
        return this.maxLength;
    }

    @Generated
    public Multiline multiline() {
        return this.multiline;
    }

    @Generated
    public TextInput label(@NonNull BaseComponent label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    @Generated
    public TextInput labelVisible(Boolean labelVisible) {
        this.labelVisible = labelVisible;
        return this;
    }

    @Generated
    public TextInput initial(String initial) {
        this.initial = initial;
        return this;
    }

    @Generated
    public TextInput maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Generated
    public TextInput multiline(Multiline multiline) {
        this.multiline = multiline;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "TextInput(super=" + super.toString() + ", width=" + this.width() + ", label=" + this.label() + ", labelVisible=" + this.labelVisible() + ", initial=" + this.initial() + ", maxLength=" + this.maxLength() + ", multiline=" + this.multiline() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextInput)) {
            return false;
        }
        TextInput other = (TextInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$width = this.width();
        Integer other$width = other.width();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Boolean this$labelVisible = this.labelVisible();
        Boolean other$labelVisible = other.labelVisible();
        if (this$labelVisible == null ? other$labelVisible != null : !((Object)this$labelVisible).equals(other$labelVisible)) {
            return false;
        }
        Integer this$maxLength = this.maxLength();
        Integer other$maxLength = other.maxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        BaseComponent this$label = this.label();
        BaseComponent other$label = other.label();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        String this$initial = this.initial();
        String other$initial = other.initial();
        if (this$initial == null ? other$initial != null : !this$initial.equals(other$initial)) {
            return false;
        }
        Multiline this$multiline = this.multiline();
        Multiline other$multiline = other.multiline();
        return !(this$multiline == null ? other$multiline != null : !((Object)this$multiline).equals(other$multiline));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextInput;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $width = this.width();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Boolean $labelVisible = this.labelVisible();
        result = result * 59 + ($labelVisible == null ? 43 : ((Object)$labelVisible).hashCode());
        Integer $maxLength = this.maxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        BaseComponent $label = this.label();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        String $initial = this.initial();
        result = result * 59 + ($initial == null ? 43 : $initial.hashCode());
        Multiline $multiline = this.multiline();
        result = result * 59 + ($multiline == null ? 43 : ((Object)$multiline).hashCode());
        return result;
    }

    public static class Multiline {
        @SerializedName(value="max_lines")
        private Integer maxLines;
        private Integer height;

        public Multiline(Integer maxLines, Integer height) {
            this.height(height).maxLines(maxLines);
        }

        public Multiline height(Integer height) {
            Preconditions.checkArgument(height == null || height >= 1 && height <= 512, "height must null or be between 1 and 512");
            this.height = height;
            return this;
        }

        @Generated
        public Integer maxLines() {
            return this.maxLines;
        }

        @Generated
        public Integer height() {
            return this.height;
        }

        @Generated
        public Multiline maxLines(Integer maxLines) {
            this.maxLines = maxLines;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Multiline)) {
                return false;
            }
            Multiline other = (Multiline)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maxLines = this.maxLines();
            Integer other$maxLines = other.maxLines();
            if (this$maxLines == null ? other$maxLines != null : !((Object)this$maxLines).equals(other$maxLines)) {
                return false;
            }
            Integer this$height = this.height();
            Integer other$height = other.height();
            return !(this$height == null ? other$height != null : !((Object)this$height).equals(other$height));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Multiline;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxLines = this.maxLines();
            result = result * 59 + ($maxLines == null ? 43 : ((Object)$maxLines).hashCode());
            Integer $height = this.height();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TextInput.Multiline(maxLines=" + this.maxLines() + ", height=" + this.height() + ")";
        }

        @Generated
        public Multiline() {
        }
    }
}

