/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import lombok.Generated;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.connection.PingHandler;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class BungeeServerInfo
implements ServerInfo {
    private final String name;
    private final SocketAddress socketAddress;
    private final Collection<ProxiedPlayer> players = new ArrayList<ProxiedPlayer>();
    private final String motd;
    private final boolean restricted;
    private final Queue<DefinedPacket> packetQueue = new LinkedList<DefinedPacket>();
    private long lastPing;
    private ServerPing cachedPing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.add(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.remove(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new HashSet<ProxiedPlayer>(this.players));
        }
    }

    @Override
    public String getPermission() {
        return "bungeecord.server." + this.name;
    }

    @Override
    public boolean canAccess(CommandSender player) {
        Preconditions.checkNotNull(player, "player");
        return !this.restricted || player.hasPermission(this.getPermission());
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerInfo && Objects.equals(this.getAddress(), ((ServerInfo)obj).getAddress());
    }

    public int hashCode() {
        return this.socketAddress.hashCode();
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.sendData(channel, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendData(String channel, byte[] data, boolean queue) {
        Server server;
        Preconditions.checkNotNull(channel, "channel");
        Preconditions.checkNotNull(data, "data");
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            server = this.players.isEmpty() ? null : this.players.iterator().next().getServer();
        }
        if (server != null) {
            server.sendData(channel, data);
            return true;
        }
        if (queue) {
            collection = this.packetQueue;
            synchronized (collection) {
                this.packetQueue.add(new PluginMessage(channel, data, false));
            }
        }
        return false;
    }

    public void cachePing(ServerPing serverPing) {
        if (ProxyServer.getInstance().getConfig().getRemotePingCache() > 0) {
            this.cachedPing = serverPing;
            this.lastPing = System.currentTimeMillis();
        }
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.socketAddress;
    }

    @Override
    public void ping(Callback<ServerPing> callback) {
        this.ping(callback, ProxyServer.getInstance().getProtocolVersion());
    }

    public void ping(final Callback<ServerPing> callback, final int protocolVersion) {
        Preconditions.checkNotNull(callback, "callback");
        int pingCache = ProxyServer.getInstance().getConfig().getRemotePingCache();
        if (pingCache > 0 && this.cachedPing != null && System.currentTimeMillis() - this.lastPing > (long)pingCache) {
            this.cachedPing = null;
        }
        if (this.cachedPing != null) {
            callback.done(this.cachedPing, null);
            return;
        }
        ChannelFutureListener listener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    future.channel().pipeline().get(HandlerBoss.class).setHandler(new PingHandler(BungeeServerInfo.this, callback, protocolVersion));
                } else {
                    callback.done(null, future.cause());
                }
            }
        };
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel(this.socketAddress))).group(BungeeCord.getInstance().eventLoops)).handler(ProxyServer.getInstance().unsafe().getServerInfoChannelInitializer().getChannelInitializer())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, BungeeCord.getInstance().getConfig().getRemotePingTimeout())).remoteAddress(this.socketAddress).connect().addListener((GenericFutureListener)listener);
    }

    @Generated
    public BungeeServerInfo(String name, SocketAddress socketAddress, String motd, boolean restricted) {
        this.name = name;
        this.socketAddress = socketAddress;
        this.motd = motd;
        this.restricted = restricted;
    }

    @Generated
    public String toString() {
        return "BungeeServerInfo(name=" + this.getName() + ", socketAddress=" + this.getSocketAddress() + ", restricted=" + this.isRestricted() + ")";
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    @Override
    @Generated
    public String getMotd() {
        return this.motd;
    }

    @Override
    @Generated
    public boolean isRestricted() {
        return this.restricted;
    }

    @Generated
    public Queue<DefinedPacket> getPacketQueue() {
        return this.packetQueue;
    }
}

