/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.LongComparator;

public final class LongHeaps {
    private LongHeaps() {
    }

    public static int downHeap(long[] heap, int size, int i, LongComparator c) {
        assert (i < size);
        long e = heap[i];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size) {
                long t2 = heap[child];
                int right = child + 1;
                if (right < size && heap[right] < t2) {
                    child = right;
                    t2 = heap[child];
                }
                if (e > t2) {
                    heap[i] = t2;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size) {
                long t3 = heap[child];
                int right = child + 1;
                if (right < size && c.compare(heap[right], t3) < 0) {
                    child = right;
                    t3 = heap[child];
                }
                if (c.compare(e, t3) > 0) {
                    heap[i] = t3;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(long[] heap, int size, int i, LongComparator c) {
        assert (i < size);
        long e = heap[i];
        if (c == null) {
            int parent;
            long t2;
            while (i != 0 && (t2 = heap[parent = i - 1 >>> 1]) > e) {
                heap[i] = t2;
                i = parent;
            }
        } else {
            int parent;
            long t3;
            while (i != 0 && c.compare(t3 = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t3;
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(long[] heap, int size, LongComparator c) {
        int i = size >>> 1;
        while (i-- != 0) {
            LongHeaps.downHeap(heap, size, i, c);
        }
    }
}

