/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class IntArrayTag
implements TypedTag {
    private int[] value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(24L);
        int length = input.readInt();
        limiter.countBytes(length, 4L);
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = input.readInt();
        }
        this.value = data;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(this.value, "int array value cannot be null");
        output.writeInt(this.value.length);
        for (int i : this.value) {
            output.writeInt(i);
        }
    }

    @Override
    public byte getId() {
        return 11;
    }

    @Generated
    public int[] getValue() {
        return this.value;
    }

    @Generated
    public void setValue(int[] value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntArrayTag)) {
            return false;
        }
        IntArrayTag other = (IntArrayTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntArrayTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    @Generated
    public String toString() {
        return "IntArrayTag(value=" + Arrays.toString(this.getValue()) + ")";
    }

    @Generated
    public IntArrayTag() {
    }

    @Generated
    public IntArrayTag(int[] value) {
        this.value = value;
    }
}

