/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.type.ByteArrayTag;
import net.md_5.bungee.nbt.type.ByteTag;
import net.md_5.bungee.nbt.type.CompoundTag;
import net.md_5.bungee.nbt.type.DoubleTag;
import net.md_5.bungee.nbt.type.EndTag;
import net.md_5.bungee.nbt.type.FloatTag;
import net.md_5.bungee.nbt.type.IntArrayTag;
import net.md_5.bungee.nbt.type.IntTag;
import net.md_5.bungee.nbt.type.ListTag;
import net.md_5.bungee.nbt.type.LongArrayTag;
import net.md_5.bungee.nbt.type.LongTag;
import net.md_5.bungee.nbt.type.ShortTag;
import net.md_5.bungee.nbt.type.StringTag;

public final class TagUtil {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypedTag fromJson(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number = json.getAsNumber();
                if (number instanceof Byte) {
                    return new ByteTag((Byte)number);
                }
                if (number instanceof Short) {
                    return new ShortTag((Short)number);
                }
                if (number instanceof Integer) {
                    return new IntTag((Integer)number);
                }
                if (number instanceof Long) {
                    return new LongTag((Long)number);
                }
                if (number instanceof Float) {
                    return new FloatTag(((Float)number).floatValue());
                }
                if (!(number instanceof Double)) throw new IllegalArgumentException("Unknown JSON element: " + json);
                return new DoubleTag((Double)number);
            }
            if (jsonPrimitive.isString()) {
                return new StringTag(jsonPrimitive.getAsString());
            }
            if (!jsonPrimitive.isBoolean()) throw new IllegalArgumentException("Unknown JSON primitive: " + jsonPrimitive);
            return new ByteTag((byte)(jsonPrimitive.getAsBoolean() ? 1 : 0));
        }
        if (json instanceof JsonObject) {
            CompoundTag compoundTag = new CompoundTag(new LinkedHashMap<String, TypedTag>());
            for (Map.Entry<String, JsonElement> entry : ((JsonObject)json).entrySet()) {
                compoundTag.getValue().put(entry.getKey(), TagUtil.fromJson(entry.getValue()));
            }
            return compoundTag;
        }
        if (json instanceof JsonArray) {
            void var3_13;
            List<JsonElement> jsonArray = ((JsonArray)json).asList();
            Byte listType = null;
            for (JsonElement jsonEl : jsonArray) {
                byte type = TagUtil.fromJson(jsonEl).getId();
                if (listType == null) {
                    listType = type;
                    continue;
                }
                if (listType == type) continue;
                listType = 10;
                break;
            }
            if (listType == null) {
                return new ListTag(Collections.emptyList(), 0);
            }
            switch (listType) {
                case 1: {
                    byte[] bytes = new byte[jsonArray.size()];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = (Byte)jsonArray.get(i).getAsNumber();
                    }
                    ByteArrayTag byteArrayTag = new ByteArrayTag(bytes);
                    return var3_13;
                }
                case 3: {
                    int[] ints = new int[jsonArray.size()];
                    for (int i = 0; i < ints.length; ++i) {
                        ints[i] = (Integer)jsonArray.get(i).getAsNumber();
                    }
                    IntArrayTag intArrayTag = new IntArrayTag(ints);
                    return var3_13;
                }
                case 4: {
                    long[] longs = new long[jsonArray.size()];
                    for (int i = 0; i < longs.length; ++i) {
                        longs[i] = (Long)jsonArray.get(i).getAsNumber();
                    }
                    LongArrayTag longArrayTag = new LongArrayTag(longs);
                    return var3_13;
                }
                default: {
                    ArrayList<TypedTag> tagItems = new ArrayList<TypedTag>(jsonArray.size());
                    for (JsonElement jsonEl : jsonArray) {
                        TypedTag subTag = TagUtil.fromJson(jsonEl);
                        if (listType == 10 && !(subTag instanceof CompoundTag)) {
                            CompoundTag wrapper = new CompoundTag(new LinkedHashMap<String, TypedTag>());
                            wrapper.getValue().put("", subTag);
                            subTag = wrapper;
                        }
                        tagItems.add(subTag);
                    }
                    ListTag listTag = new ListTag(tagItems, listType);
                }
            }
            return var3_13;
        }
        if (!(json instanceof JsonNull)) throw new IllegalArgumentException("Unknown JSON element: " + json);
        return EndTag.INSTANCE;
    }

    public static JsonElement toJson(TypedTag tag) {
        switch (tag.getId()) {
            case 1: {
                return new JsonPrimitive(((ByteTag)tag).getValue());
            }
            case 2: {
                return new JsonPrimitive(((ShortTag)tag).getValue());
            }
            case 3: {
                return new JsonPrimitive(((IntTag)tag).getValue());
            }
            case 4: {
                return new JsonPrimitive(((LongTag)tag).getValue());
            }
            case 5: {
                return new JsonPrimitive(Float.valueOf(((FloatTag)tag).getValue()));
            }
            case 6: {
                return new JsonPrimitive(((DoubleTag)tag).getValue());
            }
            case 7: {
                byte[] byteArray = ((ByteArrayTag)tag).getValue();
                JsonArray jsonByteArray = new JsonArray(byteArray.length);
                for (byte b : byteArray) {
                    jsonByteArray.add(new JsonPrimitive(b));
                }
                return jsonByteArray;
            }
            case 8: {
                return new JsonPrimitive(((StringTag)tag).getValue());
            }
            case 9: {
                List<TypedTag> items = ((ListTag)tag).getValue();
                JsonArray jsonList = new JsonArray(items.size());
                for (TypedTag subTag : items) {
                    TypedTag first;
                    CompoundTag compound;
                    if (subTag instanceof CompoundTag && (compound = (CompoundTag)subTag).getValue().size() == 1 && (first = compound.getValue().get("")) != null) {
                        jsonList.add(TagUtil.toJson(first));
                        continue;
                    }
                    jsonList.add(TagUtil.toJson(subTag));
                }
                return jsonList;
            }
            case 10: {
                JsonObject jsonObject = new JsonObject();
                CompoundTag compoundTag = (CompoundTag)tag;
                compoundTag.getValue().forEach((key, value) -> jsonObject.add((String)key, TagUtil.toJson(value)));
                return jsonObject;
            }
            case 11: {
                int[] intArray = ((IntArrayTag)tag).getValue();
                JsonArray jsonIntArray = new JsonArray(intArray.length);
                for (int i : intArray) {
                    jsonIntArray.add(new JsonPrimitive(i));
                }
                return jsonIntArray;
            }
            case 12: {
                long[] longArray = ((LongArrayTag)tag).getValue();
                JsonArray jsonLongArray = new JsonArray(longArray.length);
                for (long l : longArray) {
                    jsonLongArray.add(new JsonPrimitive(l));
                }
                return jsonLongArray;
            }
        }
        throw new IllegalArgumentException("Unknown NBT tag: " + tag);
    }

    @Generated
    private TagUtil() {
    }
}

