/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.DialogBase;
import net.md_5.bungee.api.dialog.action.DialogSubmitAction;
import net.md_5.bungee.api.dialog.input.DialogInput;

public final class MultiActionInputFormDialog
implements Dialog {
    @NonNull
    private DialogBase base;
    @NonNull
    private List<DialogInput> inputs;
    @NonNull
    private List<DialogSubmitAction> actions;
    private Integer columns;

    public MultiActionInputFormDialog(@NonNull DialogBase base, @NonNull DialogInput input, @NonNull DialogSubmitAction action) {
        this(base, Arrays.asList(input), Arrays.asList(action), null);
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
    }

    public MultiActionInputFormDialog(@NonNull DialogBase base, @NonNull DialogInput input, @NonNull DialogSubmitAction action, Integer columns) {
        this(base, Arrays.asList(input), Arrays.asList(action), columns);
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
    }

    public MultiActionInputFormDialog(@NonNull DialogBase base, @NonNull List<DialogInput> inputs, @NonNull List<DialogSubmitAction> actions, Integer columns) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (inputs == null) {
            throw new NullPointerException("inputs is marked non-null but is null");
        }
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        Preconditions.checkArgument(!inputs.isEmpty(), "At least one input must be provided");
        Preconditions.checkArgument(!actions.isEmpty(), "At least one action must be provided");
        this.base = base;
        this.inputs = inputs;
        this.actions = actions;
        this.columns(columns);
    }

    public MultiActionInputFormDialog columns(Integer columns) {
        Preconditions.checkArgument(columns == null || columns > 0, "At least one column is required");
        this.columns = columns;
        return this;
    }

    @Override
    @NonNull
    @Generated
    public DialogBase getBase() {
        return this.base;
    }

    @NonNull
    @Generated
    public List<DialogInput> inputs() {
        return this.inputs;
    }

    @NonNull
    @Generated
    public List<DialogSubmitAction> actions() {
        return this.actions;
    }

    @Generated
    public Integer columns() {
        return this.columns;
    }

    @Override
    @Generated
    public void setBase(@NonNull DialogBase base) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
    }

    @Generated
    public MultiActionInputFormDialog inputs(@NonNull List<DialogInput> inputs) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked non-null but is null");
        }
        this.inputs = inputs;
        return this;
    }

    @Generated
    public MultiActionInputFormDialog actions(@NonNull List<DialogSubmitAction> actions) {
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        this.actions = actions;
        return this;
    }

    @Generated
    public String toString() {
        return "MultiActionInputFormDialog(base=" + this.getBase() + ", inputs=" + this.inputs() + ", actions=" + this.actions() + ", columns=" + this.columns() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiActionInputFormDialog)) {
            return false;
        }
        MultiActionInputFormDialog other = (MultiActionInputFormDialog)o;
        Integer this$columns = this.columns();
        Integer other$columns = other.columns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        DialogBase this$base = this.getBase();
        DialogBase other$base = other.getBase();
        if (this$base == null ? other$base != null : !((Object)this$base).equals(other$base)) {
            return false;
        }
        List<DialogInput> this$inputs = this.inputs();
        List<DialogInput> other$inputs = other.inputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<DialogSubmitAction> this$actions = this.actions();
        List<DialogSubmitAction> other$actions = other.actions();
        return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $columns = this.columns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        DialogBase $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : ((Object)$base).hashCode());
        List<DialogInput> $inputs = this.inputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<DialogSubmitAction> $actions = this.actions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        return result;
    }
}

