/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.DialogBase;

public final class DialogListDialog
implements Dialog {
    @NonNull
    private DialogBase base;
    private List<Dialog> dialogs;
    @SerializedName(value="on_cancel")
    private ClickEvent onCancel;
    private Integer columns;
    @SerializedName(value="button_width")
    private Integer buttonWidth;

    public DialogListDialog(@NonNull DialogBase base, Dialog ... dialogs) {
        this(base, Arrays.asList(dialogs), null, null, null);
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
    }

    public DialogListDialog(@NonNull DialogBase base, List<Dialog> dialogs, ClickEvent onCancel, Integer columns, Integer buttonWidth) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
        this.dialogs = dialogs;
        this.onCancel = onCancel;
        this.columns(columns);
        this.buttonWidth(buttonWidth);
    }

    public DialogListDialog columns(Integer columns) {
        Preconditions.checkArgument(columns == null || columns > 0, "At least one column is required");
        this.columns = columns;
        return this;
    }

    public DialogListDialog buttonWidth(Integer buttonWidth) {
        Preconditions.checkArgument(buttonWidth == null || buttonWidth >= 1 && buttonWidth <= 1024, "buttonWidth must be between 1 and 1024");
        this.buttonWidth = buttonWidth;
        return this;
    }

    @Override
    @NonNull
    @Generated
    public DialogBase getBase() {
        return this.base;
    }

    @Generated
    public List<Dialog> dialogs() {
        return this.dialogs;
    }

    @Generated
    public ClickEvent onCancel() {
        return this.onCancel;
    }

    @Generated
    public Integer columns() {
        return this.columns;
    }

    @Generated
    public Integer buttonWidth() {
        return this.buttonWidth;
    }

    @Override
    @Generated
    public void setBase(@NonNull DialogBase base) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
    }

    @Generated
    public DialogListDialog dialogs(List<Dialog> dialogs) {
        this.dialogs = dialogs;
        return this;
    }

    @Generated
    public DialogListDialog onCancel(ClickEvent onCancel) {
        this.onCancel = onCancel;
        return this;
    }

    @Generated
    public String toString() {
        return "DialogListDialog(base=" + this.getBase() + ", dialogs=" + this.dialogs() + ", onCancel=" + this.onCancel() + ", columns=" + this.columns() + ", buttonWidth=" + this.buttonWidth() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialogListDialog)) {
            return false;
        }
        DialogListDialog other = (DialogListDialog)o;
        Integer this$columns = this.columns();
        Integer other$columns = other.columns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Integer this$buttonWidth = this.buttonWidth();
        Integer other$buttonWidth = other.buttonWidth();
        if (this$buttonWidth == null ? other$buttonWidth != null : !((Object)this$buttonWidth).equals(other$buttonWidth)) {
            return false;
        }
        DialogBase this$base = this.getBase();
        DialogBase other$base = other.getBase();
        if (this$base == null ? other$base != null : !((Object)this$base).equals(other$base)) {
            return false;
        }
        List<Dialog> this$dialogs = this.dialogs();
        List<Dialog> other$dialogs = other.dialogs();
        if (this$dialogs == null ? other$dialogs != null : !((Object)this$dialogs).equals(other$dialogs)) {
            return false;
        }
        ClickEvent this$onCancel = this.onCancel();
        ClickEvent other$onCancel = other.onCancel();
        return !(this$onCancel == null ? other$onCancel != null : !((Object)this$onCancel).equals(other$onCancel));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $columns = this.columns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Integer $buttonWidth = this.buttonWidth();
        result = result * 59 + ($buttonWidth == null ? 43 : ((Object)$buttonWidth).hashCode());
        DialogBase $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : ((Object)$base).hashCode());
        List<Dialog> $dialogs = this.dialogs();
        result = result * 59 + ($dialogs == null ? 43 : ((Object)$dialogs).hashCode());
        ClickEvent $onCancel = this.onCancel();
        result = result * 59 + ($onCancel == null ? 43 : ((Object)$onCancel).hashCode());
        return result;
    }
}

