/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import lombok.Generated;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.ClearTitles;
import net.md_5.bungee.protocol.packet.Subtitle;
import net.md_5.bungee.protocol.packet.Title;
import net.md_5.bungee.protocol.packet.TitleTimes;

public class BungeeTitle
implements Title {
    private TitlePacketHolder<net.md_5.bungee.protocol.packet.Title> title;
    private TitlePacketHolder<Subtitle> subtitle;
    private TitlePacketHolder<TitleTimes> times;
    private TitlePacketHolder<ClearTitles> clear;
    private TitlePacketHolder<ClearTitles> reset;

    private static TitlePacketHolder<TitleTimes> createAnimationPacket() {
        TitlePacketHolder<TitleTimes> title = new TitlePacketHolder<TitleTimes>(new net.md_5.bungee.protocol.packet.Title(Title.Action.TIMES), new TitleTimes());
        ((TitlePacketHolder)title).oldPacket.setFadeIn(20);
        ((TitlePacketHolder)title).oldPacket.setStay(60);
        ((TitlePacketHolder)title).oldPacket.setFadeOut(20);
        ((TitleTimes)((TitlePacketHolder)title).newPacket).setFadeIn(20);
        ((TitleTimes)((TitlePacketHolder)title).newPacket).setStay(60);
        ((TitleTimes)((TitlePacketHolder)title).newPacket).setFadeOut(20);
        return title;
    }

    @Override
    public Title title(BaseComponent text) {
        if (this.title == null) {
            net.md_5.bungee.protocol.packet.Title packet = new net.md_5.bungee.protocol.packet.Title(Title.Action.TITLE);
            this.title = new TitlePacketHolder<net.md_5.bungee.protocol.packet.Title>(packet, packet);
        }
        ((TitlePacketHolder)this.title).oldPacket.setText(text);
        return this;
    }

    @Override
    public Title title(BaseComponent ... text) {
        return this.title(TextComponent.fromArray(text));
    }

    @Override
    public Title subTitle(BaseComponent text) {
        if (this.subtitle == null) {
            this.subtitle = new TitlePacketHolder<Subtitle>(new net.md_5.bungee.protocol.packet.Title(Title.Action.SUBTITLE), new Subtitle());
        }
        ((TitlePacketHolder)this.subtitle).oldPacket.setText(text);
        ((Subtitle)((TitlePacketHolder)this.subtitle).newPacket).setText(text);
        return this;
    }

    @Override
    public Title subTitle(BaseComponent ... text) {
        return this.subTitle(TextComponent.fromArray(text));
    }

    @Override
    public Title fadeIn(int ticks) {
        if (this.times == null) {
            this.times = BungeeTitle.createAnimationPacket();
        }
        ((TitlePacketHolder)this.times).oldPacket.setFadeIn(ticks);
        ((TitleTimes)((TitlePacketHolder)this.times).newPacket).setFadeIn(ticks);
        return this;
    }

    @Override
    public Title stay(int ticks) {
        if (this.times == null) {
            this.times = BungeeTitle.createAnimationPacket();
        }
        ((TitlePacketHolder)this.times).oldPacket.setStay(ticks);
        ((TitleTimes)((TitlePacketHolder)this.times).newPacket).setStay(ticks);
        return this;
    }

    @Override
    public Title fadeOut(int ticks) {
        if (this.times == null) {
            this.times = BungeeTitle.createAnimationPacket();
        }
        ((TitlePacketHolder)this.times).oldPacket.setFadeOut(ticks);
        ((TitleTimes)((TitlePacketHolder)this.times).newPacket).setFadeOut(ticks);
        return this;
    }

    @Override
    public Title clear() {
        if (this.clear == null) {
            this.clear = new TitlePacketHolder<ClearTitles>(new net.md_5.bungee.protocol.packet.Title(Title.Action.CLEAR), new ClearTitles());
        }
        this.title = null;
        return this;
    }

    @Override
    public Title reset() {
        if (this.reset == null) {
            this.reset = new TitlePacketHolder<ClearTitles>(new net.md_5.bungee.protocol.packet.Title(Title.Action.RESET), new ClearTitles(true));
        }
        this.title = null;
        this.subtitle = null;
        this.times = null;
        return this;
    }

    private static void sendPacket(ProxiedPlayer player, TitlePacketHolder packet) {
        if (packet != null) {
            if (player.getPendingConnection().getVersion() >= 755) {
                player.unsafe().sendPacketQueued(packet.newPacket);
            } else {
                player.unsafe().sendPacket(packet.oldPacket);
            }
        }
    }

    @Override
    public Title send(ProxiedPlayer player) {
        BungeeTitle.sendPacket(player, this.clear);
        BungeeTitle.sendPacket(player, this.reset);
        BungeeTitle.sendPacket(player, this.times);
        BungeeTitle.sendPacket(player, this.subtitle);
        BungeeTitle.sendPacket(player, this.title);
        return this;
    }

    private static class TitlePacketHolder<T extends DefinedPacket> {
        private final net.md_5.bungee.protocol.packet.Title oldPacket;
        private final T newPacket;

        @Generated
        public TitlePacketHolder(net.md_5.bungee.protocol.packet.Title oldPacket, T newPacket) {
            this.oldPacket = oldPacket;
            this.newPacket = newPacket;
        }

        @Generated
        public net.md_5.bungee.protocol.packet.Title getOldPacket() {
            return this.oldPacket;
        }

        @Generated
        public T getNewPacket() {
            return this.newPacket;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TitlePacketHolder)) {
                return false;
            }
            TitlePacketHolder other = (TitlePacketHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            net.md_5.bungee.protocol.packet.Title this$oldPacket = this.getOldPacket();
            net.md_5.bungee.protocol.packet.Title other$oldPacket = other.getOldPacket();
            if (this$oldPacket == null ? other$oldPacket != null : !((Object)this$oldPacket).equals(other$oldPacket)) {
                return false;
            }
            T this$newPacket = this.getNewPacket();
            T other$newPacket = other.getNewPacket();
            return !(this$newPacket == null ? other$newPacket != null : !this$newPacket.equals(other$newPacket));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TitlePacketHolder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            net.md_5.bungee.protocol.packet.Title $oldPacket = this.getOldPacket();
            result = result * 59 + ($oldPacket == null ? 43 : ((Object)$oldPacket).hashCode());
            T $newPacket = this.getNewPacket();
            result = result * 59 + ($newPacket == null ? 43 : $newPacket.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BungeeTitle.TitlePacketHolder(oldPacket=" + this.getOldPacket() + ", newPacket=" + this.getNewPacket() + ")";
        }
    }
}

