/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.channel.unix.Buffer;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringBufferRingAllocator;
import io.netty.channel.uring.IoUringBufferRingExhaustedEvent;
import io.netty.channel.uring.Native;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

final class IoUringBufferRing {
    private static final VarHandle SHORT_HANDLE = MethodHandles.byteBufferViewVarHandle(short[].class, ByteOrder.nativeOrder());
    private final ByteBuffer ioUringBufRing;
    private final int tailFieldPosition;
    private final short entries;
    private final int batchSize;
    private final int maxUnreleasedBuffers;
    private final short mask;
    private final short bufferGroupId;
    private final int ringFd;
    private final IoUringBufferRingByteBuf[] buffers;
    private final IoUringBufferRingAllocator allocator;
    private final IoUringBufferRingExhaustedEvent exhaustedEvent;
    private final boolean incremental;
    private final AtomicInteger unreleasedBuffers = new AtomicInteger();
    private volatile boolean usable;
    private boolean corrupted;
    private boolean closed;
    private int numBuffers;
    private boolean expanded;

    IoUringBufferRing(int ringFd, ByteBuffer ioUringBufRing, short entries, int batchSize, int maxUnreleasedBuffers, short bufferGroupId, boolean incremental, IoUringBufferRingAllocator allocator) {
        assert (entries % 2 == 0);
        this.ioUringBufRing = ioUringBufRing;
        this.tailFieldPosition = Native.IO_URING_BUFFER_RING_TAIL;
        this.entries = entries;
        this.batchSize = batchSize;
        this.maxUnreleasedBuffers = maxUnreleasedBuffers;
        this.mask = (short)(entries - 1);
        this.bufferGroupId = bufferGroupId;
        this.ringFd = ringFd;
        this.buffers = new IoUringBufferRingByteBuf[entries];
        this.incremental = incremental;
        this.allocator = allocator;
        this.exhaustedEvent = new IoUringBufferRingExhaustedEvent(bufferGroupId);
    }

    boolean isUsable() {
        return !this.corrupted && this.usable;
    }

    void initialize() {
        this.fillBuffers();
        this.usable = true;
    }

    void expand() {
        if (!this.expanded) {
            this.fillBuffers();
            this.expanded = true;
        }
    }

    private void fillBuffers() {
        int num = Math.min(this.batchSize, this.entries - this.numBuffers);
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            this.fillBuffer();
        }
    }

    IoUringBufferRingExhaustedEvent getExhaustedEvent() {
        return this.exhaustedEvent;
    }

    void fillBuffer() {
        ByteBuf byteBuf;
        if (this.corrupted || this.closed) {
            return;
        }
        short oldTail = SHORT_HANDLE.get(this.ioUringBufRing, this.tailFieldPosition);
        short ringIndex = (short)(oldTail & this.mask);
        assert (this.buffers[ringIndex] == null);
        try {
            byteBuf = this.allocator.allocate();
        }
        catch (OutOfMemoryError e) {
            this.corrupted = true;
            throw e;
        }
        byteBuf.writerIndex(byteBuf.capacity());
        this.buffers[ringIndex] = new IoUringBufferRingByteBuf(byteBuf);
        int position = Native.SIZEOF_IOURING_BUF * ringIndex;
        this.ioUringBufRing.putLong(position + Native.IOURING_BUFFER_OFFSETOF_ADDR, IoUring.memoryAddress(byteBuf) + (long)byteBuf.readerIndex());
        this.ioUringBufRing.putInt(position + Native.IOURING_BUFFER_OFFSETOF_LEN, byteBuf.capacity());
        this.ioUringBufRing.putShort(position + Native.IOURING_BUFFER_OFFSETOF_BID, ringIndex);
        SHORT_HANDLE.setRelease(this.ioUringBufRing, this.tailFieldPosition, (short)(oldTail + 1));
        ++this.numBuffers;
        this.expanded = false;
    }

    int attemptedBytesRead(short bid) {
        return this.buffers[bid].readableBytes();
    }

    ByteBuf useBuffer(short bid, int readableBytes, boolean more) {
        assert (readableBytes > 0);
        IoUringBufferRingByteBuf byteBuf = this.buffers[bid];
        this.allocator.lastBytesRead(byteBuf.readableBytes(), readableBytes);
        if (this.incremental && more && byteBuf.readableBytes() > readableBytes) {
            return byteBuf.readRetainedSlice(readableBytes);
        }
        this.buffers[bid] = null;
        --this.numBuffers;
        byteBuf.markUsed();
        return byteBuf.writerIndex(byteBuf.readerIndex() + Math.min(readableBytes, byteBuf.readableBytes()));
    }

    short nextBid(short bid) {
        return (short)(bid + 1 & this.mask);
    }

    short bufferGroupId() {
        return this.bufferGroupId;
    }

    void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Native.ioUringUnRegisterBufRing(this.ringFd, Buffer.memoryAddress(this.ioUringBufRing), this.entries, this.bufferGroupId);
        for (IoUringBufferRingByteBuf byteBuf : this.buffers) {
            if (byteBuf == null) continue;
            byteBuf.release();
        }
        Arrays.fill(this.buffers, null);
    }

    final class IoUringBufferRingByteBuf
    extends WrappedByteBuf {
        IoUringBufferRingByteBuf(ByteBuf buf) {
            super(buf);
        }

        void markUsed() {
            if (IoUringBufferRing.this.unreleasedBuffers.incrementAndGet() == IoUringBufferRing.this.maxUnreleasedBuffers) {
                IoUringBufferRing.this.usable = false;
            }
        }

        @Override
        public ByteBuf order(ByteOrder endianness) {
            if (endianness == this.order()) {
                return this;
            }
            return new SwappedByteBuf(this);
        }

        @Override
        public ByteBuf slice() {
            return this.slice(this.readerIndex(), this.readableBytes());
        }

        @Override
        public ByteBuf retainedSlice() {
            return this.slice().retain();
        }

        @Override
        public ByteBuf slice(int index, int length) {
            return new SlicedByteBuf(this, index, length);
        }

        @Override
        public ByteBuf retainedSlice(int index, int length) {
            return this.slice(index, length).retain();
        }

        @Override
        public ByteBuf readSlice(int length) {
            ByteBuf slice = this.slice(this.readerIndex(), length);
            this.skipBytes(length);
            return slice;
        }

        @Override
        public ByteBuf readRetainedSlice(int length) {
            ByteBuf slice = this.retainedSlice(this.readerIndex(), length);
            try {
                this.skipBytes(length);
            }
            catch (Throwable cause) {
                slice.release();
                throw cause;
            }
            return slice;
        }

        @Override
        public ByteBuf duplicate() {
            return new DuplicatedByteBuf(this);
        }

        @Override
        public ByteBuf retainedDuplicate() {
            return this.duplicate().retain();
        }

        @Override
        public boolean release() {
            if (super.release()) {
                this.released();
                return true;
            }
            return false;
        }

        @Override
        public boolean release(int decrement) {
            if (super.release(decrement)) {
                this.released();
                return true;
            }
            return false;
        }

        private void released() {
            if (IoUringBufferRing.this.unreleasedBuffers.decrementAndGet() == IoUringBufferRing.this.maxUnreleasedBuffers / 2) {
                IoUringBufferRing.this.usable = true;
            }
        }
    }
}

